/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.javacore.parser.j9.section.monitor;

import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.java.JavaMonitor;
import com.ibm.dtfj.javacore.builder.BuilderFailureException;
import com.ibm.dtfj.javacore.builder.IImageProcessBuilder;
import com.ibm.dtfj.javacore.builder.IJavaRuntimeBuilder;
import com.ibm.dtfj.javacore.parser.framework.parser.ParserException;
import com.ibm.dtfj.javacore.parser.j9.IAttributeValueMap;
import com.ibm.dtfj.javacore.parser.j9.SectionParser;
import com.ibm.dtfj.javacore.parser.j9.section.monitor.IMonitorTypes;

public class MonitorSectionParser
extends SectionParser
implements IMonitorTypes {
    private IJavaRuntimeBuilder fRuntimeBuilder;
    private IImageProcessBuilder fImageProcessBuilder;

    public MonitorSectionParser() {
        super("LOCKS");
    }

    protected void topLevelRule() throws ParserException {
        this.poolInfo();
        this.objectLocks();
        this.systemLocks();
        this.sovOnlyRules("1LKREGMONDUMP");
    }

    private void poolInfo() throws ParserException {
        this.fImageProcessBuilder = this.fImageBuilder.getCurrentAddressSpaceBuilder().getCurrentImageProcessBuilder();
        this.fRuntimeBuilder = this.fImageProcessBuilder.getCurrentJavaRuntimeBuilder();
        this.processTagLineRequired("1LKPOOLINFO");
        this.sovOnlyRules("1LKPOOLINFO");
        this.processTagLineRequired("2LKPOOLTOTAL");
        this.sovOnlyRules("2LKPOOLTOTAL");
    }

    private void objectLocks() throws ParserException {
        this.processTagLineRequired("1LKMONPOOLDUMP");
        this.monitorsInUse();
    }

    private void systemLocks() throws ParserException {
        this.processTagLineRequired("1LKREGMONDUMP");
        this.registeredMonitors();
    }

    private void monitorsInUse() throws ParserException {
        IAttributeValueMap results = null;
        while ((results = this.processTagLineOptional("2LKMONINUSE")) != null) {
            long monitorID = results.getLongValue("mon_system_monitor");
            long objectID = -1L;
            String className = null;
            long monitorThreadID = -1L;
            results = this.processTagLineRequired("3LKMONOBJECT");
            if (results != null) {
                className = results.getTokenValue("mon_obj_full_java_name");
                objectID = results.getLongValue("monitor_object_address");
                monitorThreadID = results.getLongValue("monitor_thread_id");
            }
            try {
                this.generateMonitor(null, monitorID, objectID, className, monitorThreadID);
            }
            catch (BuilderFailureException e) {
                this.handleError("Could not add monitor to builder: " + monitorID, e);
            }
        }
    }

    private JavaMonitor generateMonitor(String monitorName, long monitorID, long objectID, String className, long owningThread) throws ParserException, BuilderFailureException {
        JavaMonitor monitor = this.fRuntimeBuilder.addJavaMonitor(monitorName, monitorID, objectID, className, owningThread);
        this.waitOnNotifyOrEnter(monitor);
        return monitor;
    }

    /*
     * Unable to fully structure code
     */
    private void waitOnNotifyOrEnter(JavaMonitor monitor) throws ParserException {
        waitOnNotify = false;
        tagName = null;
        block0: while (true) {
            tagName = "3LKNOTIFYQ";
            waitOnNotify = this.matchOptional("3LKNOTIFYQ");
            if (!waitOnNotify && !this.matchOptional("3LKWAITERQ")) break;
            this.consume();
            token = this.lookAhead(1);
            if (token != null && token.getType().equals("UNPARSED")) {
                this.consume();
            }
            tagName = waitOnNotify != false ? "3LKWAITNOTIFY" : "3LKWAITER";
            results = null;
            results = this.processTagLineRequired(tagName);
            if (results == null) continue;
            this.processNotifyOrEnterThreads(monitor, results, waitOnNotify);
            while (true) {
                if ((results = this.processTagLineOptional(tagName)) != null) ** break;
                continue block0;
                this.processNotifyOrEnterThreads(monitor, results, waitOnNotify);
            }
            break;
        }
    }

    private void processNotifyOrEnterThreads(JavaMonitor monitor, IAttributeValueMap results, boolean waitOnNotify) throws ParserException {
        String threadName = results.getTokenValue("monitor_thd_name");
        long threadID = results.getLongValue("monitor_thread_id");
        try {
            if (waitOnNotify) {
                this.fRuntimeBuilder.addWaitOnNotifyThread(monitor, threadID);
            } else {
                this.fRuntimeBuilder.addBlockedThread(monitor, threadID);
            }
        }
        catch (BuilderFailureException e) {
            String message = waitOnNotify ? "Could not add wait on notify thread" : "could not add blocked thread";
            message = message + ", thread name: " + threadName + ", thread ID: " + threadID;
            ImagePointer id = monitor.getID();
            if (id != null) {
                message = message + ", monitor ID: " + id.getAddress();
            }
            this.handleError(message, e);
        }
    }

    private void registeredMonitors() throws ParserException {
        IAttributeValueMap results = null;
        while ((results = this.processTagLineOptional("2LKREGMON")) != null) {
            this.processRegMonitors(results);
        }
    }

    private void processRegMonitors(IAttributeValueMap results) throws ParserException {
        if (results != null) {
            String monitorName = results.getTokenValue("mon_monitor_name");
            long monitorID = results.getLongValue("mon_monitor_address");
            try {
                this.generateMonitor(monitorName, monitorID, -1L, null, -1L);
            }
            catch (BuilderFailureException e) {
                this.handleError("Failed to add monitor: " + monitorName + ", " + monitorID, e);
            }
        }
    }

    protected void sovOnlyRules(String startingTag) throws ParserException {
    }
}

