/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.javacore.parser.j9.section.environment;

import com.ibm.dtfj.javacore.builder.BuilderFailureException;
import com.ibm.dtfj.javacore.builder.IImageProcessBuilder;
import com.ibm.dtfj.javacore.builder.IJavaRuntimeBuilder;
import com.ibm.dtfj.javacore.parser.framework.parser.ParserException;
import com.ibm.dtfj.javacore.parser.j9.IAttributeValueMap;
import com.ibm.dtfj.javacore.parser.j9.SectionParser;
import com.ibm.dtfj.javacore.parser.j9.section.environment.IEnvironmentTypes;

public class EnvironmentSectionParser
extends SectionParser
implements IEnvironmentTypes {
    private IImageProcessBuilder fImageProcessBuilder;
    private IJavaRuntimeBuilder fRuntimeBuilder;

    public EnvironmentSectionParser() {
        super("ENVINFO");
    }

    protected void topLevelRule() throws ParserException {
        this.fImageProcessBuilder = this.fImageBuilder.getCurrentAddressSpaceBuilder().getCurrentImageProcessBuilder();
        this.fRuntimeBuilder = this.fImageProcessBuilder.getCurrentJavaRuntimeBuilder();
        this.parseVersion();
        this.parseUserArgs();
        this.parseJVMMI();
    }

    private void parseVersion() throws ParserException {
        IAttributeValueMap results = null;
        this.processTagLineOptional("1CIJAVAVERSION");
        this.processTagLineOptional("1CIVMVERSION");
        this.processTagLineOptional("1CIJITVERSION");
        this.processTagLineOptional("1CIRUNNINGAS");
        results = this.processTagLineOptional("1CICMDLINE");
        if (results != null) {
            String cmdLine = results.getTokenValue("environment_cmd_line");
            this.fImageProcessBuilder.setCommandLine(cmdLine);
        }
        this.processTagLineOptional("1CIJAVAHOMEDIR");
        this.processTagLineOptional("1CIJAVADLLDIR");
        this.processTagLineOptional("1CISYSCP");
    }

    private void parseUserArgs() throws ParserException {
        IAttributeValueMap results = null;
        this.processTagLineRequired("1CIUSERARGS");
        try {
            this.fRuntimeBuilder.addVMInitArgs();
        }
        catch (BuilderFailureException e) {
            this.handleError("Failed to add JavaVMInitArgs to builder: ", e);
        }
        while ((results = this.processTagLineOptional("2CIUSERARG")) != null) {
            String argString = results.getTokenValue("environment_arg_string");
            long extraInfo = results.getLongValue("environment_arg_extra");
            try {
                if (extraInfo == -1L) {
                    this.fRuntimeBuilder.addVMOption(argString);
                    continue;
                }
                this.fRuntimeBuilder.addVMOption(argString, extraInfo);
            }
            catch (BuilderFailureException e) {
                this.handleError("Failed to add VM option to builder: " + argString + " ", e);
            }
        }
    }

    private void parseJVMMI() throws ParserException {
        this.processTagLineOptional("1CIJVMMI");
        this.processTagLineOptional("2CIJVMMIOFF");
    }

    protected void sovOnlyRules(String startingTag) throws ParserException {
    }
}

