/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.javacore.parser.j9;

import com.ibm.dtfj.image.Image;
import com.ibm.dtfj.javacore.builder.IImageBuilderFactory;
import com.ibm.dtfj.javacore.parser.framework.parser.ParserException;
import com.ibm.dtfj.javacore.parser.j9.DTFJComponentLoader;
import com.ibm.dtfj.javacore.parser.j9.J9TagManager;
import com.ibm.dtfj.javacore.parser.j9.ParserController;
import com.ibm.dtfj.javacore.parser.j9.registered.RegisteredComponents;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;

public class JavaCoreReader {
    private RegisteredComponents fComponents;
    private IImageBuilderFactory fImageBuilderFactory;

    public JavaCoreReader(IImageBuilderFactory imageBuilderFactory) {
        this.fImageBuilderFactory = imageBuilderFactory;
        this.fComponents = new RegisteredComponents();
    }

    public Image generateImage(InputStream input) throws IOException {
        try {
            InputStreamReader reader = new InputStreamReader(input);
            List frameworkSections = new DTFJComponentLoader().loadSections();
            ParserController parserController = new ParserController(frameworkSections, this.fImageBuilderFactory);
            J9TagManager tagManager = J9TagManager.getCurrent();
            return parserController.parse(this.fComponents.getScannerManager(reader, tagManager));
        }
        catch (ParserException e) {
            throw new IOException("Error parsing");
        }
    }
}

