/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.javacore.parser.framework.scanner;

import com.ibm.dtfj.javacore.parser.framework.parser.ILookAheadBuffer;
import com.ibm.dtfj.javacore.parser.framework.scanner.IParserToken;
import com.ibm.dtfj.javacore.parser.framework.scanner.IScanner;
import java.io.IOException;
import java.util.ArrayList;

public class LookAheadBuffer
implements ILookAheadBuffer {
    private ArrayList fBuffer;
    private int fCurrentDepth;
    private IScanner fScanner;

    public LookAheadBuffer(int size, IScanner scanner) {
        this.fCurrentDepth = size;
        this.fBuffer = new ArrayList(this.fCurrentDepth);
        this.fScanner = scanner;
    }

    public boolean match(String tokenType) {
        boolean result = false;
        if (this.fBuffer.size() > 0) {
            IParserToken token = (IParserToken)this.fBuffer.get(0);
            result = token != null ? token.getType().equals(tokenType) : tokenType == null;
        }
        return result;
    }

    public void consume() throws IOException {
        if (this.fBuffer.size() > 0) {
            this.fBuffer.remove(0);
        }
        this.fill();
    }

    public boolean allConsumed() {
        return this.fScanner.allTokensGenerated() && this.fBuffer.isEmpty();
    }

    private void fill() throws IOException {
        while (!this.fScanner.allTokensGenerated() && this.fBuffer.size() < this.fCurrentDepth) {
            IParserToken token = this.fScanner.next();
            this.fBuffer.add(token);
        }
    }

    public IParserToken lookAhead(int depth) throws IOException {
        this.fill();
        return (IParserToken)this.fBuffer.get(depth - 1);
    }

    public void init() throws IOException {
        this.fill();
    }

    public void setLookAheadDepth(int depth) throws IOException {
        if (depth > 0) {
            this.fCurrentDepth = depth;
            this.fill();
        }
    }

    public int length() {
        return this.fBuffer.size();
    }

    public int maxDepth() {
        return this.fCurrentDepth;
    }
}

