/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.java.javacore;

import com.ibm.dtfj.image.CorruptData;
import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.javacore.JCCorruptData;
import com.ibm.dtfj.java.JavaLocation;
import com.ibm.dtfj.java.JavaMethod;
import com.ibm.dtfj.java.javacore.JCInvalidArgumentsException;

public class JCJavaLocation
implements JavaLocation {
    private final JavaMethod fMethod;
    private ImagePointer fAddress;
    private int fCompilationLevel;
    private String fFileName;
    private int fLineNumber;

    public JCJavaLocation(JavaMethod javaMethod) throws JCInvalidArgumentsException {
        if (javaMethod == null) {
            throw new JCInvalidArgumentsException("A java location must be associated with a java method");
        }
        this.fMethod = javaMethod;
        this.fAddress = null;
        this.fCompilationLevel = -1;
        this.fFileName = null;
        this.fLineNumber = -1;
    }

    public ImagePointer getAddress() throws CorruptDataException {
        if (this.fAddress == null) {
            throw new CorruptDataException((CorruptData)new JCCorruptData(null));
        }
        return this.fAddress;
    }

    public void setAddress(ImagePointer address) {
        this.fAddress = address;
    }

    public int getCompilationLevel() throws CorruptDataException {
        if (this.fCompilationLevel == -1) {
            throw new CorruptDataException((CorruptData)new JCCorruptData(null));
        }
        return this.fCompilationLevel;
    }

    public void setCompilation(String compilationLevel) {
    }

    public String getFilename() throws DataUnavailable, CorruptDataException {
        if (this.fFileName == null) {
            throw new DataUnavailable();
        }
        return this.fFileName;
    }

    public void setFilename(String fileName) {
        this.fFileName = fileName;
    }

    public int getLineNumber() throws DataUnavailable, CorruptDataException {
        if (this.fLineNumber == -1) {
            throw new DataUnavailable();
        }
        return this.fLineNumber;
    }

    public void setLineNumber(int lineNumber) {
        this.fLineNumber = lineNumber;
    }

    public JavaMethod getMethod() throws CorruptDataException {
        if (this.fMethod == null) {
            throw new CorruptDataException((CorruptData)new JCCorruptData(null));
        }
        return this.fMethod;
    }
}

