/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.java.javacore;

import com.ibm.dtfj.image.CorruptData;
import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.javacore.JCCorruptData;
import com.ibm.dtfj.java.JavaClass;
import com.ibm.dtfj.java.JavaClassLoader;
import com.ibm.dtfj.java.JavaObject;
import com.ibm.dtfj.java.javacore.JCInvalidArgumentsException;
import com.ibm.dtfj.java.javacore.JCJavaRuntime;
import java.util.Iterator;
import java.util.Vector;

public class JCJavaClass
implements JavaClass {
    private final JCJavaRuntime fJavaRuntime;
    private JavaClassLoader fJavaClassLoader;
    private JavaObject fJavaObject;
    private long fClassID;
    private long fSuperClassID;
    private final String fClassName;
    private ImagePointer fClassPointer;
    private int fModifiers;
    private Vector fMethods;
    private Vector fConstantPoolReferences;
    private Vector fDeclaredFields;
    private Vector fInterfaces;

    public JCJavaClass(JCJavaRuntime javaRuntime, String className) throws JCInvalidArgumentsException {
        if (javaRuntime == null) {
            throw new JCInvalidArgumentsException("Must pass a valid java runtime and class name");
        }
        if (className == null) {
            throw new JCInvalidArgumentsException("Must pass either a valid className or ID at construction time");
        }
        this.fClassName = className;
        this.fJavaRuntime = javaRuntime;
        this.fClassPointer = null;
        this.fJavaClassLoader = null;
        this.fJavaObject = null;
        this.fClassID = -1L;
        this.fSuperClassID = -1L;
        this.fModifiers = -1;
        this.fMethods = new Vector();
        this.fConstantPoolReferences = new Vector();
        this.fDeclaredFields = new Vector();
        this.fInterfaces = new Vector();
        this.fJavaRuntime.addJavaClass(this);
    }

    public JavaClassLoader getClassLoader() throws CorruptDataException {
        if (this.fJavaClassLoader == null) {
            throw new CorruptDataException((CorruptData)new JCCorruptData(null));
        }
        return this.fJavaClassLoader;
    }

    public JavaClass getComponentType() throws CorruptDataException {
        throw new CorruptDataException((CorruptData)new JCCorruptData(null));
    }

    public Iterator getConstantPoolReferences() {
        return this.fConstantPoolReferences.iterator();
    }

    public Iterator getDeclaredFields() {
        return this.fDeclaredFields.iterator();
    }

    public Iterator getDeclaredMethods() {
        return this.fMethods.iterator();
    }

    public ImagePointer getID() {
        if (this.fClassPointer == null && this.fClassID != -1L) {
            this.fClassPointer = this.fJavaRuntime.getImageProcess().getImageAddressSpace().getPointer(this.fClassID);
        }
        return this.fClassPointer;
    }

    public Iterator getInterfaces() {
        return this.fInterfaces.iterator();
    }

    public int getModifiers() throws CorruptDataException {
        if (this.fModifiers == -1) {
            throw new CorruptDataException((CorruptData)new JCCorruptData(null));
        }
        return this.fModifiers;
    }

    public String getName() throws CorruptDataException {
        if (this.fClassName == null) {
            throw new CorruptDataException((CorruptData)new JCCorruptData(null));
        }
        return this.fClassName;
    }

    public JavaObject getObject() throws CorruptDataException {
        if (this.fJavaObject == null) {
            throw new CorruptDataException((CorruptData)new JCCorruptData(null));
        }
        return this.fJavaObject;
    }

    public JavaClass getSuperclass() throws CorruptDataException {
        JCJavaClass superClass = this.fJavaRuntime.findJavaClass(this.fSuperClassID);
        if (superClass == null) {
            throw new CorruptDataException((CorruptData)new JCCorruptData(null));
        }
        return this.fJavaRuntime.findJavaClass(this.fSuperClassID);
    }

    public boolean isArray() throws CorruptDataException {
        return false;
    }

    public void setID(long classID) throws JCInvalidArgumentsException {
        if (!this.fJavaRuntime.getImageProcess().getImageAddressSpace().isValidAddressID(classID)) {
            throw new JCInvalidArgumentsException("Must pass a valid class ID (non zero value)");
        }
        this.fClassID = classID;
    }

    public String internalGetName() {
        return this.fClassName;
    }

    public void setClassLoader(JavaClassLoader classLoader) {
        this.fJavaClassLoader = classLoader;
    }

    public void setJavaSuperClass(long superClassID) {
        this.fSuperClassID = superClassID;
    }

    public void setJavaObject(JavaObject javaObject) {
        this.fJavaObject = javaObject;
    }

    public void setModifiers(int modifiers) {
        this.fModifiers = modifiers;
    }

    public Iterator getReferences() {
        return null;
    }
}

