/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.java.j9;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.j9.CorruptData;
import com.ibm.dtfj.java.JavaThread;
import com.ibm.dtfj.java.j9.JavaObject;
import com.ibm.dtfj.java.j9.JavaRuntime;
import java.util.Iterator;
import java.util.Vector;

public class JavaMonitor
implements com.ibm.dtfj.java.JavaMonitor {
    private JavaRuntime _javaVM;
    private ImagePointer _monitorID;
    private String _monitorName;
    private ImagePointer _encompassingObjectAddress = null;
    private com.ibm.dtfj.java.JavaObject _encompassingObject = null;
    private long _owningThreadID;
    private Vector _blockList = new Vector();
    private Vector _waitList = new Vector();

    public JavaMonitor(JavaRuntime runtime, ImagePointer pointer, String name, ImagePointer encompassingObjectAddress, long owningThread) {
        if (null == runtime) {
            throw new IllegalArgumentException("A Java Monitor cannot exist in a null Java VM");
        }
        if (null == pointer) {
            throw new IllegalArgumentException("A Java Monitor requires a non-null ID");
        }
        this._javaVM = runtime;
        this._monitorID = pointer;
        this._encompassingObjectAddress = encompassingObjectAddress;
        this._owningThreadID = owningThread;
        this._monitorName = null == name ? (null != this._encompassingObjectAddress ? "(un-named monitor @0x" + Long.toHexString(pointer.getAddress()) + " for object @0x" + Long.toHexString(this._encompassingObjectAddress.getAddress()) + ")" : "(un-named monitor @0x" + Long.toHexString(pointer.getAddress()) + ")") : name;
    }

    public com.ibm.dtfj.java.JavaObject getObject() {
        if (null == this._encompassingObjectAddress) {
            return null;
        }
        if (null == this._encompassingObject) {
            try {
                this._encompassingObject = this._javaVM.getObjectAtAddress(this._encompassingObjectAddress);
                if (null != this._encompassingObject && this._encompassingObject instanceof JavaObject) {
                    ((JavaObject)this._encompassingObject).setAssociatedObject(this);
                }
            }
            catch (CorruptDataException e) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return this._encompassingObject;
    }

    public String getName() throws CorruptDataException {
        return this._monitorName;
    }

    public JavaThread getOwner() throws CorruptDataException {
        JavaThread owningThread = null;
        Iterator allThreads = this._javaVM.getThreads();
        while (allThreads.hasNext()) {
            JavaThread oneThread = (JavaThread)allThreads.next();
            if (oneThread.getJNIEnv().getAddress() != this._owningThreadID) continue;
            owningThread = oneThread;
            break;
        }
        if (null == owningThread && 0L != this._owningThreadID) {
            throw new CorruptDataException((com.ibm.dtfj.image.CorruptData)new CorruptData("Monitor owner not found", this._javaVM.pointerInAddressSpace(this._owningThreadID)));
        }
        return owningThread;
    }

    public Iterator getEnterWaiters() {
        if (null == this._blockList) {
            this._blockList = new Vector();
        }
        return this._blockList.iterator();
    }

    public Iterator getNotifyWaiters() {
        if (null == this._waitList) {
            this._waitList = new Vector();
        }
        return this._waitList.iterator();
    }

    public boolean equals(Object obj) {
        boolean isEqual = false;
        if (obj instanceof JavaMonitor) {
            JavaMonitor local = (JavaMonitor)obj;
            isEqual = this._javaVM.equals(local._javaVM) && this._monitorID.equals(local._monitorID);
        }
        return isEqual;
    }

    public int hashCode() {
        return this._javaVM.hashCode() ^ this._monitorID.hashCode();
    }

    public ImagePointer getID() {
        return this._monitorID;
    }

    public void addBlockedThread(JavaThread thread) {
        this._blockList.add(thread);
    }

    public void addWaitingThread(JavaThread thread) {
        this._waitList.add(thread);
    }
}

