/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.image.j9;

import com.ibm.dtfj.corereaders.ClosingFileReader;
import com.ibm.dtfj.corereaders.DumpFactory;
import com.ibm.dtfj.corereaders.ICoreFileReader;
import com.ibm.dtfj.image.Image;
import com.ibm.dtfj.image.j9.DefaultFileLocationResolver;
import com.ibm.dtfj.image.j9.IFileLocationResolver;
import com.ibm.dtfj.image.j9.ZipExtractionResolver;
import com.ibm.jvm.j9.dump.indexsupport.XMLIndexReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class ImageFactory
implements com.ibm.dtfj.image.ImageFactory {
    public Image getImage(File imageFile) throws IOException {
        Image image = null;
        try {
            ZipFile zip = new ZipFile(imageFile);
            ZipExtractionResolver resolver = new ZipExtractionResolver(zip);
            File coreFile = resolver.decompressCoreFile();
            InputStream metaStream = resolver.decompressMetaDataStream();
            image = this.getImage(coreFile, metaStream, resolver);
        }
        catch (ZipException z) {
            image = this.getImage(imageFile, new File(imageFile.toString() + ".xml"));
        }
        return image;
    }

    public Image getImage(File imageFile, File metadata) throws IOException {
        FileInputStream metastream = new FileInputStream(metadata);
        Image image = this.getImage(imageFile, metastream, new DefaultFileLocationResolver(imageFile.getParentFile()));
        metastream.close();
        return image;
    }

    private Image getImage(File imageFile, InputStream metadata, IFileLocationResolver resolver) throws IOException {
        ClosingFileReader reader = new ClosingFileReader(imageFile);
        ICoreFileReader core = DumpFactory.createDumpForCore(reader);
        XMLIndexReader indexData = new XMLIndexReader();
        return indexData.parseIndexWithDump(metadata, core, reader, resolver);
    }

    public int getDTFJMajorVersion() {
        return 1;
    }

    public int getDTFJMinorVersion() {
        return 3;
    }

    public int getDTFJModificationLevel() {
        return 2;
    }
}

