/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.corereaders.zos.util;

import com.ibm.dtfj.corereaders.zos.util.AbstractHashMap;

public abstract class AbstractLruCache
extends AbstractHashMap {
    int maxSize;
    int head = -1;
    int tail = -1;
    int[] next = new int[17];
    int[] prev = new int[17];

    protected AbstractLruCache(int maxSize) {
        this.maxSize = maxSize;
    }

    void allocNewValuesArray(int newSize) {
        this.next = new int[newSize];
        this.prev = new int[newSize];
        this.tail = -1;
        this.head = -1;
    }

    protected int getIndexAndPromote(long key) {
        int index = this.getIndex(key);
        if (index != -1) {
            if (this.head != index) {
                int n = this.next[index];
                int p = this.prev[index];
                this.next[p] = n;
                if (n != -1) {
                    this.prev[n] = this.prev[index];
                } else {
                    this.tail = p;
                }
                this.prev[index] = -1;
                this.next[index] = this.head;
                this.prev[this.head] = index;
                this.head = index;
            }
            return index;
        }
        return -1;
    }

    protected int putIndexAndPromote(long key) {
        int index = this.getIndex(key);
        if (index == -1) {
            if (this.slotsInUse < this.maxSize) {
                index = this.putIndex(key);
                this.prev[index] = -1;
                this.next[index] = this.head;
                if (this.slotsInUse == 1) {
                    this.tail = index;
                } else {
                    this.prev[this.head] = index;
                }
                this.head = index;
                return index;
            }
            this.state[this.tail] = 2;
            ++this.deletedSlots;
            --this.slotsInUse;
            this.tail = this.prev[this.tail];
            this.next[this.tail] = -1;
            return this.putIndexAndPromote(key);
        }
        return index;
    }
}

