/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.corereaders.zos.mvs;

import com.ibm.dtfj.corereaders.zos.dumpreader.AddressSpace;
import com.ibm.dtfj.corereaders.zos.dumpreader.AddressSpaceImageInputStream;
import com.ibm.dtfj.corereaders.zos.mvs.BpxzotcbTemplate;
import com.ibm.dtfj.corereaders.zos.mvs.BpxzustaTemplate;
import com.ibm.dtfj.corereaders.zos.mvs.CeexcvtTemplate;
import com.ibm.dtfj.corereaders.zos.mvs.IhaascbTemplate;
import com.ibm.dtfj.corereaders.zos.mvs.IhaasxbTemplate;
import com.ibm.dtfj.corereaders.zos.mvs.IhapsaTemplate;
import com.ibm.dtfj.corereaders.zos.mvs.IharbTemplate;
import com.ibm.dtfj.corereaders.zos.mvs.IhastcbTemplate;
import com.ibm.dtfj.corereaders.zos.mvs.IkjrbTemplate;
import com.ibm.dtfj.corereaders.zos.mvs.IkjtcbTemplate;
import com.ibm.dtfj.corereaders.zos.mvs.Lse;
import com.ibm.dtfj.corereaders.zos.mvs.LsedTemplate;
import com.ibm.dtfj.corereaders.zos.mvs.Lsestate1Template;
import com.ibm.dtfj.corereaders.zos.mvs.LsestateTemplate;
import com.ibm.dtfj.corereaders.zos.mvs.OtcbcopyonforkTemplate;
import com.ibm.dtfj.corereaders.zos.mvs.RegisterSet;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Tcb {
    private AddressSpace space;
    private AddressSpaceImageInputStream inputStream;
    private long address;
    private Lse[] linkageStack;
    private static Hashtable tcbMap = new Hashtable();
    private static final int RBFTPRB = 0;
    private static final int FastPathPCLow = 4871;
    private static final int OmvsPcLow = 4864;
    private static Logger log = Logger.getLogger(Tcb.class.getName());

    public static Tcb[] getTcbs(AddressSpace space) {
        AddressSpaceImageInputStream inputStream = space.getImageInputStream();
        AddressSpaceImageInputStream rootInputStream = space.getRootAddressSpace().getImageInputStream();
        Tcb[] tcbs = (Tcb[])tcbMap.get(space);
        if (tcbs != null) {
            return tcbs;
        }
        log.fine("creating Tcb array for asid " + space);
        Vector<Tcb> v = new Vector<Tcb>();
        try {
            long asxbltcb;
            long psaaold = IhapsaTemplate.getPsaaold(rootInputStream, 0L);
            if (psaaold == 0L) {
                log.fine("psaaold is zero so no tcbs in asid " + space);
                return null;
            }
            long ascbasxb = IhaascbTemplate.getAscbasxb(rootInputStream, psaaold);
            long asxbftcb = IhaasxbTemplate.getAsxbftcb(inputStream, ascbasxb);
            if (asxbftcb == (asxbltcb = IhaasxbTemplate.getAsxbltcb(inputStream, ascbasxb))) {
                log.fine("first and last tcb pointers are equal so no tcbs in asid " + space);
                return null;
            }
            Tcb tcb = new Tcb(space, asxbftcb);
            while (true) {
                v.add(tcb);
                if (tcb.address() != asxbltcb) {
                    tcb = new Tcb(space, tcb.tcbtcb());
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            if (log.isLoggable(Level.FINER)) {
                e.printStackTrace();
            }
            log.fine("exception: " + e);
            return null;
        }
        tcbs = v.toArray(new Tcb[0]);
        tcbMap.put(space, tcbs);
        return tcbs;
    }

    public long address() {
        return this.address;
    }

    public AddressSpace space() {
        return this.space;
    }

    public Tcb(AddressSpace space, long address) {
        log.fine("creating Tcb at address " + Tcb.hex(address));
        this.space = space;
        this.address = address;
        this.inputStream = space.getImageInputStream();
    }

    public long tcbcelap() throws IOException {
        return IkjtcbTemplate.getTcbcelap(this.inputStream, this.address);
    }

    public long tcbrtwa() throws IOException {
        return IkjtcbTemplate.getTcbrtwa(this.inputStream, this.address);
    }

    public long tcbrbp() throws IOException {
        return IkjtcbTemplate.getTcbrbp(this.inputStream, this.address);
    }

    public long tcbstcb() throws IOException {
        return IkjtcbTemplate.getTcbstcb(this.inputStream, this.address);
    }

    public long tcbtcb() throws IOException {
        return IkjtcbTemplate.getTcbtcb(this.inputStream, this.address);
    }

    public RegisterSet getRegisters() throws IOException {
        log.fine("getRegisters");
        RegisterSet regs = new RegisterSet();
        try {
            long tcbgrs = this.address + (long)IkjtcbTemplate.getTcbgrs$offset();
            for (int i = 0; i < 16; ++i) {
                regs.setRegister(i, this.space.readUnsignedInt(tcbgrs + (long)(i * 4)));
            }
            regs.setPSW(IharbTemplate.getRbopsw(this.inputStream, this.tcbrbp()));
            if (this.space.is64bit()) {
                long stcbg64h = this.tcbstcb() + (long)IhastcbTemplate.getStcbg64h$offset();
                for (int i = 0; i < 16; ++i) {
                    long high = this.space.readUnsignedInt(stcbg64h + (long)(i * 4));
                    regs.setRegister(i, regs.getRegister(i) | high << 32);
                }
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new Error("oops: " + e);
        }
        return regs;
    }

    public RegisterSet getRegistersFromBPXGMSTA() throws IOException {
        RegisterSet regs;
        block18: {
            regs = new RegisterSet();
            try {
                long rbp = this.tcbrbp();
                long rbsecptr = 0L;
                long save2rbptr = 0L;
                log.fine("for tcb " + Tcb.hex(this.address) + ", rbp = " + Tcb.hex(rbp));
                int countRbs = 0;
                do {
                    log.fine("currently looking at rbp 0x" + Tcb.hex(rbp));
                    save2rbptr = rbsecptr;
                    rbsecptr = rbp;
                    rbp = IharbTemplate.getRblinkXrblnkRblinkb(this.inputStream, rbp);
                    ++countRbs;
                } while (rbp != this.address);
                log.fine("found " + countRbs + " rbs");
                if (countRbs == 1) {
                    this.getLinkageStack();
                    if (this.linkageStack.length == 0) {
                        log.fine("empty linkage stack, get registers from TCB");
                        regs = this.getRegisters();
                        regs.setWhereFound("BPXGMSTA/TCB");
                        break block18;
                    }
                    long stcbotcb = IhastcbTemplate.getStcbotcb(this.inputStream, this.tcbstcb());
                    boolean otcbptregsinusta = false;
                    if (stcbotcb != 0L) {
                        boolean bl = otcbptregsinusta = BpxzotcbTemplate.getOtcbptregsinusta(this.inputStream, stcbotcb) != 0L;
                    }
                    if (otcbptregsinusta && stcbotcb != 0L) {
                        long otcbcofptr = BpxzotcbTemplate.getOtcbcofptr(this.inputStream, stcbotcb);
                        throw new Error("tbc");
                    }
                    log.fine("try first linkage stack entry");
                    Lse lse = this.linkageStack[this.linkageStack.length - 1];
                    assert (stcbotcb != 0L);
                    long otcbcofptr = BpxzotcbTemplate.getOtcbcofptr(this.inputStream, stcbotcb);
                    long otcbustaptr = OtcbcopyonforkTemplate.getOtcbustaptr(this.inputStream, otcbcofptr);
                    log.fine("lse type " + lse.lses1typ7());
                    if ((lse.lsestyp7() == 5 || lse.lses1typ7() == 13) && lse.lsestarg() < 4871L && lse.lsestarg() >= 4864L && otcbustaptr != 0L) {
                        long ustagrs = otcbustaptr + (long)BpxzustaTemplate.getUstagrs$offset();
                        long cvt = IhapsaTemplate.getFlccvt(this.inputStream, 0L);
                        long cvtoslv3 = CeexcvtTemplate.getCvtoslv3(this.inputStream, cvt);
                        if ((cvtoslv3 & 2L) != 0L) {
                            log.fine("new level of OS (0x" + Tcb.hex(cvtoslv3) + ")");
                        } else {
                            log.fine("old level of OS (0x" + Tcb.hex(cvtoslv3) + ") so adjust usta pointer");
                            ustagrs -= 8L;
                        }
                        for (int i = 0; i < 16; ++i) {
                            regs.setRegister(i, this.space.readUnsignedInt(ustagrs + (long)(i * 4)));
                        }
                        long ustapsw = otcbustaptr + (long)BpxzustaTemplate.getUstapswg$offset();
                        regs.setPSW(this.space.readLong(ustapsw));
                        regs.setWhereFound("BPXGMSTA/USTA");
                        break block18;
                    }
                    log.fine("try last linkage stack entry");
                    lse = this.linkageStack[0];
                    if (lse.lses1typ7() == 13 || lse.lses1typ7() == 12) {
                        regs.setPSW(lse.lses1pswh());
                        for (int i = 0; i < 16; ++i) {
                            regs.setRegister(i, lse.lses1grs(i));
                        }
                    } else {
                        regs.setPSW(lse.lsespsw());
                        for (int i = 0; i < 16; ++i) {
                            regs.setRegister(i, lse.lsesgrs(i));
                        }
                    }
                    regs.setWhereFound("BPXGMSTA/Linkage");
                    break block18;
                }
                long rbftp = IkjrbTemplate.getRbftp(this.inputStream, rbsecptr);
                if (rbftp == 0L) {
                    regs.setPSW(IharbTemplate.getRbopsw(this.inputStream, rbsecptr));
                    long rbgrsave_offset = IharbTemplate.getRbgrsave$offset();
                    for (int i = 0; i < 16; ++i) {
                        regs.setRegister(i, this.space.readUnsignedInt(save2rbptr + rbgrsave_offset + (long)(i * 4)));
                    }
                    regs.setWhereFound("BPXGMSTA/RBFTPRB");
                    break block18;
                }
                throw new Error("tbc");
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new Error("oops: " + e);
            }
        }
        return regs;
    }

    public Lse[] getLinkageStack() throws IOException {
        if (this.linkageStack != null) {
            return this.linkageStack;
        }
        try {
            long stcb = this.tcbstcb();
            long stcbestk = IhastcbTemplate.getStcbestk(this.inputStream, stcb);
            long stcblsdp = IhastcbTemplate.getStcblsdp(this.inputStream, stcb);
            if (stcbestk == stcblsdp) {
                log.fine("linkage stack empty");
                this.linkageStack = new Lse[0];
                return this.linkageStack;
            }
            long entrysize = LsedTemplate.getLsednes(this.inputStream, stcbestk);
            assert (entrysize == (long)LsestateTemplate.length() || entrysize == (long)Lsestate1Template.length()) : entrysize;
            assert ((stcblsdp - stcbestk) % entrysize == 0L) : (stcblsdp - stcbestk) % entrysize;
            int numEntries = (int)((stcblsdp - stcbestk) / entrysize);
            assert (numEntries >= 0 && numEntries < 100) : numEntries;
            this.linkageStack = new Lse[numEntries];
            long lsedptr = stcblsdp - entrysize;
            for (int i = 0; i < numEntries; ++i) {
                this.linkageStack[i] = new Lse(this.space, lsedptr);
                lsedptr -= entrysize;
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new Error("oops: " + e);
        }
        return this.linkageStack;
    }

    private static String hex(long n) {
        return Long.toHexString(n);
    }
}

