/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.corereaders.zos.le;

import com.ibm.dtfj.corereaders.zos.dumpreader.AddressSpace;
import com.ibm.dtfj.corereaders.zos.dumpreader.AddressSpaceImageInputStream;
import com.ibm.dtfj.corereaders.zos.le.Caa32Template;
import com.ibm.dtfj.corereaders.zos.le.Caa64Template;
import com.ibm.dtfj.corereaders.zos.le.CaaNotFound;
import com.ibm.dtfj.corereaders.zos.le.CaaTemplate;
import com.ibm.dtfj.corereaders.zos.le.CeedsaTemplate;
import com.ibm.dtfj.corereaders.zos.le.CeelcaTemplate;
import com.ibm.dtfj.corereaders.zos.le.Ceexhcom32Template;
import com.ibm.dtfj.corereaders.zos.le.CeexlaaTemplate;
import com.ibm.dtfj.corereaders.zos.le.CeexstkhTemplate;
import com.ibm.dtfj.corereaders.zos.le.CeextvbTemplate;
import com.ibm.dtfj.corereaders.zos.le.CeextvbeTemplate;
import com.ibm.dtfj.corereaders.zos.le.DsaStackFrame;
import com.ibm.dtfj.corereaders.zos.le.Edb;
import com.ibm.dtfj.corereaders.zos.le.SmcbTemplate;
import com.ibm.dtfj.corereaders.zos.mvs.Ihartm2aTemplate;
import com.ibm.dtfj.corereaders.zos.mvs.IhastcbTemplate;
import com.ibm.dtfj.corereaders.zos.mvs.Lse;
import com.ibm.dtfj.corereaders.zos.mvs.RegisterSet;
import com.ibm.dtfj.corereaders.zos.mvs.Tcb;
import java.io.IOException;
import java.util.Vector;
import java.util.logging.Logger;

public class Caa {
    private long address;
    private Tcb tcb;
    private AddressSpace space;
    private AddressSpaceImageInputStream inputStream;
    private Edb edb;
    private DsaStackFrame currentFrame;
    private int stackdirection;
    private CaaTemplate caaTemplate;
    private static int hcomLength = new Ceexhcom32Template().length();
    private String whereFound;
    static final int CEECAASTACK_UP = 0;
    static final int CEECAASTACK_DOWN = 1;
    private static final int WARNING = 4;
    private static final int ERROR = 8;
    private static final long F1SA = -420355391L;
    private static Logger log = Logger.getLogger(Caa.class.getName());

    public static Caa[] getCaas(AddressSpace space) {
        Tcb[] tcbs = Tcb.getTcbs(space);
        if (tcbs == null) {
            log.fine("no tcbs found in address space " + space);
            return new Caa[0];
        }
        log.fine("found " + tcbs.length + " tcbs for address space " + space);
        Vector<Caa> v = new Vector<Caa>();
        for (int i = 0; i < tcbs.length; ++i) {
            try {
                v.add(new Caa(tcbs[i]));
                continue;
            }
            catch (CaaNotFound e) {
                // empty catch block
            }
        }
        return v.toArray(new Caa[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Caa(Tcb tcb) throws CaaNotFound {
        log.fine("creating Caa for Tcb at address " + Caa.hex(tcb.address()));
        this.tcb = tcb;
        this.space = tcb.space();
        this.inputStream = this.space.getImageInputStream();
        try {
            this.try32bit();
            if (this.caaTemplate == null) {
                this.caaTemplate = new Caa32Template();
            }
            log.fine("Found 32-bit Caa");
        }
        catch (CaaNotFound e) {
            boolean was64bit = this.space.is64bit();
            log.fine("Try 64-bit Caa, old size " + (was64bit ? "64-bit" : "32-bit"));
            this.space.setIs64bit(true);
            try {
                this.try64bit();
                if (this.caaTemplate == null) {
                    this.caaTemplate = new Caa64Template();
                }
                log.fine("Found 64-bit Caa");
                was64bit = true;
            }
            finally {
                this.space.setIs64bit(was64bit);
            }
        }
    }

    private void try32bit() throws CaaNotFound {
        try {
            long celap = this.tcb.tcbcelap();
            log.finer("celap = 0x" + Caa.hex(celap));
            int celap0 = this.space.readInt(celap);
            log.finer("celap0 = 0x" + Caa.hex(celap0));
            this.address = this.space.readInt(celap0 + 32);
            log.fine("caa address = " + Caa.hex(this.address));
            this.validate();
        }
        catch (IOException e) {
            log.fine("caught exception: " + e);
            throw new CaaNotFound();
        }
    }

    private void try64bit() throws CaaNotFound {
        try {
            long stcb = this.tcb.tcbstcb();
            log.finer("stcb = 0x" + Caa.hex(stcb));
            long laa = IhastcbTemplate.getStcblaa(this.inputStream, stcb);
            log.finer("laa = 0x" + Caa.hex(laa));
            long lca = CeexlaaTemplate.getCeelaa_lca64(this.inputStream, laa);
            log.finer("lca = 0x" + Caa.hex(lca));
            this.address = CeelcaTemplate.getCeelca_caa(this.inputStream, lca);
            log.fine("caa address = " + Caa.hex(this.address));
            this.validate();
        }
        catch (IOException e) {
            log.fine("caught exception: " + e);
            throw new CaaNotFound();
        }
    }

    public String whereFound() {
        return this.whereFound;
    }

    private void validate() throws CaaNotFound {
        try {
            int eye1 = this.space.readInt(this.address - 24L);
            int eye2 = this.space.readInt(this.address - 20L) & 0xFFFF0000;
            if (eye1 == -1010448957 && eye2 == -1044316160) {
                return;
            }
        }
        catch (IOException e) {
            log.fine("caught exception: " + e);
        }
        throw new CaaNotFound();
    }

    public DsaStackFrame getCurrentFrame() {
        if (this.currentFrame == null) {
            log.fine("about to get top dsa for caa " + Caa.hex(this.address));
            Cel4rreg cel = new Cel4rreg();
            assert (cel.p_dsafmt != -1);
            RegisterSet regs = cel.regs;
            boolean isDownStack = cel.p_dsafmt == 1;
            long dsa = cel.p_dsaptr;
            if (dsa == 0L) {
                log.fine("dsa is zero for caa " + Caa.hex(this.address));
                return null;
            }
            try {
                this.currentFrame = new DsaStackFrame(dsa, isDownStack, regs, this.space, this);
            }
            catch (IOException e) {
                log.fine("exception getting top dsa: " + e);
            }
        }
        return this.currentFrame;
    }

    public int getPThreadID() throws IOException {
        return this.caaTemplate.getCeecaathdid(this.inputStream, this.address);
    }

    public boolean hasFailed() {
        throw new Error("tbc");
    }

    public RegisterSet getRegisterSet() {
        throw new Error("tbc");
    }

    public Edb getEdb() {
        if (this.edb == null) {
            try {
                this.edb = new Edb(this.ceecaaedb(), this.space);
            }
            catch (Exception e) {
                throw new Error("oops: " + e);
            }
        }
        return this.edb;
    }

    public long address() {
        return this.address;
    }

    public AddressSpace space() {
        return this.space;
    }

    public Tcb getTcb() {
        return this.tcb;
    }

    public int ceecaalevel() throws IOException {
        return (int)this.caaTemplate.getCeecaalevel(this.inputStream, this.address);
    }

    public int ceecaa_stackdirection() throws IOException {
        if (this.ceecaalevel() < 13) {
            throw new Error("ceecaa_stackdirection is not available in this level of LE! " + this.ceecaalevel());
        }
        return (int)this.caaTemplate.getCeecaa_stackdirection(this.inputStream, this.address);
    }

    public long ceecaasmcb() throws IOException {
        return ((Caa32Template)this.caaTemplate).getCeecaasmcb(this.inputStream, this.address);
    }

    public long ceecaarcb() throws IOException {
        return this.caaTemplate.getCeecaarcb(this.inputStream, this.address);
    }

    public long ceecaavba() throws IOException {
        return this.caaTemplate.getCeecaavba(this.inputStream, this.address);
    }

    public long pthread_getspecific_d8_np(long key) throws IOException {
        long ceecaavba = this.ceecaavba();
        if (ceecaavba == 0L) {
            log.fine("ceecaavba is zero!");
            return 0L;
        }
        long eyecatcher = this.space.readInt(ceecaavba);
        if (eyecatcher == -471481792L) {
            long ceeedbdba = this.getEdb().ceeedbdba();
            log.fine("ceeedbdba = " + Caa.hex(ceeedbdba));
            assert (this.space.readInt(ceeedbdba) == -758857152);
            long ceekdb_bptr = this.space.readInt(ceeedbdba + 8L);
            long keyIndex = (key - ceekdb_bptr) / 16L;
            int bucketNumber = (int)keyIndex / 32;
            int bucketIndex = (int)keyIndex % 32;
            assert (bucketNumber < 32);
            long bucket = this.space.readInt(ceecaavba + 4L + (long)(bucketNumber * 4));
            if (bucket == 0L) {
                return 0L;
            }
            log.fine("bucket = " + Caa.hex(bucket));
            long value = this.space.readInt(bucket + 4L + (long)(bucketIndex * 4));
            log.fine("value = " + Caa.hex(value));
            return value;
        }
        long ceetvbcount = CeextvbTemplate.getCeetvbcount(this.inputStream, ceecaavba);
        log.fine("eye = " + Caa.hex(this.space.readInt(ceecaavba)));
        long ceetvbe = ceecaavba + (long)CeextvbTemplate.length();
        int i = 0;
        while ((long)i < ceetvbcount) {
            long ceetvbekey = CeextvbeTemplate.getCeetvbekey(this.inputStream, ceetvbe);
            if (key == ceetvbekey) {
                return CeextvbeTemplate.getCeetvbevalue(this.inputStream, ceetvbe);
            }
            ceetvbe += (long)CeextvbeTemplate.length();
            ++i;
        }
        return 0L;
    }

    public long ceecaaddsa() {
        try {
            return this.caaTemplate.getCeecaaddsa(this.inputStream, this.address);
        }
        catch (IOException e) {
            throw new Error("oops");
        }
    }

    public long ceecaaedb() throws IOException {
        return this.caaTemplate.getCeecaaedb(this.inputStream, this.address);
    }

    public long ceecaaerrcm() throws IOException {
        return this.caaTemplate.getCeecaaerrcm(this.inputStream, this.address);
    }

    private static String hex(int i) {
        return Integer.toHexString(i);
    }

    private static String hex(long i) {
        return Long.toHexString(i);
    }

    public String toString() {
        return Caa.hex(this.address);
    }

    class Cel4rreg {
        long seghigh;
        long seglow;
        int p_dsafmt = -1;
        long p_dsaptr;
        RegisterSet regs;

        Cel4rreg() {
            try {
                this.regs = this.getRegistersFromRTM2();
                if (this.regs != null) {
                    Caa.this.whereFound = "RTM2";
                    return;
                }
            }
            catch (IOException e) {
                throw new Error("oops: " + e);
            }
            try {
                this.regs = this.getRegistersFromBPXGMSTA();
                if (this.regs != null) {
                    Caa.this.whereFound = this.regs.whereFound();
                    if (Caa.this.whereFound == null) {
                        Caa.this.whereFound = "BPXGMSTA";
                    }
                    return;
                }
            }
            catch (IOException e) {
                throw new Error("oops: " + e);
            }
            try {
                this.regs = this.getRegistersFromLinkageStack();
                if (this.regs != null) {
                    Caa.this.whereFound = "Linkage";
                    return;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new Error("oops: " + e);
            }
            try {
                this.regs = this.getRegistersFromTCB();
                if (this.regs != null) {
                    Caa.this.whereFound = "TCB";
                    return;
                }
            }
            catch (IOException e) {
                throw new Error("oops: " + e);
            }
            Caa.this.whereFound = "not found";
        }

        private RegisterSet getRegistersFromRTM2() throws IOException {
            long rtm2ptr;
            int level = Caa.this.ceecaalevel();
            log.finer("caa level is " + level);
            if (level >= 13) {
                Caa.this.stackdirection = Caa.this.ceecaa_stackdirection();
                log.finer("stack direction is " + (Caa.this.stackdirection == 0 ? "up" : "down"));
            } else {
                Caa.this.stackdirection = 0;
                log.finer("stack direction is up");
            }
            if (Caa.this.stackdirection == 1) {
                try {
                    long tempptr = Caa.this.ceecaasmcb();
                    this.seghigh = SmcbTemplate.getSmcb_dsbos(Caa.this.inputStream, tempptr);
                    this.seglow = CeexstkhTemplate.getStkh_stackfloor(Caa.this.inputStream, this.seghigh);
                }
                catch (Exception e) {
                    return null;
                }
            }
            if ((rtm2ptr = Caa.this.tcb.tcbrtwa()) != 0L) {
                try {
                    log.fine("found some rtm2 registers");
                    RegisterSet regs = new RegisterSet();
                    long rtm2grs = rtm2ptr + (long)Ihartm2aTemplate.getRtm2ereg$offset();
                    for (int i = 0; i < 16; ++i) {
                        regs.setRegister(i, Caa.this.space.readUnsignedInt(rtm2grs + (long)(i * 4)));
                    }
                    long rtm2psw = rtm2ptr + (long)Ihartm2aTemplate.getRtm2apsw$offset();
                    regs.setPSW(Caa.this.space.readLong(rtm2psw));
                    if (this.registersValid(regs)) {
                        log.fine("found good dsa in rtm2");
                        return regs;
                    }
                    log.fine("bad dsa in rtm2");
                    return null;
                }
                catch (IOException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new Error("oops: " + e);
                }
            }
            log.finer("failed to get registers from rtm2");
            return null;
        }

        private boolean registersValid(RegisterSet regs) throws IOException {
            this.p_dsafmt = Caa.this.stackdirection;
            if (this.p_dsafmt == 1) {
                this.p_dsaptr = regs.getRegisterAsAddress(4);
                log.fine("p_dsaptr from reg 4 = " + Caa.hex(this.p_dsaptr));
            } else {
                this.p_dsaptr = regs.getRegisterAsAddress(13);
                log.fine("p_dsaptr from reg 13 = " + Caa.hex(this.p_dsaptr));
            }
            int lastrc = this.validateDSA();
            if (lastrc == 0) {
                log.fine("found valid dsa");
                return true;
            }
            if (Caa.this.stackdirection == 1) {
                this.p_dsaptr = regs.getRegisterAsAddress(13);
                log.fine("p_dsaptr from reg 13 (again) = " + Caa.hex(this.p_dsaptr));
                this.p_dsafmt = 0;
                lastrc = this.validateDSA();
                if (lastrc == 4 && (lastrc = this.validateDSA()) == 0) {
                    log.fine("found valid dsa");
                    return true;
                }
            }
            log.fine("p_dsaptr invalid so reset: " + Caa.hex(this.p_dsaptr));
            this.p_dsaptr = 0L;
            return false;
        }

        private RegisterSet getRegistersFromBPXGMSTA() throws IOException {
            RegisterSet regs = Caa.this.tcb.getRegistersFromBPXGMSTA();
            if (Caa.this.space.is64bit()) {
                Caa.this.stackdirection = 1;
                log.fine("forced stack direction down as 64-bit");
            }
            if (this.registersValid(regs)) {
                log.fine("found good dsa in BPXGMSTA");
                return regs;
            }
            return null;
        }

        private RegisterSet getRegistersFromLinkageStack() throws IOException {
            log.fine("enter getRegistersFromLinkageStack");
            try {
                Lse[] linkageStack = Caa.this.tcb.getLinkageStack();
                if (linkageStack.length == 0) {
                    log.fine("empty linkage stack");
                    return null;
                }
                for (int i = 0; i < linkageStack.length; ++i) {
                    Lse lse = linkageStack[i];
                    if (lse.lses1pasn() == Caa.this.space.getAsid()) {
                        int j;
                        RegisterSet regs = new RegisterSet();
                        if (lse.isZArchitecture() && (lse.lses1typ7() == 13 || lse.lses1typ7() == 12)) {
                            log.fine("found some z arch registers");
                            regs.setPSW(lse.lses1pswh());
                            for (j = 0; j < 16; ++j) {
                                regs.setRegister(j, lse.lses1grs(j));
                            }
                        } else {
                            log.fine("found some non z arch registers");
                            regs.setPSW(lse.lsespsw());
                            for (j = 0; j < 16; ++j) {
                                regs.setRegister(j, lse.lsesgrs(j));
                            }
                        }
                        if (!this.registersValid(regs)) continue;
                        log.fine("found good dsa in linkage stack");
                        return regs;
                    }
                    log.fine("different asid: " + Caa.hex(lse.lses1pasn()));
                }
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new Error("oops: " + e);
            }
            log.fine("could not find registers in linkage stack");
            return null;
        }

        private RegisterSet getRegistersFromTCB() throws IOException {
            log.fine("getRegistersFromTCB");
            RegisterSet regs = Caa.this.tcb.getRegisters();
            if (this.registersValid(regs)) {
                log.fine("found good dsa in TCB");
                return regs;
            }
            return null;
        }

        private int validateDSA() {
            log.fine("attempt to validate " + Caa.hex(this.p_dsaptr) + " on " + (this.p_dsafmt == 1 ? "down" : "up") + " stack");
            try {
                if (this.p_dsafmt != 1) {
                    if (Caa.this.space.is64bit()) {
                        return 8;
                    }
                    long tptr = Caa.this.ceecaaerrcm();
                    if (this.p_dsaptr < tptr + (long)hcomLength && this.p_dsaptr >= tptr && (this.p_dsaptr & 7L) == 0L) {
                        log.fine("upstack dsa " + Caa.hex(this.p_dsaptr) + " is inside hcom");
                        return 0;
                    }
                }
                long ddsa = Caa.this.ceecaaddsa();
                long dsaptr = this.p_dsaptr;
                int dsafmt8 = this.p_dsafmt;
                long slowdsaptr = this.p_dsaptr;
                int slowdsafmt8 = this.p_dsafmt;
                boolean slow = false;
                while (true) {
                    long tptr;
                    DsaStackFrame.Ceexdsaf dsaf = new DsaStackFrame.Ceexdsaf(Caa.this.space, dsaptr, dsafmt8);
                    if (Caa.this.stackdirection == 1 && this.p_dsafmt == 0 && dsaptr < this.seghigh && dsaptr >= this.seglow) {
                        this.p_dsaptr = CeedsaTemplate.getCeedsar4(Caa.this.inputStream, dsaptr);
                        this.p_dsafmt = 1;
                        log.fine("warning, try switching to down stack");
                        return 4;
                    }
                    long callers_dsaptr = dsaf.DSA_Prev;
                    dsafmt8 = dsaf.DSA_Format;
                    if (callers_dsaptr == 0L || callers_dsaptr == -420355391L) {
                        log.fine("cannot backchain futher because " + (callers_dsaptr == 0L ? "zero" : "linkage stack") + " found");
                        return 8;
                    }
                    if (callers_dsaptr == ddsa) {
                        log.fine("dummy dsa reached");
                        return 0;
                    }
                    if (dsafmt8 != this.p_dsafmt) {
                        log.fine("backchained across a stack transition");
                        return 0;
                    }
                    if (dsafmt8 == 0 && (tptr = CeedsaTemplate.getCeedsanab(Caa.this.inputStream, callers_dsaptr)) == dsaptr) {
                        log.fine("upstack DSA is good");
                        return 0;
                    }
                    dsaptr = callers_dsaptr;
                    if (slow) {
                        dsaf = new DsaStackFrame.Ceexdsaf(Caa.this.space, slowdsaptr, slowdsafmt8);
                        slowdsaptr = dsaf.DSA_Prev;
                        slowdsafmt8 = dsaf.DSA_Format;
                    }
                    if (dsaptr == slowdsaptr) {
                        log.fine("loop detected in DSA chain");
                        return 8;
                    }
                    slow = !slow;
                }
            }
            catch (IOException e) {
                log.fine("bad read: " + e);
                return 8;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new Error("oops: " + e);
            }
        }
    }
}

