/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.corereaders;

import com.ibm.dtfj.addressspace.IAbstractAddressSpace;
import com.ibm.dtfj.corereaders.Builder;
import com.ibm.dtfj.corereaders.ClosingFileReader;
import com.ibm.dtfj.corereaders.CoreReaderSupport;
import com.ibm.dtfj.corereaders.ICoreFileReader;
import com.ibm.dtfj.corereaders.LittleEndianDumpReader;
import com.ibm.dtfj.corereaders.MemoryAccessException;
import com.ibm.dtfj.corereaders.MemoryRange;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;

public abstract class NewWinDump
extends CoreReaderSupport {
    public String _processorSubtypeDescription;
    protected boolean _is64Bit;

    public static ICoreFileReader dumpFromFile(ClosingFileReader f) throws IOException {
        assert (NewWinDump.isSupportedDump(f));
        if (NewWinDump.isMiniDump(f)) {
            return new MiniDump(f);
        }
        if (NewWinDump.isUserDump(f)) {
            return new UserDump(f);
        }
        return null;
    }

    private static boolean isMiniDump(ClosingFileReader f) throws IOException {
        f.seek(0L);
        byte[] signature = new byte[4];
        f.readFully(signature);
        return new String(signature).equalsIgnoreCase("mdmp");
    }

    public static boolean isSupportedDump(ClosingFileReader f) throws IOException {
        return NewWinDump.isMiniDump(f) || NewWinDump.isUserDump(f);
    }

    private static boolean isUserDump(ClosingFileReader f) throws IOException {
        f.seek(0L);
        byte[] signature = new byte[8];
        f.readFully(signature);
        return new String(signature).equalsIgnoreCase("userdump");
    }

    private NewWinDump(ClosingFileReader f, int bitsPerPointer) throws IOException {
        super(new LittleEndianDumpReader(f, 64 == bitsPerPointer));
        this._is64Bit = 64 == bitsPerPointer;
    }

    protected Properties getEnvironmentVariables(Builder builder) throws MemoryAccessException {
        Properties envVars = new Properties();
        IAbstractAddressSpace memory = this.getAddressSpace();
        long address = memory.getPointerAt(0, builder.getEnvironmentAddress());
        long target = memory.getPointerAt(0, address);
        while (0L != target) {
            StringBuffer buffer = new StringBuffer();
            byte oneByte = memory.getByteAt(0, target);
            while (0 != oneByte) {
                buffer.append(new String(new byte[]{oneByte}));
                oneByte = memory.getByteAt(0, ++target);
            }
            String pair = buffer.toString();
            int equal = pair.indexOf(61);
            String variable = pair.substring(0, equal);
            String value = pair.substring(equal + 1, pair.length());
            envVars.put(variable, value);
            target = memory.getPointerAt(0, address);
            address += this.is64Bit() ? 8L : 4L;
        }
        return envVars;
    }

    public boolean isLittleEndian() {
        return true;
    }

    private static int littleEndianReadInt(ClosingFileReader f) throws IOException {
        byte[] buffer = new byte[4];
        f.readFully(buffer);
        return (0xFF & buffer[3]) << 24 | (0xFF & buffer[2]) << 16 | (0xFF & buffer[1]) << 8 | 0xFF & buffer[0];
    }

    private static class UserDump
    extends NewWinDump {
        private int _dataOffset;
        private List _memoryRanges;
        private int _regionCount;
        private int _regionOffset;

        public UserDump(ClosingFileReader f) throws IOException {
            super(f, 32);
            this.parseHeader();
            this.parseMemory();
        }

        public long getCreationTime() {
            return 0L;
        }

        public Iterator getMemoryRanges() {
            return this._memoryRanges.iterator();
        }

        private void parseHeader() throws IOException {
            this.coreSeek(0L);
            this.coreReadBytes(8);
            this.coreReadInt();
            this.coreReadInt();
            this.coreReadInt();
            this.coreReadInt();
            this.coreReadInt();
            this._regionCount = this.coreReadInt();
            this.coreReadInt();
            this.coreReadInt();
            this._dataOffset = this.coreReadInt();
            this._regionOffset = this.coreReadInt();
            this.coreReadInt();
            this.coreReadInt();
            this.coreReadInt();
        }

        private void parseMemory() throws IOException {
            this.coreSeek(this._regionOffset);
            this._memoryRanges = new ArrayList();
            MemoryRange memoryRange = null;
            for (int i = 0; i < this._regionCount; ++i) {
                long start = this.coreReadInt();
                this.coreReadInt();
                this.coreReadInt();
                int size = this.coreReadInt();
                this.coreReadInt();
                this.coreReadInt();
                this.coreReadInt();
                if (null == memoryRange) {
                    memoryRange = new MemoryRange(start, this._dataOffset, size);
                    continue;
                }
                if (memoryRange.getVirtualAddress() + memoryRange.getSize() == start) {
                    memoryRange = new MemoryRange(memoryRange.getVirtualAddress(), memoryRange.getFileOffset(), memoryRange.getSize() + (long)size);
                    continue;
                }
                this._memoryRanges.add(memoryRange);
                memoryRange = new MemoryRange(start, memoryRange.getFileOffset() + memoryRange.getSize(), size);
            }
            if (null != memoryRange) {
                this._memoryRanges.add(memoryRange);
            }
        }

        public void extract(Builder builder) {
            try {
                builder.buildProcess(builder.buildAddressSpace("Windows UserDump Address Space", 0), "", "", this.getEnvironmentVariables(builder), null, Collections.EMPTY_LIST.iterator(), null, Collections.EMPTY_LIST.iterator(), 32);
            }
            catch (MemoryAccessException memoryAccessException) {
                // empty catch block
            }
        }

        public Iterator getAdditionalFileNames() {
            return Collections.EMPTY_LIST.iterator();
        }

        protected MemoryRange[] getMemoryRangesAsArray() {
            return this._memoryRanges.toArray(new MemoryRange[this._memoryRanges.size()]);
        }

        protected boolean is64Bit() {
            return false;
        }
    }

    private static class MiniDump
    extends NewWinDump {
        private List _directory = null;
        private int _numberOfStreams = 0;
        private long _streamDirectoryRva = 0L;
        private int _timeAndDate = 0;
        private List _memoryRanges = null;
        private short _processorArchitecture = 0;
        private Object _executable = null;
        private List _threads = new ArrayList();
        private List _libraries = new ArrayList();
        private List _additionalFileNames = new ArrayList();
        private String _pid = null;
        private static final int INFO_BLOCK_ADDRESS = 131072;
        private static final int COMMAND_LINE_ADDRESS_ADDRESS_32 = 131140;
        private static final int COMMAND_LINE_ADDRESS_ADDRESS_64 = 131192;
        private static final int COMMAND_LINE_LENGTH_ADDRESS_32 = 131136;
        private static final int COMMAND_LINE_LENGTH_ADDRESS_64 = 131184;

        public MiniDump(ClosingFileReader f) throws IOException {
            super(f, MiniDump._pointerSizeForMiniDump(f));
            this.parseHeader();
            this.parseStreams();
        }

        private static int _pointerSizeForMiniDump(ClosingFileReader f) throws IOException {
            f.seek(0L);
            byte[] sig = new byte[4];
            f.readFully(sig);
            NewWinDump.littleEndianReadInt(f);
            int numberOfStreams = NewWinDump.littleEndianReadInt(f);
            int streamDirectoryRva = NewWinDump.littleEndianReadInt(f);
            NewWinDump.littleEndianReadInt(f);
            NewWinDump.littleEndianReadInt(f);
            f.seek(streamDirectoryRva);
            Vector<Stream> entries = new Vector<Stream>();
            for (int i = 0; i < numberOfStreams; ++i) {
                int location;
                int dataSize;
                int streamType = NewWinDump.littleEndianReadInt(f);
                Stream entry = Stream.create(streamType, dataSize = NewWinDump.littleEndianReadInt(f), location = NewWinDump.littleEndianReadInt(f));
                if (null == entry) continue;
                entries.add(entry);
            }
            for (Stream entry : entries) {
                int ptr = entry.readPtrSize(f);
                if (0 == ptr) continue;
                return ptr;
            }
            return 0;
        }

        public void addModule(String moduleName) {
            this._additionalFileNames.add(moduleName);
        }

        public Iterator getAdditionalFileNames() {
            return this._additionalFileNames.iterator();
        }

        public void addLibrary(Object module) {
            this._libraries.add(module);
        }

        public void setExecutable(Object module) {
            this._executable = module;
        }

        public void setProcessID(String pid) {
            this._pid = pid;
        }

        public void addThreads(List threads) {
            this._threads.addAll(threads);
        }

        protected void setProcessorArchitecture(short processorArchitecture, String procSubtype) {
            this._processorArchitecture = processorArchitecture;
            this._processorSubtypeDescription = procSubtype;
        }

        private long getCreationTime() {
            return (long)this._timeAndDate * 1000L;
        }

        protected short getProcessorArchitecture() {
            return this._processorArchitecture;
        }

        protected void setMemoryRanges(List memoryRanges) {
            this._memoryRanges = memoryRanges;
        }

        private void parseHeader() throws IOException {
            this.coreSeek(0L);
            this.coreReadBytes(4);
            this.coreReadInt();
            this._numberOfStreams = this.coreReadInt();
            this._streamDirectoryRva = this.coreReadInt();
            this.coreReadInt();
            this._timeAndDate = this.coreReadInt();
        }

        private void parseStreams() throws IOException {
            this.coreSeek(this._streamDirectoryRva);
            this._directory = new ArrayList();
            for (int i = 0; i < this._numberOfStreams; ++i) {
                int location;
                int dataSize;
                int streamType = this.coreReadInt();
                Stream entry = Stream.create(streamType, dataSize = this.coreReadInt(), location = this.coreReadInt());
                if (null == entry) continue;
                this._directory.add(entry);
            }
            for (Stream entry : this._directory) {
                entry.readFrom(this);
            }
        }

        public void extract(Builder builder) {
            try {
                Object addressSpace = builder.buildAddressSpace("Windows MiniDump Address Space", 0);
                for (Stream entry : this._directory) {
                    entry.readFrom(this, builder, addressSpace, this.getAddressSpace(), this.is64Bit());
                }
                String commandLine = this._extractCommandLine();
                builder.buildProcess(addressSpace, this._pid, commandLine, this.getEnvironmentVariables(builder), null, this._threads.iterator(), this._executable, this._libraries.iterator(), this._is64Bit ? 64 : 32);
            }
            catch (IOException e) {
            }
            catch (MemoryAccessException memoryAccessException) {
                // empty catch block
            }
            builder.setOSType("Windows");
            builder.setCPUType("x86");
            builder.setCPUSubType(this._processorSubtypeDescription);
            builder.setCreationTime(this.getCreationTime());
        }

        private String _extractCommandLine() {
            String commandLine = null;
            try {
                IAbstractAddressSpace memory = this.getAddressSpace();
                short length = memory.getShortAt(0, this.is64Bit() ? 131184L : 131136L);
                long commandAddress = memory.getPointerAt(0, this.is64Bit() ? 131192L : 131140L);
                byte[] buf = new byte[length];
                memory.getBytesAt(0, commandAddress, buf);
                commandLine = new String(buf, "UTF-16LE");
            }
            catch (MemoryAccessException e) {
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            return commandLine;
        }

        public boolean is64Bit() {
            return this._is64Bit;
        }

        protected MemoryRange[] getMemoryRangesAsArray() {
            return this._memoryRanges.toArray(new MemoryRange[this._memoryRanges.size()]);
        }

        private static class ThreadStream
        extends Stream {
            public ThreadStream(int dataSize, int location) {
                super(dataSize, location);
            }

            public void readFrom(MiniDump dump) throws IOException {
            }

            public void readFrom(MiniDump dump, Builder builder, Object addressSpace, IAbstractAddressSpace memory, boolean is64Bit) throws IOException {
                dump.coreSeek(this.getLocation());
                int numberOfThreads = dump.coreReadInt();
                ArrayList<Object> threads = new ArrayList<Object>();
                for (int i = 0; i < numberOfThreads; ++i) {
                    dump.coreSeek(this.getLocation() + 4L + (long)(i * 48));
                    int threadId = dump.coreReadInt();
                    dump.coreReadInt();
                    int priorityClass = dump.coreReadInt();
                    int priority = dump.coreReadInt();
                    dump.coreReadLong();
                    long stackStart = dump.coreReadLong();
                    long stackSize = 0xFFFFFFFFL & (long)dump.coreReadInt();
                    long stackRva = 0xFFFFFFFFL & (long)dump.coreReadInt();
                    long contextDataSize = 0xFFFFFFFFL & (long)dump.coreReadInt();
                    long contextRva = 0xFFFFFFFFL & (long)dump.coreReadInt();
                    Properties properties = new Properties();
                    properties.setProperty("priorityClass", String.valueOf(priorityClass));
                    properties.setProperty("priority", String.valueOf(priority));
                    List registers = this.readRegisters(dump, builder, contextRva, contextDataSize);
                    long stackEnd = stackStart + stackSize;
                    Object section = builder.buildStackSection(addressSpace, stackStart, stackEnd);
                    List frames = this.readStackFrames(dump, builder, addressSpace, stackStart, stackEnd, stackRva, registers, memory, is64Bit);
                    int signalNumber = 0;
                    threads.add(builder.buildThread(String.valueOf(threadId), registers.iterator(), Collections.singletonList(section).iterator(), frames.iterator(), properties, signalNumber));
                }
                dump.addThreads(threads);
            }

            private List readStackFrames(MiniDump dump, Builder builder, Object addressSpace, long stackStart, long stackEnd, long stackRva, List registers, IAbstractAddressSpace memory, boolean is64Bit) {
                int bytesPerPointer;
                long ebp = builder.getValueOfNamedRegister(registers, "ebp");
                long eip = builder.getValueOfNamedRegister(registers, "eip");
                long esp = builder.getValueOfNamedRegister(registers, "esp");
                ArrayList<Object> frames = new ArrayList<Object>();
                if (-1L == eip && stackStart <= esp && esp < stackEnd) {
                    try {
                        eip = memory.getPointerAt(0, esp);
                    }
                    catch (MemoryAccessException e) {
                        // empty catch block
                    }
                }
                int n = bytesPerPointer = is64Bit ? 8 : 4;
                if (stackStart <= ebp && ebp < stackEnd) {
                    frames.add(builder.buildStackFrame(addressSpace, ebp, eip));
                } else if (stackStart <= esp && esp < stackEnd) {
                    frames.add(builder.buildStackFrame(addressSpace, esp, eip));
                    ebp = esp + (long)bytesPerPointer;
                }
                while (stackStart <= ebp && ebp < stackEnd) {
                    try {
                        long newBP = memory.getPointerAt(0, ebp);
                        long retAddress = memory.getPointerAt(0, ebp + (long)bytesPerPointer);
                        frames.add(builder.buildStackFrame(addressSpace, newBP, retAddress));
                        ebp = newBP;
                    }
                    catch (MemoryAccessException e) {
                        break;
                    }
                }
                return frames;
            }

            private List readRegisters(MiniDump dump, Builder builder, long contextRva, long contextDataSize) throws IOException {
                switch (dump.getProcessorArchitecture()) {
                    case 9: {
                        return this.readAmd64Registers(dump, builder, contextRva, contextDataSize);
                    }
                    case 0: {
                        return this.readIntelRegisters(dump, builder, contextRva, contextDataSize);
                    }
                }
                return Collections.EMPTY_LIST;
            }

            private List readIntelRegisters(MiniDump dump, Builder builder, long contextRva, long contextDataSize) throws IOException {
                dump.coreSeek(contextRva + 140L);
                ArrayList<Object> registers = new ArrayList<Object>();
                registers.add(builder.buildRegister("gs", new Integer(dump.coreReadInt())));
                registers.add(builder.buildRegister("fs", new Integer(dump.coreReadInt())));
                registers.add(builder.buildRegister("es", new Integer(dump.coreReadInt())));
                registers.add(builder.buildRegister("ds", new Integer(dump.coreReadInt())));
                registers.add(builder.buildRegister("edi", new Integer(dump.coreReadInt())));
                registers.add(builder.buildRegister("esi", new Integer(dump.coreReadInt())));
                registers.add(builder.buildRegister("ebx", new Integer(dump.coreReadInt())));
                registers.add(builder.buildRegister("edx", new Integer(dump.coreReadInt())));
                registers.add(builder.buildRegister("ecx", new Integer(dump.coreReadInt())));
                registers.add(builder.buildRegister("eax", new Integer(dump.coreReadInt())));
                registers.add(builder.buildRegister("ebp", new Integer(dump.coreReadInt())));
                registers.add(builder.buildRegister("eip", new Integer(dump.coreReadInt())));
                registers.add(builder.buildRegister("cs", new Integer(dump.coreReadInt())));
                registers.add(builder.buildRegister("flags", new Integer(dump.coreReadInt())));
                registers.add(builder.buildRegister("esp", new Integer(dump.coreReadInt())));
                registers.add(builder.buildRegister("ss", new Integer(dump.coreReadInt())));
                return registers;
            }

            private List readAmd64Registers(MiniDump dump, Builder builder, long contextRva, long contextDataSize) throws IOException {
                dump.coreSeek(contextRva + 56L);
                ArrayList<Object> registers = new ArrayList<Object>();
                registers.add(builder.buildRegister("cs", new Short(dump.coreReadShort())));
                registers.add(builder.buildRegister("ds", new Short(dump.coreReadShort())));
                registers.add(builder.buildRegister("es", new Short(dump.coreReadShort())));
                registers.add(builder.buildRegister("fs", new Short(dump.coreReadShort())));
                registers.add(builder.buildRegister("gs", new Short(dump.coreReadShort())));
                registers.add(builder.buildRegister("ss", new Short(dump.coreReadShort())));
                registers.add(builder.buildRegister("flags", new Integer(dump.coreReadInt())));
                dump.coreSeek(contextRva + 120L);
                registers.add(builder.buildRegister("eax", new Long(dump.coreReadLong())));
                registers.add(builder.buildRegister("ecx", new Long(dump.coreReadLong())));
                registers.add(builder.buildRegister("edx", new Long(dump.coreReadLong())));
                registers.add(builder.buildRegister("ebx", new Long(dump.coreReadLong())));
                registers.add(builder.buildRegister("esp", new Long(dump.coreReadLong())));
                registers.add(builder.buildRegister("ebp", new Long(dump.coreReadLong())));
                registers.add(builder.buildRegister("esi", new Long(dump.coreReadLong())));
                registers.add(builder.buildRegister("edi", new Long(dump.coreReadLong())));
                registers.add(builder.buildRegister("r8", new Long(dump.coreReadLong())));
                registers.add(builder.buildRegister("r9", new Long(dump.coreReadLong())));
                registers.add(builder.buildRegister("r10", new Long(dump.coreReadLong())));
                registers.add(builder.buildRegister("r11", new Long(dump.coreReadLong())));
                registers.add(builder.buildRegister("r12", new Long(dump.coreReadLong())));
                registers.add(builder.buildRegister("r13", new Long(dump.coreReadLong())));
                registers.add(builder.buildRegister("r14", new Long(dump.coreReadLong())));
                registers.add(builder.buildRegister("r15", new Long(dump.coreReadLong())));
                registers.add(builder.buildRegister("ip", new Long(dump.coreReadLong())));
                return registers;
            }
        }

        private static class SystemInfoStream
        extends Stream {
            public SystemInfoStream(int dataSize, int location) {
                super(dataSize, location);
            }

            public void readFrom(MiniDump dump) throws IOException {
                dump.coreSeek(this.getLocation());
                short processorArchitecture = dump.coreReadShort();
                short processorLevel = dump.coreReadShort();
                short processorRevision = dump.coreReadShort();
                byte model = (byte)(processorRevision >> 8 & 0xFF);
                byte stepping = (byte)(processorRevision & 0xFF);
                String procSubtype = "Level " + processorLevel + " Model " + model + " Stepping " + stepping;
                dump.setProcessorArchitecture(processorArchitecture, procSubtype);
            }

            public int readPtrSize(ClosingFileReader f) {
                short processorArchitecture = 0;
                try {
                    f.seek(this.getLocation());
                    byte[] buffer = new byte[2];
                    f.readFully(buffer);
                    processorArchitecture = (short)((0xFF & buffer[1]) << 8 | 0xFF & buffer[0]);
                }
                catch (IOException e) {
                    return 0;
                }
                return 9 == processorArchitecture || 6 == processorArchitecture || 7 == processorArchitecture || 10 == processorArchitecture ? 64 : 32;
            }

            public void readFrom(MiniDump dump, Builder builder, Object addressSpace, IAbstractAddressSpace memory, boolean is64Bit) throws IOException {
            }
        }

        private static class ModuleStream
        extends Stream {
            public ModuleStream(int dataSize, int location) {
                super(dataSize, location);
            }

            public void readFrom(MiniDump dump) throws IOException {
            }

            public void readFrom(MiniDump dump, Builder builder, Object addressSpace, IAbstractAddressSpace memory, boolean is64Bit) throws IOException {
                int i;
                dump.coreSeek(this.getLocation());
                int numberOfModules = dump.coreReadInt();
                class Module {
                    int nameAddress = -1;
                    long imageBaseAddress = -1L;
                    Properties properties = new Properties();

                    Module() {
                    }
                }
                Module[] modules = new Module[numberOfModules];
                for (i = 0; i < numberOfModules; ++i) {
                    modules[i] = new Module();
                    modules[i].imageBaseAddress = dump.coreReadLong();
                    int imageSize = dump.coreReadInt();
                    int checksum = dump.coreReadInt();
                    int timeDateStamp = dump.coreReadInt();
                    modules[i].nameAddress = dump.coreReadInt();
                    int versionInfoDwSignature = dump.coreReadInt();
                    int versionInfoDwStrucVersion = dump.coreReadInt();
                    int versionInfoDwFileVersionMS = dump.coreReadInt();
                    int versionInfoDwFileVersionLS = dump.coreReadInt();
                    int versionInfoDwProductVersionMS = dump.coreReadInt();
                    int versionInfoDwProductVersionLS = dump.coreReadInt();
                    int versionInfoDwFileFlagsMask = dump.coreReadInt();
                    int versionInfoDwFileFlags = dump.coreReadInt();
                    int versionInfoDwFileOS = dump.coreReadInt();
                    int versionInfoDwFileType = dump.coreReadInt();
                    int versionInfoDwFileSubtype = dump.coreReadInt();
                    int versionInfoDwFileDateMS = dump.coreReadInt();
                    int versionInfoDwFileDateLS = dump.coreReadInt();
                    dump.coreReadInt();
                    dump.coreReadInt();
                    dump.coreReadInt();
                    dump.coreReadInt();
                    dump.coreReadLong();
                    dump.coreReadLong();
                    modules[i].properties.setProperty("imageSize", Integer.toHexString(imageSize));
                    modules[i].properties.setProperty("checksum", Integer.toHexString(checksum));
                    modules[i].properties.setProperty("timeDateStamp", new Date(1000L * ((long)timeDateStamp + 28800L)).toString());
                    modules[i].properties.setProperty("versionInfoDwSignature", Integer.toHexString(versionInfoDwSignature));
                    modules[i].properties.setProperty("versionInfoDwStrucVersion", Integer.toHexString(versionInfoDwStrucVersion));
                    modules[i].properties.setProperty("versionInfoDwFileVersionMS", Integer.toHexString(versionInfoDwFileVersionMS));
                    modules[i].properties.setProperty("versionInfoDwFileVersionLS", Integer.toHexString(versionInfoDwFileVersionLS));
                    modules[i].properties.setProperty("versionInfoDwProductVersionMS", Integer.toHexString(versionInfoDwProductVersionMS));
                    modules[i].properties.setProperty("versionInfoDwProductVersionLS", Integer.toHexString(versionInfoDwProductVersionLS));
                    modules[i].properties.setProperty("versionInfoDwFileFlagsMask", Integer.toHexString(versionInfoDwFileFlagsMask));
                    modules[i].properties.setProperty("versionInfoDwFileFlags", Integer.toHexString(versionInfoDwFileFlags));
                    modules[i].properties.setProperty("versionInfoDwFileOS", Integer.toHexString(versionInfoDwFileOS));
                    modules[i].properties.setProperty("versionInfoDwFileType", Integer.toHexString(versionInfoDwFileType));
                    modules[i].properties.setProperty("versionInfoDwFileSubtype", Integer.toHexString(versionInfoDwFileSubtype));
                    modules[i].properties.setProperty("versionInfoDwFileDateMS", Integer.toHexString(versionInfoDwFileDateMS));
                    modules[i].properties.setProperty("versionInfoDwFileDateLS", Integer.toHexString(versionInfoDwFileDateLS));
                }
                for (i = 0; i < modules.length; ++i) {
                    String moduleName = this.getModuleName(dump, modules[i].nameAddress);
                    try {
                        short magic = memory.getShortAt(0, modules[i].imageBaseAddress);
                        if (23117 != magic) {
                            System.err.println("Magic number was: " + Integer.toHexString(0xFFFF & magic));
                        }
                    }
                    catch (MemoryAccessException e1) {
                        e1.printStackTrace();
                    }
                    long e_lfanewAddress = modules[i].imageBaseAddress + 60L;
                    Vector<Object> sections = new Vector<Object>();
                    try {
                        long e_lfanew = 0xFFFFFFFFL & (long)memory.getIntAt(0, e_lfanewAddress);
                        long readingAddress = e_lfanew + modules[i].imageBaseAddress;
                        if (0L != e_lfanew) {
                            int pemagic = memory.getIntAt(0, readingAddress);
                            readingAddress += 4L;
                            if (17744 != pemagic) {
                                System.err.println("PE Magic is: \"" + Integer.toHexString(pemagic));
                            }
                            int numberOfSections = memory.getShortAt(0, readingAddress += 2L);
                            readingAddress += 2L;
                            readingAddress += 4L;
                            readingAddress += 4L;
                            short sizeOfOptionalHeader = memory.getShortAt(0, readingAddress += 4L);
                            readingAddress += 2L;
                            readingAddress += 2L;
                            readingAddress = modules[i].imageBaseAddress + e_lfanew + 24L + (0xFFFFL & (long)sizeOfOptionalHeader);
                            for (int j = 0; j < numberOfSections; ++j) {
                                byte[] rawName = new byte[8];
                                memory.getBytesAt(0, readingAddress, rawName);
                                long virtualSize = memory.getIntAt(0, readingAddress += 8L);
                                long virtualAddress = memory.getIntAt(0, readingAddress += 4L);
                                readingAddress += 4L;
                                readingAddress += 4L;
                                readingAddress += 4L;
                                readingAddress += 4L;
                                readingAddress += 4L;
                                readingAddress += 2L;
                                readingAddress += 2L;
                                readingAddress += 4L;
                                long relocatedAddress = virtualAddress + modules[i].imageBaseAddress;
                                Object oneSection = builder.buildModuleSection(addressSpace, new String(rawName), relocatedAddress, relocatedAddress + virtualSize);
                                sections.add(oneSection);
                            }
                        }
                        Object module = builder.buildModule(moduleName, modules[i].properties, sections.iterator(), this._buildSymbolIterator(dump, memory, builder, addressSpace, modules[i].imageBaseAddress, modules[i].imageBaseAddress), modules[i].imageBaseAddress);
                        if (moduleName.toLowerCase().endsWith(".exe")) {
                            dump.setExecutable(module);
                        } else {
                            dump.addLibrary(module);
                        }
                    }
                    catch (MemoryAccessException e) {
                        // empty catch block
                    }
                    dump.addModule(moduleName);
                }
            }

            private Iterator _buildSymbolIterator(MiniDump dump, IAbstractAddressSpace memory, Builder builder, Object addressSpace, long imageBase, long moduleLoadAddress) {
                try {
                    short magicShort;
                    byte[] magic = new byte[2];
                    memory.getBytesAt(0, imageBase, magic);
                    String stuff = new String(magic);
                    if (!stuff.equals("MZ")) {
                        return Collections.singleton(builder.buildCorruptData(addressSpace, "Invalid image magic number: \"" + stuff + "\"", imageBase)).iterator();
                    }
                    int peInt = memory.getIntAt(0, imageBase + 60L);
                    long peBase = ((long)peInt & 0xFFFFFFFFL) + imageBase;
                    memory.getBytesAt(0, peBase, magic);
                    stuff = new String(magic);
                    if (!stuff.equals("PE")) {
                        return Collections.singleton(builder.buildCorruptData(addressSpace, "Invalid PE magic number: \"" + stuff + "\"", peBase)).iterator();
                    }
                    long nextRead = peBase + 4L;
                    nextRead += 2L;
                    nextRead += 2L;
                    nextRead += 4L;
                    nextRead += 4L;
                    long imageOptionalHeaderSizeAddress = nextRead += 4L;
                    short optionalHeaderSize = memory.getShortAt(0, imageOptionalHeaderSizeAddress);
                    nextRead += 2L;
                    nextRead += 2L;
                    if (224 == optionalHeaderSize) {
                        magicShort = memory.getShortAt(0, nextRead);
                        if (267 != magicShort) {
                            return Collections.singleton(builder.buildCorruptData(addressSpace, "Invalid IMAGE_OPTIONAL_HEADER magic number: \"0x" + Integer.toHexString(0xFFFF & magicShort) + "\"", nextRead)).iterator();
                        }
                        nextRead += 2L;
                        ++nextRead;
                        ++nextRead;
                        nextRead += 4L;
                        nextRead += 4L;
                        nextRead += 4L;
                        nextRead += 4L;
                        nextRead += 4L;
                        nextRead += 4L;
                        nextRead += 4L;
                        nextRead += 4L;
                        nextRead += 4L;
                        nextRead += 2L;
                        nextRead += 2L;
                        nextRead += 2L;
                        nextRead += 2L;
                        nextRead += 2L;
                        nextRead += 2L;
                        nextRead += 4L;
                        nextRead += 4L;
                        nextRead += 4L;
                        nextRead += 4L;
                        nextRead += 2L;
                        nextRead += 2L;
                        nextRead += 4L;
                        nextRead += 4L;
                        nextRead += 4L;
                        nextRead += 4L;
                        nextRead += 4L;
                        nextRead += 4L;
                    } else if (240 == optionalHeaderSize) {
                        magicShort = memory.getShortAt(0, nextRead);
                        if (523 != magicShort) {
                            return Collections.singleton(builder.buildCorruptData(addressSpace, "Invalid IMAGE_OPTIONAL_HEADER64 magic number: \"0x" + Integer.toHexString(0xFFFF & magicShort) + "\"", nextRead)).iterator();
                        }
                        nextRead += 2L;
                        ++nextRead;
                        ++nextRead;
                        nextRead += 4L;
                        nextRead += 4L;
                        nextRead += 4L;
                        nextRead += 4L;
                        nextRead += 4L;
                        nextRead += 8L;
                        nextRead += 4L;
                        nextRead += 4L;
                        nextRead += 2L;
                        nextRead += 2L;
                        nextRead += 2L;
                        nextRead += 2L;
                        nextRead += 2L;
                        nextRead += 2L;
                        nextRead += 4L;
                        nextRead += 4L;
                        nextRead += 4L;
                        nextRead += 4L;
                        nextRead += 2L;
                        nextRead += 2L;
                        nextRead += 8L;
                        nextRead += 8L;
                        nextRead += 8L;
                        nextRead += 8L;
                        nextRead += 4L;
                        nextRead += 4L;
                    } else {
                        return Collections.singleton(builder.buildCorruptData(addressSpace, "Invalid IMAGE_OPTIONAL_HEADER size: \"" + optionalHeaderSize + "\" bytes", imageOptionalHeaderSizeAddress)).iterator();
                    }
                    int exportRVA = memory.getIntAt(0, nextRead);
                    nextRead += 4L;
                    if (0 == exportRVA) {
                        return Collections.EMPTY_LIST.iterator();
                    }
                    nextRead += 4L;
                    nextRead = moduleLoadAddress + ((long)exportRVA & 0xFFFFFFFFL);
                    nextRead += 4L;
                    nextRead += 4L;
                    nextRead += 2L;
                    nextRead += 2L;
                    nextRead += 4L;
                    long numberOfFunctionsAddress = nextRead += 4L;
                    int numberOfFunctions = memory.getIntAt(0, numberOfFunctionsAddress);
                    int numberOfNames = memory.getIntAt(0, nextRead += 4L);
                    nextRead += 4L;
                    if (numberOfFunctions < numberOfNames) {
                        return Collections.singleton(builder.buildCorruptData(addressSpace, "IMAGE_EXPORT_DIRECTORY NumberOfFunctions (" + numberOfFunctions + ") < NumberOfNames (" + numberOfNames + ")", numberOfFunctionsAddress)).iterator();
                    }
                    long funcAddress = (long)memory.getIntAt(0, nextRead) & 0xFFFFFFFFL;
                    long nameAddress = (long)memory.getIntAt(0, nextRead += 4L) & 0xFFFFFFFFL;
                    long ordinalAddress = (long)memory.getIntAt(0, nextRead += 4L) & 0xFFFFFFFFL;
                    nextRead += 4L;
                    int[] nameAddresses = new int[numberOfNames];
                    nextRead = nameAddress + moduleLoadAddress;
                    for (int x = 0; x < numberOfNames; ++x) {
                        nameAddresses[x] = memory.getIntAt(0, nextRead);
                        nextRead += 4L;
                    }
                    long[] addresses = new long[numberOfFunctions];
                    nextRead = funcAddress + moduleLoadAddress;
                    for (int x = 0; x < numberOfFunctions; ++x) {
                        addresses[x] = memory.getIntAt(0, nextRead);
                        nextRead += 4L;
                    }
                    short[] ordinals = new short[numberOfNames];
                    nextRead = ordinalAddress + moduleLoadAddress;
                    for (int x = 0; x < numberOfNames; ++x) {
                        ordinals[x] = memory.getShortAt(0, nextRead);
                        nextRead += 2L;
                    }
                    String[] names = new String[numberOfNames];
                    byte[] buffer = new byte[1024];
                    for (int x = 0; x < numberOfNames; ++x) {
                        nextRead = ((long)nameAddresses[x] & 0xFFFFFFFFL) + moduleLoadAddress;
                        Arrays.fill(buffer, (byte)0);
                        int index = 0;
                        byte thisByte = 0;
                        do {
                            thisByte = memory.getByteAt(0, nextRead);
                            ++nextRead;
                            buffer[index] = thisByte;
                            ++index;
                        } while (0 != thisByte);
                        names[x] = new String(buffer, 0, index - 1);
                    }
                    Vector<Object> symbols = new Vector<Object>();
                    for (int x = 0; x < numberOfNames; ++x) {
                        short index = ordinals[x];
                        long relocatedFunctionAddress = addresses[index] + moduleLoadAddress;
                        String functionName = names[x];
                        Object symbol = builder.buildSymbol(addressSpace, functionName, relocatedFunctionAddress);
                        symbols.add(symbol);
                    }
                    return symbols.iterator();
                }
                catch (MemoryAccessException e) {
                    return Collections.singleton(builder.buildCorruptData(addressSpace, e.getMessage(), e.getAddress())).iterator();
                }
            }

            private String getModuleName(MiniDump dump, int position) throws IOException {
                dump.coreSeek(position);
                int length = dump.coreReadInt();
                if (length <= 0 || 512 <= length) {
                    length = 512;
                }
                byte[] nameWide = dump.coreReadBytes(length);
                return new String(nameWide, "UTF-16LE");
            }
        }

        private static class Memory64Stream
        extends Stream {
            public Memory64Stream(int dataSize, int location) {
                super(dataSize, location);
            }

            public void readFrom(MiniDump dump) throws IOException {
                long location = this.getLocation();
                dump.coreSeek(location);
                long numberOfMemoryRanges = dump.coreReadLong();
                long baseAddress = dump.coreReadLong();
                ArrayList<MemoryRange> memoryRanges = new ArrayList<MemoryRange>();
                MemoryRange memoryRange = null;
                int i = 0;
                while ((long)i < numberOfMemoryRanges) {
                    long start = dump.coreReadLong();
                    long size = dump.coreReadLong();
                    if (null == memoryRange) {
                        memoryRange = new MemoryRange(start, baseAddress, size, 0, false, false, true);
                    } else if (memoryRange.getVirtualAddress() + memoryRange.getSize() == start) {
                        memoryRange = new MemoryRange(memoryRange.getVirtualAddress(), memoryRange.getFileOffset(), memoryRange.getSize() + size, 0, false, false, true);
                    } else {
                        memoryRanges.add(memoryRange);
                        memoryRange = new MemoryRange(start, memoryRange.getFileOffset() + memoryRange.getSize(), size, 0, false, false, true);
                    }
                    ++i;
                }
                if (null != memoryRange) {
                    memoryRanges.add(memoryRange);
                }
                dump.setMemoryRanges(memoryRanges);
            }

            public void readFrom(MiniDump dump, Builder builder, Object addressSpace, IAbstractAddressSpace memory, boolean is64Bit) throws IOException {
            }
        }

        private static class MiscInfoStream
        extends Stream {
            private static final int MISC1_PROCESS_ID = 1;

            public MiscInfoStream(int dataSize, int location) {
                super(dataSize, location);
            }

            public void readFrom(MiniDump dump) throws IOException {
            }

            public void readFrom(MiniDump dump, Builder builder, Object addressSpace, IAbstractAddressSpace memory, boolean is64Bit) throws IOException {
                dump.coreSeek(this.getLocation());
                if (this.getDataSize() < 4) {
                    return;
                }
                int infoSize = dump.coreReadInt();
                if (infoSize > this.getDataSize()) {
                    infoSize = this.getDataSize();
                }
                if ((infoSize = infoSize / 4 - 1) <= 0) {
                    return;
                }
                int[] misc = new int[infoSize];
                for (int i = 0; i < infoSize; ++i) {
                    misc[i] = dump.coreReadInt();
                }
                int flags = misc[0];
                if ((flags & 1) != 0 && infoSize > 1) {
                    dump.setProcessID(String.valueOf(misc[1]));
                }
            }
        }

        private static abstract class Stream {
            protected static final int PROCESSOR_ARCHITECTURE_INTEL = 0;
            protected static final int PROCESSOR_ARCHITECTURE_IA64 = 6;
            protected static final int PROCESSOR_ARCHITECTURE_ALPHA64 = 7;
            protected static final int PROCESSOR_ARCHITECTURE_AMD64 = 9;
            protected static final int PROCESSOR_ARCHITECTURE_IA32_ON_WIN64 = 10;
            private static final int THREADLIST = 3;
            private static final int MODULELIST = 4;
            private static final int SYSTEMINFO = 7;
            private static final int MEMORY64LIST = 9;
            private static final int MISCINFO = 15;
            private int _dataSize;
            private long _location;

            public static Stream create(int streamType, int dataSize, int location) {
                switch (streamType) {
                    case 3: {
                        return new ThreadStream(dataSize, location);
                    }
                    case 4: {
                        return new ModuleStream(dataSize, location);
                    }
                    case 7: {
                        return new SystemInfoStream(dataSize, location);
                    }
                    case 9: {
                        return new Memory64Stream(dataSize, location);
                    }
                    case 15: {
                        return new MiscInfoStream(dataSize, location);
                    }
                }
                return null;
            }

            protected Stream(int dataSize, long location) {
                this._dataSize = dataSize;
                this._location = location;
            }

            protected int getDataSize() {
                return this._dataSize;
            }

            protected long getLocation() {
                return this._location;
            }

            public int readPtrSize(ClosingFileReader f) {
                return 0;
            }

            public abstract void readFrom(MiniDump var1) throws IOException;

            public abstract void readFrom(MiniDump var1, Builder var2, Object var3, IAbstractAddressSpace var4, boolean var5) throws IOException;
        }
    }
}

