/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.corereaders;

import com.ibm.dtfj.corereaders.ClosingFileReader;
import com.ibm.dtfj.corereaders.CorruptCoreException;
import com.ibm.dtfj.corereaders.ICoreFileReader;
import com.ibm.dtfj.corereaders.NewAixDump;
import com.ibm.dtfj.corereaders.NewElfDump;
import com.ibm.dtfj.corereaders.NewWinDump;
import com.ibm.dtfj.corereaders.NewZosDump;
import java.io.IOException;

public class DumpFactory {
    public static ICoreFileReader createDumpForCore(ClosingFileReader file) throws IOException {
        return DumpFactory.createDumpForCore(file, false);
    }

    public static ICoreFileReader createDumpForCore(ClosingFileReader file, boolean verbose) throws IOException {
        ICoreFileReader corefile = null;
        try {
            if (NewWinDump.isSupportedDump(file)) {
                corefile = NewWinDump.dumpFromFile(file);
            } else if (NewElfDump.isSupportedDump(file)) {
                corefile = NewElfDump.dumpFromFile(file, verbose);
            } else if (NewAixDump.isSupportedDump(file)) {
                corefile = NewAixDump.dumpFromFile(file);
            } else if (NewZosDump.isSupportedDump(file)) {
                corefile = NewZosDump.dumpFromFile(file);
            }
        }
        catch (CorruptCoreException e) {
            System.err.println("Core file was identified but found to be corrupt:  " + e.getMessage());
        }
        return corefile;
    }
}

