/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.corereaders;

import com.ibm.dtfj.addressspace.DumpReaderAddressSpace;
import com.ibm.dtfj.addressspace.IAbstractAddressSpace;
import com.ibm.dtfj.corereaders.DumpReader;
import com.ibm.dtfj.corereaders.ICoreFileReader;
import com.ibm.dtfj.corereaders.MemoryRange;
import java.io.IOException;

public abstract class CoreReaderSupport
implements ICoreFileReader {
    private DumpReader _reader;
    private IAbstractAddressSpace _addressSpace = null;

    protected abstract MemoryRange[] getMemoryRangesAsArray();

    protected abstract boolean isLittleEndian();

    protected abstract boolean is64Bit();

    public CoreReaderSupport(DumpReader reader) {
        this._reader = reader;
    }

    protected int coreReadInt() throws IOException {
        return this._reader.readInt();
    }

    protected void coreSeek(long position) throws IOException {
        this._reader.seek(position);
    }

    protected long coreReadLong() throws IOException {
        return this._reader.readLong();
    }

    protected long coreReadAddress() throws IOException {
        return this._reader.readAddress();
    }

    protected short coreReadShort() throws IOException {
        return this._reader.readShort();
    }

    protected byte coreReadByte() throws IOException {
        return this._reader.readByte();
    }

    protected byte[] coreReadBytes(int n) throws IOException {
        return this._reader.readBytes(n);
    }

    public IAbstractAddressSpace getAddressSpace() {
        if (null == this._addressSpace) {
            this._addressSpace = new DumpReaderAddressSpace(this.getMemoryRangesAsArray(), this._reader, this.isLittleEndian(), this.is64Bit());
        }
        return this._addressSpace;
    }
}

