/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.binaryreaders;

import com.ibm.dtfj.corereaders.Builder;
import com.ibm.dtfj.corereaders.ClosingFileReader;
import java.io.IOException;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;

public class XCOFFReader {
    private static final short XCOFF_MAGIC_NUMBER_AIX32 = 479;
    private static final short XCOFF_MAGIC_NUMBER_AIX64_PRE43 = 495;
    private static final short XCOFF_MAGIC_NUMBER_AIX64_POST51 = 503;
    private ClosingFileReader _backing;
    private long _startOffset;
    private long _size;
    private boolean _is64Bit;
    private long _textSegmentOffset = -1L;
    private long _textSegmentSize = -1L;
    private long _sybolTableOffset = -1L;
    private long _timeAndDate = 0L;
    private short _flags = 0;
    private static final short F_RELFLG = 1;
    private static final short F_EXEC = 2;
    private static final short F_LNNO = 4;
    private static final short F_AR32W = 512;
    private static final short F_DYNLOAD = 4096;
    private static final short F_SHROBJ = 8192;
    private static final short F_LOADONLY = 16384;

    public XCOFFReader(ClosingFileReader backing, long offsetIntoFile, long size) throws IOException {
        this._startOffset = offsetIntoFile;
        this._size = size;
        this._backing = backing;
        this.seekFileRelative(0L);
        short magic = this._backing.readShort();
        if (479 != magic && 495 != magic && 503 != magic) {
            throw new IllegalArgumentException();
        }
        this._is64Bit = 495 == magic || 503 == magic;
        int numberOfSections = this._backing.readShort();
        this._timeAndDate = 1000L * (0xFFFFFFFFL & (long)this._backing.readInt());
        this._sybolTableOffset = this._is64Bit ? this._backing.readLong() : 0xFFFFFFFFL & (long)this._backing.readInt();
        this.seekFileRelative(16L);
        short optionalHeaderSize = this._backing.readShort();
        this._flags = this._backing.readShort();
        long nextSectionAddress = 20 + optionalHeaderSize;
        for (int x = 0; x < numberOfSections; ++x) {
            this.seekFileRelative(nextSectionAddress);
            byte[] buffer = new byte[8];
            this._backing.readFully(buffer);
            String sectionName = new String(buffer);
            this.seekFileRelative(nextSectionAddress + (long)(this._is64Bit ? 24 : 16));
            long sectionSize = this._is64Bit ? this._backing.readLong() : (long)this._backing.readInt();
            long fileOffset = this._is64Bit ? this._backing.readLong() : (long)this._backing.readInt();
            nextSectionAddress += (long)(this._is64Bit ? 72 : 40);
            if (!sectionName.startsWith(".text")) continue;
            this._textSegmentOffset = fileOffset + this._startOffset;
            this._textSegmentSize = sectionSize;
        }
    }

    public XCOFFReader(ClosingFileReader backing) throws IOException {
        this(backing, 0L, backing.length());
    }

    public long getTextSegmentOffset() {
        return this._textSegmentOffset;
    }

    private void seekFileRelative(long offset) throws IOException {
        this._backing.seek(this._startOffset + offset);
    }

    public long getTextSegmentSize() {
        return this._textSegmentSize;
    }

    private long _symbolTableOffset() throws IOException {
        return this._sybolTableOffset;
    }

    private int _numberOfSymbols() throws IOException {
        this.seekFileRelative(this._is64Bit ? 20L : 12L);
        return this._backing.readInt();
    }

    private String _stringFromArray(byte[] rawData, int start) {
        int end;
        for (end = start; end < rawData.length && 0 != rawData[end]; ++end) {
        }
        return new String(rawData, start, end - start);
    }

    public ClosingFileReader underlyingFile() {
        return this._backing;
    }

    public long baseFileOffset() {
        return this._startOffset;
    }

    public long logicalSize() {
        return this._size;
    }

    public Properties moduleProperties() {
        Properties props = new Properties();
        props.put("Time and Date", new Date(this._timeAndDate).toString());
        String flagRep = (0 != (this._flags & 1) ? "F_RELFLG " : "") + (0 != (this._flags & 2) ? "F_EXEC " : "") + (0 != (this._flags & 4) ? "F_LNNO " : "") + (0 != (this._flags & 0x200) ? "F_AR32W " : "") + (0 != (this._flags & 0x1000) ? "F_DYNLOAD " : "") + (0 != (this._flags & 0x2000) ? "F_SHROBJ " : "") + (0 != (this._flags & 0x4000) ? "F_LOADONLY " : "");
        props.put("Flags", flagRep);
        return props;
    }

    public List buildSymbols(Builder builder, Object addressSpace, long relocationBase) {
        LinkedList<Object> symbols = new LinkedList<Object>();
        try {
            long symbolTableOffset = this._symbolTableOffset();
            int numberOfSymbols = this._numberOfSymbols();
            if (0L != symbolTableOffset) {
                this.seekFileRelative(symbolTableOffset + (long)(18 * numberOfSymbols));
                int stringTableLength = this._backing.readInt();
                if (4 != stringTableLength && 0 != stringTableLength) {
                    byte[] rawStringTable = new byte[stringTableLength - 4];
                    this._backing.readFully(rawStringTable);
                    this.seekFileRelative(symbolTableOffset);
                    byte[] symbolTableEntry = new byte[18];
                    int skipNext = 0;
                    for (int x = 0; x < numberOfSymbols; ++x) {
                        this._backing.readFully(symbolTableEntry);
                        if (skipNext > 0) {
                            --skipNext;
                            continue;
                        }
                        int stringTableOffset = 0;
                        String symbolName = null;
                        if (this._is64Bit) {
                            stringTableOffset = (0xFF & symbolTableEntry[8]) << 24 | (0xFF & symbolTableEntry[9]) << 16 | (0xFF & symbolTableEntry[10]) << 8 | 0xFF & symbolTableEntry[11];
                        } else if (0 == symbolTableEntry[0] && 0 == symbolTableEntry[1] && 0 == symbolTableEntry[2] && 0 == symbolTableEntry[3]) {
                            stringTableOffset = (0xFF & symbolTableEntry[4]) << 24 | (0xFF & symbolTableEntry[5]) << 16 | (0xFF & symbolTableEntry[6]) << 8 | 0xFF & symbolTableEntry[7];
                        } else {
                            symbolName = this._stringFromArray(symbolTableEntry, 0);
                        }
                        if (null == symbolName && 0 == (symbolTableEntry[16] & 0x80) && 0 != stringTableOffset && stringTableOffset < stringTableLength - 4) {
                            symbolName = this._stringFromArray(rawStringTable, stringTableOffset - 4);
                        } else if (0 == (symbolTableEntry[16] & 0x80) && stringTableOffset > stringTableLength - 4) {
                            symbolName = "(string out of table bounds)";
                        }
                        if (null == symbolName) {
                            symbolName = "";
                        }
                        long value = 0L;
                        value = this._is64Bit ? (long)((0xFF & symbolTableEntry[0]) << 56 | (0xFF & symbolTableEntry[1]) << 48 | (0xFF & symbolTableEntry[2]) << 40 | (0xFF & symbolTableEntry[3]) << 32 | (0xFF & symbolTableEntry[4]) << 24 | (0xFF & symbolTableEntry[5]) << 16 | (0xFF & symbolTableEntry[6]) << 8 | 0xFF & symbolTableEntry[7]) : (long)((0xFF & symbolTableEntry[8]) << 24 | (0xFF & symbolTableEntry[9]) << 16 | (0xFF & symbolTableEntry[10]) << 8 | 0xFF & symbolTableEntry[11]);
                        symbols.add(builder.buildSymbol(addressSpace, symbolName, value + relocationBase));
                        skipNext = symbolTableEntry[17];
                    }
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return symbols;
    }
}

