/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.addressspace;

import com.ibm.dtfj.addressspace.CommonAddressSpace;
import com.ibm.dtfj.corereaders.DumpReader;
import com.ibm.dtfj.corereaders.MemoryAccessException;
import com.ibm.dtfj.corereaders.MemoryRange;
import java.io.IOException;

public class DumpReaderAddressSpace
extends CommonAddressSpace {
    private DumpReader _reader;

    public DumpReaderAddressSpace(MemoryRange[] ranges, DumpReader reader, boolean isLittleEndian, boolean is64Bit) {
        super(ranges, false, is64Bit);
        this._reader = reader;
    }

    public boolean isExecutable(int asid, long address) throws MemoryAccessException {
        MemoryRange match = this._residentRange(asid, address);
        return match.isExecutable();
    }

    public boolean isReadOnly(int asid, long address) throws MemoryAccessException {
        MemoryRange match = this._residentRange(asid, address);
        return match.isReadOnly();
    }

    public boolean isShared(int asid, long address) throws MemoryAccessException {
        MemoryRange match = this._residentRange(asid, address);
        return match.isShared();
    }

    protected long _translateAddress(int asid, long address) throws MemoryAccessException {
        MemoryRange match = this._residentRange(asid, address);
        if (null != match) {
            return match.getFileOffset() + (address - match.getVirtualAddress());
        }
        throw new MemoryAccessException(asid, address);
    }

    public int getBytesAt(int asid, long address, byte[] buffer) throws MemoryAccessException {
        int bytesRead;
        int size;
        for (bytesRead = 0; bytesRead < buffer.length; bytesRead += size) {
            long adjustedAddress = address + ((long)bytesRead & 0xFFFFFFFFFFFFFFFFL);
            MemoryRange match = this._residentRange(asid, adjustedAddress);
            long offset = adjustedAddress - match.getVirtualAddress();
            long bytesAvailable = match.getSize() - offset;
            size = bytesAvailable > Integer.MAX_VALUE ? buffer.length - bytesRead : Math.min((int)bytesAvailable, buffer.length - bytesRead);
            try {
                if (match.isInCoreFile()) {
                    this._reader.seek(match.getFileOffset() + offset);
                    byte[] temp = this._reader.readBytes(size);
                    System.arraycopy(temp, 0, buffer, bytesRead, temp.length);
                    continue;
                }
                DumpReader reader = match.getLibraryReader();
                if (reader != null) {
                    reader.seek(offset);
                    byte[] temp = reader.readBytes(size);
                    System.arraycopy(temp, 0, buffer, bytesRead, temp.length);
                    continue;
                }
                throw new MemoryAccessException(asid, adjustedAddress, "Cannot read memory external to core file");
            }
            catch (IOException e) {
                throw new MemoryAccessException(asid, adjustedAddress, "IOException reading core file: " + e.getMessage());
            }
        }
        return bytesRead;
    }

    public long getLongAt(int asid, long address) throws MemoryAccessException {
        long fileOffset = this._translateAddress(asid, address);
        try {
            this._reader.seek(fileOffset);
            return this._reader.readLong();
        }
        catch (IOException e) {
            throw new MemoryAccessException(asid, address);
        }
    }

    public int getIntAt(int asid, long address) throws MemoryAccessException {
        long fileOffset = this._translateAddress(asid, address);
        try {
            this._reader.seek(fileOffset);
            return this._reader.readInt();
        }
        catch (IOException e) {
            throw new MemoryAccessException(asid, address);
        }
    }

    public short getShortAt(int asid, long address) throws MemoryAccessException {
        long fileOffset = this._translateAddress(asid, address);
        try {
            this._reader.seek(fileOffset);
            return this._reader.readShort();
        }
        catch (IOException e) {
            throw new MemoryAccessException(asid, address);
        }
    }

    public byte getByteAt(int asid, long address) throws MemoryAccessException {
        long fileOffset = this._translateAddress(asid, address);
        try {
            this._reader.seek(fileOffset);
            return this._reader.readByte();
        }
        catch (IOException e) {
            throw new MemoryAccessException(asid, address);
        }
    }

    public long getPointerAt(int asid, long address) throws MemoryAccessException {
        return super.getPointerAt(asid, address);
    }
}

