/*
 * Decompiled with CFR 0.152.
 */
import com.sun.java.accessibility.util.AccessibilityEventMonitor;
import com.sun.java.accessibility.util.EventQueueMonitor;
import com.sun.java.accessibility.util.GUIInitializedListener;
import com.sun.java.accessibility.util.SwingEventMonitor;
import com.sun.java.accessibility.util.Translator;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleText;
import javax.accessibility.AccessibleValue;
import javax.swing.JButton;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;

public class JawBridge
implements PropertyChangeListener,
FocusListener,
GUIInitializedListener {
    static debugfile out = new debugfile();
    debugWindow dw = null;
    Rectangle txtRect = new Rectangle();
    Rectangle ADRect = new Rectangle();
    String FocusClass = null;
    boolean SliderInverted = false;
    String parentClass = "javax.swing.JComponent";
    AccessibleContext armedAC = null;

    public native void setNativeCaretPosition(long var1, int var3, int var4, int var5, int var6);

    private native long getNativeWindowHandleFromWindow(Window var1);

    public static void main(String[] args) {
        String vers = System.getProperty("java.version");
        if (vers.compareTo("1.4.1") < 0) {
            out.println("JAVA: WARNING: This version of JawBridge was developedfor use with a 1.4.1 JVM. However it should also functionwith a 1.4.0 or higher version JVM.");
        }
        if (vers.compareTo("1.4.0") < 0) {
            out.println("JAVA: WARNING: This version of JawBridge will not run witha JVM less that version 1.4.0!!!!\n It was developedfor use with a 1.4.1 JVM. However it should also functionwith a 1.4.0 or higher version JVM!!!");
        }
        new JawBridge();
        out.close();
    }

    public JawBridge() {
        if (EventQueueMonitor.isGUIInitialized()) {
            this.dw = new debugWindow();
            AccessibilityEventMonitor cfr_ignored_0 = this.dw.aem;
            AccessibilityEventMonitor.addPropertyChangeListener(this);
            SwingEventMonitor cfr_ignored_1 = this.dw.sem;
            SwingEventMonitor.addFocusListener(this);
        } else {
            EventQueueMonitor.addGUIInitializedListener(this);
        }
    }

    public void guiInitialized() {
        this.dw = new debugWindow();
        AccessibilityEventMonitor cfr_ignored_0 = this.dw.aem;
        AccessibilityEventMonitor.addPropertyChangeListener(this);
        SwingEventMonitor cfr_ignored_1 = this.dw.sem;
        SwingEventMonitor.addFocusListener(this);
    }

    public void focusGained(FocusEvent e) {
        String tempname;
        out.println("METHOD:    focusGained");
        Object o = e.getSource();
        Container srcParent = ((Component)o).getParent();
        if (srcParent != null && (tempname = srcParent.getClass().getName()).equals("javax.swing.JcolorChooser")) {
            this.parentClass = tempname;
        }
        this.FocusClass = o.getClass().getName();
        if (this.FocusClass.equals("javax.swing.JSlider")) {
            this.SliderInverted = ((JSlider)o).getInverted();
        }
        if (o instanceof Accessible) {
            out.println("focusGained: -->" + o.toString() + " instanceof Accessible");
            AccessibleContext ac = ((Accessible)o).getAccessibleContext();
            AccessibleRole ar = ac.getAccessibleRole();
            if (ar == AccessibleRole.TEXT) {
                out.println("focusGained: --> Role = " + ar.toString());
                Rectangle r = this.getCaretRect(ac);
                out.println("focusGained: --> Rectangle Position x: " + r.x + " Position y: " + r.y);
                this.setCaret(r.x, r.y, r.width, r.height);
            } else if (ar == AccessibleRole.PAGE_TAB_LIST || ar == AccessibleRole.LIST) {
                out.println("focusGained: --> Role = " + ar.toString());
                this.setAccessibleSelectionPosition(ac);
            } else if (ar == AccessibleRole.TABLE) {
                this.setCaret(this.ADRect.x, this.ADRect.y, this.ADRect.width, this.ADRect.height);
            } else if (ar == AccessibleRole.TREE) {
                this.setCaret(this.ADRect.x, this.ADRect.y, this.ADRect.width, this.ADRect.height);
            } else if (ar == AccessibleRole.SLIDER || ar == AccessibleRole.PROGRESS_BAR) {
                this.setAccessibleValuePosition(ac);
            }
        }
    }

    public void focusLost(FocusEvent e) {
    }

    public void setAccessibleValuePosition(AccessibleContext ac) {
        AccessibleComponent acomp;
        Point loc;
        out.println("METHOD:    setAccessibleValuePosition");
        AccessibleRole ar = ac.getAccessibleRole();
        if ((ar == AccessibleRole.PROGRESS_BAR || ar == AccessibleRole.SCROLL_BAR || ar == AccessibleRole.SLIDER) && (loc = (acomp = ac.getAccessibleComponent()).getLocationOnScreen()) != null) {
            Rectangle r = acomp.getBounds();
            Dimension dim = acomp.getSize();
            AccessibleValue temp = ac.getAccessibleValue();
            Number num = temp.getCurrentAccessibleValue();
            Number max = temp.getMaximumAccessibleValue();
            Number min = temp.getMinimumAccessibleValue();
            float vOff = num.floatValue() / (max.floatValue() - min.floatValue());
            if (r.width > r.height) {
                if (this.SliderInverted) {
                    int xoff = (int)(vOff * (float)r.width);
                    r.x = loc.x - (r.width >> 1) - xoff;
                    r.y = loc.y - (r.height >> 1) + 4;
                } else {
                    int xoff = (int)(vOff * (float)r.width);
                    r.x = loc.x - (r.width >> 1) + xoff;
                    r.y = loc.y - (r.height >> 1) + 4;
                }
            } else if (this.SliderInverted) {
                int yoff = (int)(vOff * (float)r.height);
                r.x = loc.x + (r.width >> 1) - 4;
                r.y = loc.y - (r.height >> 1) + yoff;
            } else {
                int yoff = (int)(vOff * (float)r.height);
                r.x = loc.x + (r.width >> 1) - 4;
                r.y = loc.y + (r.height >> 1) - yoff;
            }
            this.setCaret(r.x, r.y, r.width, r.height);
        }
    }

    private void setCaret(int left, int top, int width, int height) {
        this.dw.logToDebugWindow(new Rectangle(left, top, width, height).toString());
        out.println("METHOD:    setCaret");
        out.println("setCaret: --> Setting Caret at: [" + left + ", " + top + ", " + width + ", " + height + "], ");
        Window topWindow = EventQueueMonitor.getTopLevelWindowWithFocus();
        out.println("setCaret: --> Top level Window = " + topWindow.getName());
        long window = this.getNativeWindowHandleFromComponent(topWindow);
        this.setNativeCaretPosition(window, left, top, width, height);
    }

    private void setAccessibleTextProperty(AccessibleContext ac) {
        out.println("METHOD:    setAccessibleTextProperty");
        Rectangle r = this.getCaretRect(ac);
        out.println("setAccessibleTextProperty: --> Rectangle = " + r.toString());
        this.setCaret(r.x, r.y, r.width, r.height);
    }

    private Rectangle getCaretRect(AccessibleContext ac) {
        out.println("METHOD:    getCaretRect");
        AccessibleText at = ac.getAccessibleText();
        int newValue = at.getCaretPosition();
        Point loc = this.getLocation(ac);
        out.println("getCaretRect: --> Position  = " + newValue);
        if (loc != null) {
            out.println("getCaretRect: --> Location  = " + loc.toString());
        } else {
            out.println("getCaretRect: --> Location  = " + loc);
        }
        Rectangle r = at.getCharacterBounds(newValue);
        if (r == null) {
            if (this.txtRect.isEmpty()) {
                this.txtRect.x = 2;
                this.txtRect.y = 2;
                this.txtRect.width = 1;
                this.txtRect.height = 15;
            }
            r = new Rectangle(this.txtRect.x, this.txtRect.y, this.txtRect.width, this.txtRect.height);
        }
        if (loc != null) {
            out.println("getCaretRect: --> Rectangle  = " + r.toString());
            this.txtRect.x = r.x;
            this.txtRect.y = r.y;
            this.txtRect.width = r.width;
            this.txtRect.height = r.height;
            r.x += loc.x;
            r.y += loc.y;
            out.println("getCaretRect: --> Screen Coordinate  = " + r.toString());
            out.println("getCaretRect: --> Temp Screen Coord. Rect.  = " + this.txtRect.toString());
        }
        return r;
    }

    private void setAccessibleCaretProperty(AccessibleContext ac) {
        out.println("METHOD:    setAccessibleCaretProperty");
        Rectangle r = this.getCaretRect(ac);
        out.println("setAccessibleTextProperty: --> Rectangle = " + r.toString());
        this.setCaret(r.x, r.y, r.width, r.height);
    }

    private void setAccessibleStateProperty(AccessibleContext ac, Object o, Object o2) {
        out.println("METHOD:    setAccessibleStateProperty");
        String newValue = null;
        String oldValue = null;
        if (o2 != null && (oldValue = o2.toString()).compareTo(AccessibleState.ARMED.toString()) == 0 && ac == this.armedAC) {
            this.armedAC = null;
        }
        if (o != null) {
            AccessibleComponent acomp;
            out.println("setAccessibleStateProperty: --> Accessible Context= " + ac.toString());
            AccessibleRole ar = ac.getAccessibleRole();
            out.println("setAccessibleStateProperty: --> Role: " + ar.toString());
            newValue = o.toString();
            out.println("setAccessibleStateProperty: --> State event= " + newValue);
            if (newValue.compareTo(AccessibleState.ARMED.toString()) == 0) {
                this.armedAC = ac;
            }
            if (ar == AccessibleRole.PAGE_TAB_LIST || ar == AccessibleRole.PAGE_TAB || ar == AccessibleRole.LIST) {
                this.setAccessibleSelectionPosition(ac);
            } else if ((newValue.compareTo(AccessibleState.ARMED.toString()) == 0 || (this.armedAC == null || this.armedAC == ac) && newValue.compareTo(AccessibleState.FOCUSED.toString()) == 0) && (acomp = ac.getAccessibleComponent()) != null) {
                Point loc = null;
                loc = acomp.isShowing() ? acomp.getLocationOnScreen() : acomp.getLocation();
                Dimension d = acomp.getSize();
                if (loc != null && d != null) {
                    Rectangle r = new Rectangle(loc.x, loc.y, d.width, d.height);
                    out.println("setAccessibleStateProperty: --> Location= " + loc.toString());
                    out.println("setAccessibleStateProperty: --> Dimension= " + d.toString());
                    out.println("setAccessibleStateProperty: --> Rectangle SC= " + r.toString());
                    this.setCaret(loc.x, loc.y, d.width, d.height);
                }
            }
        }
    }

    private void setAccessibleADProperty(Accessible a) {
        out.println("METHOD:    setAccessibleADProperty");
        if (a != null) {
            AccessibleContext ac = a.getAccessibleContext();
            int childcount = ac.getAccessibleChildrenCount();
            AccessibleStateSet stateSet = ac.getAccessibleStateSet();
            out.println("setAccessibleADProperty: --> Role= " + ac.getAccessibleRole().toString());
            out.println("setAccessibleADProperty: --> Children Count= " + childcount);
            for (int i = 0; i < childcount; ++i) {
                Accessible aChild = ac.getAccessibleChild(i);
                AccessibleContext acc = aChild.getAccessibleContext();
                out.println("setAccessibleADProperty: --> Child Role= " + ac.getAccessibleRole().toString());
            }
            out.println("setAccessibleADProperty: --> Accessible Context= " + ac.toString());
            AccessibleComponent acomp = ac.getAccessibleComponent();
            out.println("setAccessibleADProperty : --> Component= " + ac.getAccessibleName());
            if (acomp != null) {
                Point loc = null;
                if (acomp.isShowing()) {
                    loc = acomp.getLocationOnScreen();
                } else {
                    loc = acomp.getLocation();
                    AccessibleComponent p = ac.getAccessibleParent().getAccessibleContext().getAccessibleComponent();
                    Point ploc = p.getLocationOnScreen();
                    if (ploc != null) {
                        loc.x += ploc.x;
                        loc.y += ploc.y;
                    }
                }
                out.println("setAccessibleADProperty : --> Location= " + loc.toString());
                Dimension d = acomp.getSize();
                out.println("setAccessibleADProperty : --> Dimension= " + d.toString());
                this.ADRect.x = loc.x;
                this.ADRect.y = loc.y;
                this.ADRect.width = d.width;
                this.ADRect.height = d.height;
                this.setCaret(loc.x, loc.y, d.width, d.height);
            }
        }
    }

    private void setAccessibleSelectionProperty(AccessibleContext ac) {
        out.println("METHOD:    setAccessibleSelectionProperty");
        if (ac != null) {
            int childrenCount = ac.getAccessibleChildrenCount();
            out.println("setAccessibleSelectionProperty: --> Component Context= " + ac);
            out.println("setAccessibleSelectionProperty: --> Children Count= " + childrenCount);
            if (ac.getAccessibleSelection() != null) {
                this.setAccessibleSelectionPosition(ac);
            }
        }
    }

    private void setAccessibleValueProperty(AccessibleContext ac, Object o) {
        if (ac != null) {
            this.setAccessibleValuePosition(ac);
        }
    }

    private void setAccessibleSelectionPosition(AccessibleContext ac) {
        out.println("METHOD:    setAccessibleSelectionPosition");
        AccessibleSelection as = ac.getAccessibleSelection();
        out.println("setAccessibleSelectionPosition: --> Role= " + ac.getAccessibleRole().toString());
        if (as != null) {
            int selcount = as.getAccessibleSelectionCount();
            int childcount = ac.getAccessibleChildrenCount();
            if (selcount != 0) {
                for (int i = 0; i < childcount; ++i) {
                    if (!as.isAccessibleChildSelected(i)) continue;
                    Accessible aChild = ac.getAccessibleChild(i);
                    AccessibleComponent acomp = aChild.getAccessibleContext().getAccessibleComponent();
                    out.println("setAccessibleSelectionPosition: --> Selection Count= " + selcount);
                    out.println("setAccessibleSelectionPosition: --> Children Count= " + childcount);
                    AccessibleStateSet stateSet = aChild.getAccessibleContext().getAccessibleStateSet();
                    if (stateSet.contains(AccessibleState.FOCUSED)) {
                        // empty if block
                    }
                    if (acomp == null) continue;
                    Point loc = ac.getAccessibleComponent().getLocationOnScreen();
                    Rectangle r = acomp.getBounds();
                    if (loc == null) continue;
                    r.x += loc.x;
                    r.y += loc.y;
                    out.println("setAccessibleSelectionPosition: --> Location= " + loc.toString());
                    out.println("setAccessibleSelectionPosition: --> Rectangle SC= " + r.toString());
                    this.ADRect.x = r.x;
                    this.ADRect.y = r.y;
                    this.ADRect.width = r.width;
                    this.ADRect.height = r.height;
                    this.setCaret(r.x, r.y, r.width, r.height);
                }
            }
        }
    }

    private Point getLocation(AccessibleContext ac) {
        out.println("METHOD:    getLocation");
        Point loc = null;
        AccessibleComponent acomp = ac.getAccessibleComponent();
        out.println("getLocation: --> Component name= " + this.parseStringAt(acomp.toString()));
        loc = acomp.getLocationOnScreen();
        return loc;
    }

    public String getComponentName(Object o) {
        out.println("METHOD:     getComponentName");
        out.println("getComponentName: --> Name = " + o.getClass().getName());
        String str = o.getClass().getName();
        int len = str.length();
        int token = str.indexOf("$");
        String className = str.substring(0, token);
        return className;
    }

    public String parseStringAt(String s) {
        int token = s.indexOf("@");
        String classPath = s.substring(0, token);
        token = classPath.lastIndexOf(".");
        String className = classPath.substring(token + 1);
        return className;
    }

    public String parseStringAngle(String s) {
        int token = s.indexOf("[");
        String classPath = s.substring(0, token);
        token = classPath.lastIndexOf(".");
        String className = classPath.substring(token + 1);
        return className;
    }

    public void propertyChange(PropertyChangeEvent e) {
        Object o = e.getSource();
        String PropertyClass = this.getComponentName(o);
        if (this.parentClass.equals("javax.swing.JColorChooser")) {
            if (PropertyClass.equals(this.FocusClass) && o instanceof AccessibleContext) {
                AccessibleContext ac = (AccessibleContext)o;
                AccessibleRole ar = ac.getAccessibleRole();
                String propertyName = e.getPropertyName();
                if (ar != AccessibleRole.SCROLL_BAR) {
                    if (propertyName.compareTo("AccessibleText") == 0) {
                        this.setAccessibleTextProperty(ac);
                    } else if (propertyName.compareTo("AccessibleCaret") == 0) {
                        this.setAccessibleCaretProperty(ac);
                    } else if (propertyName.compareTo("AccessibleState") == 0) {
                        this.setAccessibleStateProperty(ac, e.getNewValue(), e.getOldValue());
                    } else if (propertyName.compareTo("AccessibleActiveDescendant") == 0) {
                        this.setAccessibleADProperty((Accessible)e.getNewValue());
                    } else if (propertyName.compareTo("AccessibleSelection") == 0) {
                        this.setAccessibleSelectionProperty(ac);
                    } else if (propertyName.compareTo("AccessibleValue") == 0) {
                        this.setAccessibleValueProperty(ac, e.getNewValue());
                    }
                }
            }
        } else if (o instanceof AccessibleContext) {
            AccessibleContext ac = (AccessibleContext)o;
            AccessibleRole ar = ac.getAccessibleRole();
            String propertyName = e.getPropertyName();
            if (ar != AccessibleRole.SCROLL_BAR) {
                if (propertyName.compareTo("AccessibleText") == 0) {
                    this.setAccessibleTextProperty(ac);
                } else if (propertyName.compareTo("AccessibleCaret") == 0) {
                    this.setAccessibleCaretProperty(ac);
                } else if (propertyName.compareTo("AccessibleState") == 0) {
                    this.setAccessibleStateProperty(ac, e.getNewValue(), e.getOldValue());
                } else if (propertyName.compareTo("AccessibleActiveDescendant") == 0) {
                    this.setAccessibleADProperty((Accessible)e.getNewValue());
                } else if (propertyName.compareTo("AccessibleSelection") == 0) {
                    this.setAccessibleSelectionProperty(ac);
                } else if (propertyName.compareTo("AccessibleValue") == 0) {
                    this.setAccessibleValueProperty(ac, e.getNewValue());
                }
            }
        }
    }

    public long getNativeWindowHandleFromComponent(Component target) {
        Window window = null;
        window = target instanceof Window ? (Window)target : SwingUtilities.getWindowAncestor(target);
        if (window != null) {
            return this.getNativeWindowHandleFromWindow(window);
        }
        return -1L;
    }

    public static boolean testJVMforHWNDmapping() {
        block8: {
            out.println("METHOD:    testJVMforHWNDmapping");
            Class[] ComponentParemter = new Class[1];
            try {
                ComponentParemter[0] = Class.forName("java.awt.Component");
            }
            catch (ClassNotFoundException e) {
                out.println("testJVMforHWNDmapping: --> Exception: " + e.toString());
            }
            Object[] args = new Object[]{new JButton()};
            Toolkit tk = Toolkit.getDefaultToolkit();
            try {
                Method getNativeWindowHandleFromComponentMethod = tk.getClass().getMethod("getNativeWindowHandleFromComponent", ComponentParemter);
                if (getNativeWindowHandleFromComponentMethod == null) break block8;
                try {
                    getNativeWindowHandleFromComponentMethod.invoke((Object)tk, args);
                    return true;
                }
                catch (InvocationTargetException e) {
                    out.println("testJVMforHWNDmapping: --> Exception: " + e.toString());
                }
                catch (IllegalAccessException e) {
                    out.println("testJVMforHWNDmapping: --> Exception: " + e.toString());
                }
            }
            catch (NoSuchMethodException e) {
                out.println("testJVMforHWNDmapping: --> Exception: " + e.toString());
            }
            catch (SecurityException e) {
                out.println("testJVMforHWNDmapping: --> Exception: " + e.toString());
            }
        }
        return false;
    }

    public AccessibleContext getAC(Object o) {
        if (o instanceof AccessibleContext) {
            AccessibleContext ac = (AccessibleContext)o;
            return ac;
        }
        out.println("getAC: --> " + o.toString() + " !instanceof Accessible");
        Accessible a = Translator.getAccessible(o);
        AccessibleContext ac = a.getAccessibleContext();
        return ac;
    }

    static {
        System.loadLibrary("JawBridge");
    }
}

