/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import com.ibm.misc.Debug;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.CRLNumberExtension;
import com.ibm.security.x509.OIDMap;
import com.ibm.security.x509.X509CRLImpl;
import java.io.IOException;
import java.math.BigInteger;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.CRLSelector;
import java.security.cert.CertPathHelperInitializer;
import java.security.cert.CertPathValidatorException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import javax.security.auth.x500.X500Principal;

public class X509CRLSelector
implements CRLSelector {
    private static final Debug debug = Debug.getInstance((String)"certpath");
    private Collection<X500Principal> issuerNames;
    private Collection<Object> issuerNamesFromApp;
    private BigInteger minCRLNumber;
    private BigInteger maxCRLNumber;
    private Date dateAndTime;
    private X509Certificate certificate;

    public void setIssuerNames(Collection<?> names) throws IOException {
        if (names != null && names.size() > 0) {
            this.issuerNames = new ArrayList<X500Principal>();
            this.issuerNamesFromApp = new ArrayList<Object>();
            for (Object entry : names) {
                if (entry instanceof byte[]) {
                    this.addIssuerName((byte[])entry);
                    continue;
                }
                if (entry instanceof String) {
                    this.addIssuerName((String)entry);
                    continue;
                }
                throw new IOException("name not byte array or String");
            }
        } else {
            this.issuerNames = null;
            this.issuerNamesFromApp = null;
        }
    }

    public void setIssuers(Collection<X500Principal> issuers) {
        if (issuers == null || issuers.isEmpty()) {
            this.issuerNames = null;
            this.issuerNamesFromApp = null;
        } else {
            this.issuerNames = new ArrayList<X500Principal>(issuers);
            this.issuerNamesFromApp = new ArrayList<X500Principal>(issuers);
        }
    }

    public void addIssuerName(String name) throws IOException {
        X500Principal temp;
        if (name == null) {
            throw new IOException("Name is null");
        }
        if (this.issuerNames == null) {
            this.issuerNames = new ArrayList<X500Principal>();
            this.issuerNamesFromApp = new ArrayList<Object>();
        }
        try {
            temp = new X500Principal(name);
        }
        catch (IllegalArgumentException ex) {
            throw (IOException)new IOException("Invalid name").initCause(ex);
        }
        this.issuerNames.add(temp);
        this.issuerNamesFromApp.add(temp.getName("RFC2253"));
    }

    public void addIssuerName(byte[] name) throws IOException {
        if (name == null) {
            throw new IOException("name is null");
        }
        byte[] temp = (byte[])name.clone();
        if (this.issuerNames == null) {
            this.issuerNames = new ArrayList<X500Principal>();
            this.issuerNamesFromApp = new ArrayList<Object>();
        }
        try {
            this.issuerNames.add(new X500Principal(temp));
        }
        catch (IllegalArgumentException ex) {
            throw (IOException)new IOException("Invalid name").initCause(ex);
        }
        this.issuerNamesFromApp.add(temp);
    }

    public void addIssuer(X500Principal issuer) {
        if (this.issuerNames == null) {
            this.issuerNames = new ArrayList<X500Principal>();
        }
        this.issuerNames.add(issuer);
        if (this.issuerNamesFromApp == null) {
            this.issuerNamesFromApp = new ArrayList<Object>();
        }
        this.issuerNamesFromApp.add(issuer);
    }

    public void setMinCRLNumber(BigInteger minCRL) {
        this.minCRLNumber = minCRL;
    }

    public void setMaxCRLNumber(BigInteger maxCRL) {
        this.maxCRLNumber = maxCRL;
    }

    public void setDateAndTime(Date dateAndTime) {
        this.dateAndTime = dateAndTime != null ? (Date)dateAndTime.clone() : null;
    }

    public void setCertificateChecking(X509Certificate cert) {
        this.certificate = cert;
    }

    public Collection<Object> getIssuerNames() {
        ArrayList<Object> retList = null;
        if (this.issuerNamesFromApp != null) {
            retList = new ArrayList<Object>();
            for (Object o : this.issuerNamesFromApp) {
                if (o instanceof byte[]) {
                    retList.add(((byte[])o).clone());
                    continue;
                }
                if (o instanceof X500Principal) {
                    retList.add((byte[])((X500Principal)o).getEncoded().clone());
                    continue;
                }
                retList.add(o);
            }
        }
        return retList;
    }

    public Collection<X500Principal> getIssuers() {
        if (this.issuerNames != null) {
            return Collections.unmodifiableCollection(this.issuerNames);
        }
        return null;
    }

    public BigInteger getMinCRL() {
        return this.minCRLNumber;
    }

    public BigInteger getMaxCRL() {
        return this.maxCRLNumber;
    }

    public Date getDateAndTime() {
        return this.dateAndTime != null ? (Date)this.dateAndTime.clone() : null;
    }

    public X509Certificate getCertificateChecking() {
        return this.certificate;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("X509CRLSelector: [");
        sb.append("\n    IssuerNames:");
        if (this.issuerNames != null) {
            sb.append(this.dumpIssuerNames(this.issuerNames));
        }
        sb.append("\n    MinCRLNumber:");
        if (this.minCRLNumber != null) {
            sb.append(this.minCRLNumber);
        }
        sb.append("\n    MaxCRLNumber:");
        if (this.maxCRLNumber != null) {
            sb.append(this.maxCRLNumber);
        }
        sb.append("\n    DateAndTime:");
        if (this.dateAndTime != null) {
            sb.append(this.dateAndTime);
        }
        sb.append("\n    Certificate being checked:");
        if (this.certificate != null) {
            sb.append(this.certificate);
        }
        sb.append("\n]");
        return sb.toString();
    }

    private String dumpIssuerNames(Collection issuerNames) {
        StringBuffer sb = new StringBuffer();
        Iterator i = issuerNames.iterator();
        while (i.hasNext()) {
            sb.append("    " + i.next() + "\n");
        }
        return sb.toString();
    }

    @Override
    public boolean match(CRL crl) {
        X509CRLImpl c;
        if (!(crl instanceof X509CRL)) {
            if (debug != null) {
                System.out.println("X509CRLSelector.match: not an X509CRL");
            }
            return false;
        }
        try {
            c = new X509CRLImpl(((X509CRL)crl).getEncoded());
        }
        catch (CRLException cex) {
            if (debug != null) {
                System.out.println("X509CRLSelector.match: exception");
                cex.printStackTrace();
            }
            return false;
        }
        if (this.issuerNames != null) {
            boolean found = false;
            Iterator<X500Principal> i = this.issuerNames.iterator();
            while (i.hasNext()) {
                if (!i.next().equals(c.getIssuerX500Principal())) continue;
                found = true;
                break;
            }
            if (!found) {
                if (debug != null) {
                    System.out.println("X509CRLSelector.match: issuer DNs do not match");
                }
                return false;
            }
        }
        if (this.getMinCRL() != null || this.getMaxCRL() != null) {
            BigInteger bi;
            try {
                Object[] extObj = this.getExtension("x509.info.extensions.CRLNumber", (X509CRL)c);
                CRLNumberExtension ext = new CRLNumberExtension((Boolean)extObj[0], extObj[1]);
                bi = (BigInteger)ext.get("value");
            }
            catch (CertPathValidatorException e) {
                if (debug != null) {
                    System.out.println("X509CRLSelector.match: exception");
                    e.printStackTrace();
                }
                return false;
            }
            catch (IOException e) {
                if (debug != null) {
                    System.out.println("X509CRLSelector.match: exception");
                    e.printStackTrace();
                }
                return false;
            }
            catch (NullPointerException e) {
                if (debug != null) {
                    System.out.println("X509CRLSelector.match: no CRLNumber");
                    e.printStackTrace();
                }
                return false;
            }
            if (this.getMinCRL() != null && bi.compareTo(this.getMinCRL()) < 0) {
                if (debug != null) {
                    System.out.println("X509CRLSelector.match: CRLNumber too small");
                }
                return false;
            }
            if (this.getMaxCRL() != null && bi.compareTo(this.getMaxCRL()) > 0) {
                if (debug != null) {
                    System.out.println("X509CRLSelector.match: CRLNumber too large");
                }
                return false;
            }
        }
        if (this.getDateAndTime() != null) {
            Date nextUpdate = c.getNextUpdate();
            if (nextUpdate == null) {
                if (debug != null) {
                    System.out.println("X509CRLSelector.match: nextUpdate null");
                }
                return false;
            }
            if (this.getDateAndTime().before(c.getThisUpdate()) || !this.getDateAndTime().before(c.getNextUpdate())) {
                if (debug != null) {
                    System.out.println("X509CRLSelector.match: update out of range");
                }
                return false;
            }
        }
        return true;
    }

    private Object[] getExtension(String ident, X509CRL crl) throws CertPathValidatorException {
        boolean crit = false;
        String oid = OIDMap.getOID((String)ident).toString();
        byte[] extBytes = crl.getExtensionValue(oid);
        if (extBytes != null) {
            crit = crl.getCriticalExtensionOIDs().contains(oid);
            try {
                extBytes = new DerValue(extBytes).getOctetString();
            }
            catch (IOException e) {
                throw new CertPathValidatorException("an internal error has occurred", e);
            }
        }
        Object[] retVal = new Object[]{new Boolean(crit), extBytes};
        return retVal;
    }

    @Override
    public Object clone() {
        try {
            Object copy = super.clone();
            if (this.issuerNames != null) {
                this.issuerNames = new ArrayList<X500Principal>(this.issuerNames);
                this.issuerNamesFromApp = new ArrayList<Object>(this.issuerNamesFromApp);
            }
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.toString());
        }
    }

    static {
        if (!CertPathHelperInitializer.isInitialized()) {
            CertPathHelperInitializer.init();
        }
    }
}

