/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import com.ibm.misc.Debug;
import com.ibm.security.x509.NameConstraintsExtension;
import java.io.IOException;
import java.security.PublicKey;
import java.security.cert.CertPathHelperInitializer;
import java.security.cert.X509Certificate;
import javax.security.auth.x500.X500Principal;

public class TrustAnchor {
    private static final Debug debug = Debug.getInstance((String)"certpath");
    private byte[] nameConstraints;
    private final X509Certificate trustedCert;
    private final String caName;
    private final X500Principal caPrincipal;
    private final PublicKey pubKey;

    public TrustAnchor(X509Certificate trustedCert, byte[] nameConstraints) {
        if (trustedCert == null) {
            throw new NullPointerException("the trustedCert parameter must be non-null");
        }
        this.setNameConstraints(nameConstraints);
        this.trustedCert = trustedCert;
        this.caName = null;
        this.caPrincipal = null;
        this.pubKey = null;
    }

    public TrustAnchor(X500Principal caPrincipal, PublicKey pubKey, byte[] nameConstraints) {
        if (caPrincipal == null || pubKey == null) {
            throw new NullPointerException();
        }
        this.trustedCert = null;
        this.caPrincipal = caPrincipal;
        this.caName = caPrincipal.getName();
        this.pubKey = pubKey;
        this.setNameConstraints(nameConstraints);
    }

    public TrustAnchor(String caName, PublicKey pubKey, byte[] nameConstraints) {
        if (caName == null) {
            throw new NullPointerException("the caName parameter must be non-null");
        }
        if (pubKey == null) {
            throw new NullPointerException("the pubKey parameter must be non-null");
        }
        if (caName.length() == 0) {
            throw new IllegalArgumentException("the caName parameter must be a non-empty String");
        }
        this.caPrincipal = new X500Principal(caName);
        this.caName = this.caPrincipal.getName("RFC2253");
        this.pubKey = pubKey;
        this.trustedCert = null;
        this.setNameConstraints(nameConstraints);
    }

    public final X509Certificate getTrustedCert() {
        return this.trustedCert;
    }

    public final X500Principal getCA() {
        return this.caPrincipal;
    }

    public final String getCAName() {
        return this.caName;
    }

    public final PublicKey getCAPublicKey() {
        return this.pubKey;
    }

    public final byte[] getNameConstraints() {
        if (this.nameConstraints != null) {
            return (byte[])this.nameConstraints.clone();
        }
        return null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("TrustAnchor: \n");
        if (this.trustedCert != null) {
            sb.append("\tTrusted certificate: " + this.trustedCert.toString());
        } else {
            sb.append("\tTrusted ca: " + this.caName);
            sb.append("\tTrusted ca public key: " + this.pubKey.toString());
        }
        if (this.nameConstraints != null) {
            try {
                NameConstraintsExtension ext = new NameConstraintsExtension(Boolean.TRUE, (Object)this.nameConstraints);
                sb.append("\t" + ext.toString());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return sb.toString();
    }

    private void setNameConstraints(byte[] nameConstraints) throws IllegalArgumentException {
        if (nameConstraints != null) {
            this.nameConstraints = (byte[])nameConstraints.clone();
            try {
                NameConstraintsExtension ext = new NameConstraintsExtension(Boolean.TRUE, (Object)this.nameConstraints);
            }
            catch (IOException e) {
                IllegalArgumentException iae = new IllegalArgumentException(e.getMessage());
                iae.initCause(e);
                throw iae;
            }
        } else {
            this.nameConstraints = null;
        }
    }

    static {
        if (!CertPathHelperInitializer.isInitialized()) {
            CertPathHelperInitializer.init();
        }
    }
}

