/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import java.security.PublicKey;
import java.security.cert.CertPathValidatorResult;
import java.security.cert.PolicyNode;
import java.security.cert.TrustAnchor;

public class PKIXCertPathValidatorResult
implements CertPathValidatorResult {
    private TrustAnchor trustAnchor;
    private PolicyNode policyTree;
    private PublicKey subjectPubKey;

    public PKIXCertPathValidatorResult(TrustAnchor trustAnchor, PolicyNode policyTree, PublicKey subjectPublicKey) {
        if (subjectPublicKey == null) {
            throw new NullPointerException("subject public key must not be null");
        }
        if (trustAnchor == null) {
            throw new NullPointerException("trustAnchor must not be null");
        }
        this.trustAnchor = trustAnchor;
        this.policyTree = policyTree;
        this.subjectPubKey = subjectPublicKey;
    }

    public TrustAnchor getTrustAnchor() {
        return this.trustAnchor;
    }

    public PolicyNode getPolicyTree() {
        return this.policyTree;
    }

    public PublicKey getPublicKey() {
        return this.subjectPubKey;
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.toString());
        }
    }

    public String toString() {
        return "PKIXCertPathValidatorResult:[\nTrust Anchor\t" + this.trustAnchor + "\n" + "Policy Tree\t" + this.policyTree + "\n" + "Subject Public Key\t" + this.subjectPubKey + "\n]";
    }
}

