/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.security.GeneralSecurityException;
import java.security.cert.CertPath;

public class CertPathValidatorException
extends GeneralSecurityException {
    static final long serialVersionUID = -2365020986539324560L;
    private int index = -1;
    private CertPath certPath;
    private Throwable ie;

    public CertPathValidatorException() {
    }

    public CertPathValidatorException(String msg) {
        super(msg);
    }

    public CertPathValidatorException(Throwable cause) {
        super(cause);
    }

    public CertPathValidatorException(String msg, Throwable cause) {
        super(msg, cause);
    }

    public CertPathValidatorException(String msg, Throwable cause, CertPath certPath, int index) {
        this(msg, cause);
        if (index < -1 || certPath != null && index >= certPath.getCertificates().size()) {
            throw new IndexOutOfBoundsException("Index of the certificate in specified CertPath is out of bound");
        }
        if (certPath == null && index != -1) {
            throw new IllegalArgumentException();
        }
        this.certPath = certPath;
        this.index = index;
    }

    @Override
    public String getMessage() {
        return super.getMessage();
    }

    public CertPath getCertPath() {
        return this.certPath;
    }

    public int getIndex() {
        return this.index;
    }

    @Override
    public Throwable getCause() {
        return super.getCause();
    }

    @Override
    public String toString() {
        if (this.getCause() == null) {
            return super.toString();
        }
        return super.toString() + "; internal cause is: \n\t" + this.getCause().toString();
    }

    @Override
    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    @Override
    public void printStackTrace(PrintStream ps) {
        super.printStackTrace(ps);
    }

    @Override
    public void printStackTrace(PrintWriter pw) {
        super.printStackTrace(pw);
    }
}

