/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.security.provider.crypto;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.SecureRandomSpi;
import org.apache.harmony.security.internal.nls.Messages;
import org.apache.harmony.security.provider.crypto.RandomBitsSupplier;
import org.apache.harmony.security.provider.crypto.SHA1Impl;
import org.apache.harmony.security.provider.crypto.SHA1_Data;

public class SHA1PRNG_SecureRandomImpl
extends SecureRandomSpi
implements Serializable,
SHA1_Data {
    private static final long serialVersionUID = 283736797212159675L;
    private static final int[] END_FLAGS = new int[]{Integer.MIN_VALUE, 0x800000, 32768, 128};
    private static final int[] RIGHT1 = new int[]{0, 40, 48, 56};
    private static final int[] RIGHT2 = new int[]{0, 8, 16, 24};
    private static final int[] LEFT = new int[]{0, 24, 16, 8};
    private static final int[] MASK = new int[]{-1, 0xFFFFFF, 65535, 255};
    private static final int HASHBYTES_TO_USE = 20;
    private static final int FRAME_LENGTH = 16;
    private static final int COUNTER_BASE = 0;
    private static final int HASHCOPY_OFFSET = 0;
    private static final int EXTRAFRAME_OFFSET = 5;
    private static final int FRAME_OFFSET = 21;
    private static final int MAX_BYTES = 48;
    private static final int UNDEFINED = 0;
    private static final int SET_SEED = 1;
    private static final int NEXT_BYTES = 2;
    private static SHA1PRNG_SecureRandomImpl myRandom;
    private transient int[] seed = new int[87];
    private transient long seedLength;
    private transient int[] copies;
    private transient byte[] nextBytes;
    private transient int nextBIndex;
    private transient long counter;
    private transient int state;

    public SHA1PRNG_SecureRandomImpl() {
        this.seed[82] = 1732584193;
        this.seed[83] = -271733879;
        this.seed[84] = -1732584194;
        this.seed[85] = 271733878;
        this.seed[86] = -1009589776;
        this.seedLength = 0L;
        this.copies = new int[37];
        this.nextBytes = new byte[20];
        this.nextBIndex = 20;
        this.counter = 0L;
        this.state = 0;
    }

    private void updateSeed(byte[] byArray) {
        SHA1Impl.updateHash(this.seed, byArray, 0, byArray.length - 1);
        this.seedLength += (long)byArray.length;
    }

    @Override
    protected void engineSetSeed(byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException(Messages.getString("security.83", "seed"));
        }
        if (this.state == 2) {
            System.arraycopy(this.copies, 0, this.seed, 82, 5);
        }
        this.state = 1;
        if (byArray.length != 0) {
            this.updateSeed(byArray);
        }
    }

    @Override
    protected byte[] engineGenerateSeed(int n) {
        if (n < 0) {
            throw new NegativeArraySizeException(Messages.getString("security.171", n));
        }
        if (n == 0) {
            return new byte[0];
        }
        if (myRandom == null) {
            myRandom = new SHA1PRNG_SecureRandomImpl();
            myRandom.engineSetSeed(RandomBitsSupplier.getRandomBits(20));
        }
        byte[] byArray = new byte[n];
        myRandom.engineNextBytes(byArray);
        return byArray;
    }

    @Override
    protected void engineNextBytes(byte[] byArray) {
        int n;
        int n2;
        int n3;
        if (byArray == null) {
            throw new NullPointerException(Messages.getString("security.83", "bytes"));
        }
        int n4 = n3 = this.seed[81] == 0 ? 0 : this.seed[81] + 7 >> 2;
        if (this.state == 0) {
            this.updateSeed(RandomBitsSupplier.getRandomBits(20));
            this.nextBIndex = 20;
        } else if (this.state == 1) {
            System.arraycopy(this.seed, 82, this.copies, 0, 5);
            for (n2 = n3 + 3; n2 < 18; ++n2) {
                this.seed[n2] = 0;
            }
            long l = this.seedLength << 67;
            if (this.seed[81] < 48) {
                this.seed[14] = (int)(l >>> 32);
                this.seed[15] = (int)(l & 0xFFFFFFFFFFFFFFFFL);
            } else {
                this.copies[19] = (int)(l >>> 32);
                this.copies[20] = (int)(l & 0xFFFFFFFFFFFFFFFFL);
            }
            this.nextBIndex = 20;
        }
        this.state = 2;
        if (byArray.length == 0) {
            return;
        }
        int n5 = 0;
        int n6 = n = 20 - this.nextBIndex < byArray.length - n5 ? 20 - this.nextBIndex : byArray.length - n5;
        if (n > 0) {
            System.arraycopy(this.nextBytes, this.nextBIndex, byArray, n5, n);
            this.nextBIndex += n;
            n5 += n;
        }
        if (n5 >= byArray.length) {
            return;
        }
        n = this.seed[81] & 3;
        do {
            if (n == 0) {
                this.seed[n3] = (int)(this.counter >>> 32);
                this.seed[n3 + 1] = (int)(this.counter & 0xFFFFFFFFFFFFFFFFL);
                this.seed[n3 + 2] = END_FLAGS[0];
            } else {
                int n7 = n3;
                this.seed[n7] = this.seed[n7] | (int)(this.counter >>> RIGHT1[n] & (long)MASK[n]);
                this.seed[n3 + 1] = (int)(this.counter >>> RIGHT2[n] & 0xFFFFFFFFFFFFFFFFL);
                this.seed[n3 + 2] = (int)(this.counter << LEFT[n] | (long)END_FLAGS[n]);
            }
            if (this.seed[81] > 48) {
                this.copies[5] = this.seed[16];
                this.copies[6] = this.seed[17];
            }
            SHA1Impl.computeHash(this.seed);
            if (this.seed[81] > 48) {
                System.arraycopy(this.seed, 0, this.copies, 21, 16);
                System.arraycopy(this.copies, 5, this.seed, 0, 16);
                SHA1Impl.computeHash(this.seed);
                System.arraycopy(this.copies, 21, this.seed, 0, 16);
            }
            ++this.counter;
            int n8 = 0;
            for (n2 = 0; n2 < 5; ++n2) {
                int n9 = this.seed[82 + n2];
                this.nextBytes[n8] = (byte)(n9 >>> 24);
                this.nextBytes[n8 + 1] = (byte)(n9 >>> 16);
                this.nextBytes[n8 + 2] = (byte)(n9 >>> 8);
                this.nextBytes[n8 + 3] = (byte)n9;
                n8 += 4;
            }
            this.nextBIndex = 0;
            int n10 = n8 = 20 < byArray.length - n5 ? 20 : byArray.length - n5;
            if (n8 <= 0) continue;
            System.arraycopy(this.nextBytes, 0, byArray, n5, n8);
            n5 += n8;
            this.nextBIndex += n8;
        } while (n5 < byArray.length);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        int n;
        int[] nArray = null;
        objectOutputStream.writeLong(this.seedLength);
        objectOutputStream.writeLong(this.counter);
        objectOutputStream.writeInt(this.state);
        objectOutputStream.writeInt(this.seed[81]);
        int n2 = this.seed[81] + 3 >> 2;
        if (this.state != 2) {
            nArray = new int[5 + n2];
            System.arraycopy(this.seed, 0, nArray, 0, n2);
            System.arraycopy(this.seed, 82, nArray, n2, 5);
        } else {
            n = 0;
            if (this.seed[81] < 48) {
                nArray = new int[26 + n2];
            } else {
                nArray = new int[42 + n2];
                nArray[n] = this.seed[16];
                nArray[n + 1] = this.seed[17];
                nArray[n + 2] = this.seed[30];
                nArray[n + 3] = this.seed[31];
                n += 4;
            }
            System.arraycopy(this.seed, 0, nArray, n, 16);
            System.arraycopy(this.copies, 21, nArray, n += 16, n2);
            System.arraycopy(this.copies, 0, nArray, n += n2, 5);
            System.arraycopy(this.seed, 82, nArray, n += 5, 5);
        }
        for (n = 0; n < nArray.length; ++n) {
            objectOutputStream.writeInt(nArray[n]);
        }
        objectOutputStream.writeInt(this.nextBIndex);
        objectOutputStream.write(this.nextBytes, this.nextBIndex, 20 - this.nextBIndex);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.seed = new int[87];
        this.copies = new int[37];
        this.nextBytes = new byte[20];
        this.seedLength = objectInputStream.readLong();
        this.counter = objectInputStream.readLong();
        this.state = objectInputStream.readInt();
        this.seed[81] = objectInputStream.readInt();
        int n = this.seed[81] + 3 >> 2;
        if (this.state != 2) {
            int n2;
            for (n2 = 0; n2 < n; ++n2) {
                this.seed[n2] = objectInputStream.readInt();
            }
            for (n2 = 0; n2 < 5; ++n2) {
                this.seed[82 + n2] = objectInputStream.readInt();
            }
        } else {
            int n3;
            if (this.seed[81] >= 48) {
                this.seed[16] = objectInputStream.readInt();
                this.seed[17] = objectInputStream.readInt();
                this.seed[30] = objectInputStream.readInt();
                this.seed[31] = objectInputStream.readInt();
            }
            for (n3 = 0; n3 < 16; ++n3) {
                this.seed[n3] = objectInputStream.readInt();
            }
            for (n3 = 0; n3 < n; ++n3) {
                this.copies[21 + n3] = objectInputStream.readInt();
            }
            for (n3 = 0; n3 < 5; ++n3) {
                this.copies[n3] = objectInputStream.readInt();
            }
            for (n3 = 0; n3 < 5; ++n3) {
                this.seed[82 + n3] = objectInputStream.readInt();
            }
        }
        this.nextBIndex = objectInputStream.readInt();
        objectInputStream.read(this.nextBytes, this.nextBIndex, 20 - this.nextBIndex);
    }
}

