/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.security.provider.crypto;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProviderException;
import org.apache.harmony.security.internal.nls.Messages;
import org.apache.harmony.security.provider.crypto.SHA1_Data;

public class RandomBitsSupplier
implements SHA1_Data {
    private static BufferedInputStream bis = null;
    private static File randomFile = null;
    private static boolean serviceAvailable;

    static boolean isServiceAvailable() {
        return serviceAvailable;
    }

    private static synchronized byte[] getLinuxRandomBits(int n) {
        byte[] byArray = new byte[n];
        int n2 = 0;
        int n3 = 0;
        try {
            int n4;
            do {
                if ((n4 = bis.read(byArray, n3, n - n2)) == -1) {
                    throw new ProviderException(Messages.getString("security.193"));
                }
                n3 += n4;
            } while ((n2 += n4) < n);
        }
        catch (IOException iOException) {
            throw new ProviderException(Messages.getString("security.194"), iOException);
        }
        return byArray;
    }

    public static byte[] getRandomBits(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException(Messages.getString("security.195", n));
        }
        if (!serviceAvailable) {
            throw new ProviderException(Messages.getString("security.196"));
        }
        return RandomBitsSupplier.getLinuxRandomBits(n);
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                for (int i = 0; i < SHA1_Data.DEVICE_NAMES.length; ++i) {
                    File file = new File(SHA1_Data.DEVICE_NAMES[i]);
                    try {
                        if (!file.canRead()) continue;
                        bis = new BufferedInputStream(new FileInputStream(file));
                        randomFile = file;
                        return null;
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        // empty catch block
                    }
                }
                return null;
            }
        });
        serviceAvailable = bis != null;
    }
}

