/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.security.fortress;

import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.harmony.security.fortress.BootstrapHelper;
import org.apache.harmony.security.fortress.Engine;

public class Services {
    private static Provider bootstrapProvider = BootstrapHelper.getBootstrapProvider();
    private static final String IBMJCEFIPS = "com.ibm.crypto.fips.provider.IBMJCEFIPS";
    private static final String IBMJSSEFIPS = "com.ibm.fips.jsse.IBMJSSEFIPSProvider";

    private static boolean isFIPS(String string) {
        return IBMJCEFIPS.equals(string) || IBMJSSEFIPS.equals(string);
    }

    public static void init() {
    }

    public static Provider[] getProviders() {
        List list = NormalServices.providers;
        if (BootstrapHelper.isInJarVerify()) {
            return new Provider[]{bootstrapProvider};
        }
        if (BootstrapHelper.isInFIPSLoading()) {
            Provider[] providerArray = new Provider[list.size() + 1];
            providerArray[0] = bootstrapProvider;
            for (int i = 1; i < providerArray.length; ++i) {
                providerArray[i] = (Provider)list.get(i - 1);
            }
            return providerArray;
        }
        return list.toArray(new Provider[list.size()]);
    }

    public static List<Provider> getProvidersList() {
        List list = NormalServices.providers;
        if (BootstrapHelper.isInJarVerify()) {
            ArrayList<Provider> arrayList = new ArrayList<Provider>();
            arrayList.add(bootstrapProvider);
            return arrayList;
        }
        if (BootstrapHelper.isInFIPSLoading()) {
            ArrayList<Provider> arrayList = new ArrayList<Provider>(list.size() + 1);
            arrayList.add(bootstrapProvider);
            arrayList.addAll(list);
            return arrayList;
        }
        return new ArrayList<Provider>(list);
    }

    public static Provider getProvider(String string) {
        if (string == null) {
            return null;
        }
        return (Provider)NormalServices.providersNames.get(string);
    }

    public static int insertProviderAt(Provider provider, int n) {
        int n2 = NormalServices.providers.size();
        if (n < 1 || n > n2) {
            n = n2 + 1;
        }
        ArrayList<Provider> arrayList = new ArrayList<Provider>(NormalServices.providers);
        HashMap<String, Provider> hashMap = new HashMap<String, Provider>(NormalServices.providersNames);
        arrayList.add(n - 1, provider);
        hashMap.put(provider.getName(), provider);
        NormalServices.providers = arrayList;
        NormalServices.providersNames = hashMap;
        Services.setNeedRefresh();
        return n;
    }

    public static void removeProvider(int n) {
        ArrayList arrayList = new ArrayList(NormalServices.providers);
        HashMap hashMap = new HashMap(NormalServices.providersNames);
        Provider provider = (Provider)arrayList.remove(n - 1);
        hashMap.remove(provider.getName());
        NormalServices.providers = arrayList;
        NormalServices.providersNames = hashMap;
        Services.setNeedRefresh();
    }

    public static void initServiceInfo(Provider provider) {
        StringBuffer stringBuffer = new StringBuffer(128);
        for (Provider.Service service : provider.getServices()) {
            String string = service.getType();
            stringBuffer.delete(0, stringBuffer.length());
            String string2 = stringBuffer.append(string).append(".").append(service.getAlgorithm().toUpperCase(Locale.US)).toString();
            if (!NormalServices.services.containsKey(string2)) {
                NormalServices.services.put(string2, service);
            } else {
                int n = 1;
                while (NormalServices.services.containsKey(string2 + "." + n)) {
                    ++n;
                }
                NormalServices.services.put(string2 + "." + n, service);
            }
            Iterator<String> iterator = Engine.door.getAliases(service);
            while (iterator.hasNext()) {
                String string3 = iterator.next();
                stringBuffer.delete(0, stringBuffer.length());
                string2 = stringBuffer.append(string).append(".").append(string3.toUpperCase(Locale.US)).toString();
                if (!NormalServices.services.containsKey(string2)) {
                    NormalServices.services.put(string2, service);
                    continue;
                }
                int n = 1;
                while (NormalServices.services.containsKey(string2 + "." + n)) {
                    ++n;
                }
                NormalServices.services.put(string2 + "." + n, service);
            }
        }
    }

    public static synchronized void updateServiceInfo() {
        NormalServices.services.clear();
        List list = NormalServices.providers;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Services.initServiceInfo((Provider)iterator.next());
        }
        NormalServices.needRefresh = false;
    }

    public static boolean isEmpty() {
        return NormalServices.services.isEmpty();
    }

    public static Provider.Service getService(String string) {
        return (Provider.Service)NormalServices.services.get(string);
    }

    public static void printServices() {
        Services.refresh();
        Set set = NormalServices.services.keySet();
        for (String string : set) {
            System.out.println(string + "=" + NormalServices.services.get(string));
        }
    }

    public static void setNeedRefresh() {
        NormalServices.needRefresh = true;
    }

    public static void refresh() {
        if (NormalServices.needRefresh) {
            NormalServices.refreshNumber++;
            Services.updateServiceInfo();
        }
    }

    static int getRefreshNumber() {
        return NormalServices.refreshNumber;
    }

    private static Provider newInstance(String string, ClassLoader classLoader) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        String string2;
        String string3;
        int n = string.indexOf(32);
        if (n == -1) {
            string3 = string;
            string2 = "";
        } else {
            string3 = string.substring(0, n);
            string2 = string.substring(n, string.length()).trim();
        }
        Class<?> clazz = Class.forName(string3, true, classLoader);
        if (string2.length() > 0) {
            try {
                Class[] classArray = new Class[]{String.class};
                Constructor<?> constructor = clazz.getConstructor(classArray);
                return (Provider)constructor.newInstance(string2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return (Provider)clazz.newInstance();
    }

    private static class NormalServices {
        private static final Map<String, Provider.Service> services = new HashMap<String, Provider.Service>(512);
        private static boolean needRefresh;
        private static int refreshNumber;
        private static List<Provider> providers;
        private static Map<String, Provider> providersNames;

        private NormalServices() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private static void loadProviders() {
            String string = null;
            int n = 1;
            ClassLoader classLoader = ClassLoader.getSystemClassLoader();
            if (classLoader == null) {
                classLoader = com.ibm.jvm.ClassLoader.getLastClassLoader();
            }
            while (true) {
                if ((string = Security.getProperty("security.provider." + n++)) == null) {
                    Engine.door.renumProviders();
                    return;
                }
                boolean bl = Services.isFIPS(string);
                if (bl) {
                    BootstrapHelper.beginFIPSLoading();
                }
                try {
                    Provider provider = Services.newInstance(string.trim(), classLoader);
                    providers.add(provider);
                    providersNames.put(provider.getName(), provider);
                    Services.initServiceInfo(provider);
                    continue;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    continue;
                }
                catch (IllegalAccessException illegalAccessException) {
                    continue;
                }
                catch (InstantiationException instantiationException) {
                    continue;
                }
                finally {
                    if (!bl) continue;
                    BootstrapHelper.endFIPSLoading();
                    continue;
                }
                break;
            }
        }

        static {
            refreshNumber = 1;
            providers = new ArrayList<Provider>(20);
            providersNames = new HashMap<String, Provider>(20);
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    NormalServices.loadProviders();
                    return null;
                }
            });
        }
    }
}

