/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.security.fortress;

import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.util.Locale;
import org.apache.harmony.security.SecurityUtils;
import org.apache.harmony.security.fortress.BootstrapHelper;
import org.apache.harmony.security.fortress.SecurityAccess;
import org.apache.harmony.security.fortress.Services;
import org.apache.harmony.security.internal.nls.Messages;

public class Engine {
    private String serviceName;
    private Provider.Service returnedService;
    private String lastAlgorithm;
    private int refreshNumber;
    public Provider provider;
    public Object spi;
    public static SecurityAccess door;

    public Engine(String string) {
        this.serviceName = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceResult getInstance(String string, Object object) throws NoSuchAlgorithmException {
        if (BootstrapHelper.isInJarVerify()) {
            return this.getInstance(string, BootstrapHelper.getBootstrapProvider(), object);
        }
        if (BootstrapHelper.isInFIPSLoading()) {
            try {
                return this.getInstance(string, BootstrapHelper.getBootstrapProvider(), object);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (string == null) {
            throw new NoSuchAlgorithmException(Messages.getString("security.149"));
        }
        Engine engine = this;
        synchronized (engine) {
            Provider.Service service;
            Services.refresh();
            if (this.returnedService != null && SecurityUtils.equalsIgnoreCase(string, this.lastAlgorithm) && this.refreshNumber == Services.getRefreshNumber()) {
                service = this.returnedService;
            } else {
                if (Services.isEmpty()) {
                    throw new NoSuchAlgorithmException(Messages.getString("security.14A", this.serviceName, string));
                }
                service = Services.getService(new StringBuffer(128).append(this.serviceName).append(".").append(string.toUpperCase(Locale.US)).toString());
                if (service == null) {
                    throw new NoSuchAlgorithmException(Messages.getString("security.14A", this.serviceName, string));
                }
                this.returnedService = service;
                this.lastAlgorithm = string;
                this.refreshNumber = Services.getRefreshNumber();
            }
            this.spi = service.newInstance(object);
            this.provider = service.getProvider();
            return new ServiceResult(this.spi, this.provider, service);
        }
    }

    public ServiceResult getInstance(String string, Provider provider, Object object) throws NoSuchAlgorithmException {
        Provider.Service service = null;
        if (string == null) {
            throw new NoSuchAlgorithmException(Messages.getString("security.14B", this.serviceName));
        }
        service = provider.getService(this.serviceName, string);
        if (service == null) {
            throw new NoSuchAlgorithmException(Messages.getString("security.14A", this.serviceName, string));
        }
        return new ServiceResult(service.newInstance(object), provider, service);
    }

    public static class ServiceResult {
        public Object spi;
        public Provider provider;
        public Provider.Service service;

        public ServiceResult(Object object, Provider provider, Provider.Service service) {
            this.spi = object;
            this.provider = provider;
            this.service = service;
        }
    }
}

