/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.security.fortress;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Permission;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.UnresolvedPermission;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.HashSet;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.harmony.security.DefaultPolicyScanner;
import org.apache.harmony.security.PolicyEntry;
import org.apache.harmony.security.SecurityUtils;
import org.apache.harmony.security.UnresolvedPrincipal;
import org.apache.harmony.security.fortress.PolicyUtils;
import org.apache.harmony.security.internal.nls.Messages;

public class DefaultPolicyParser {
    private final DefaultPolicyScanner scanner;
    private static final String NONE_KEY_STORE = "NONE";

    public DefaultPolicyParser() {
        this.scanner = new DefaultPolicyScanner();
    }

    public DefaultPolicyParser(DefaultPolicyScanner defaultPolicyScanner) {
        this.scanner = defaultPolicyScanner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<PolicyEntry> parse(URL uRL, Properties properties) throws Exception {
        boolean bl = PolicyUtils.canExpandProperties();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(AccessController.doPrivileged(new PolicyUtils.URLLoader(uRL)), this.detectEncoding(uRL)));
        HashSet<DefaultPolicyScanner.GrantEntry> hashSet = new HashSet<DefaultPolicyScanner.GrantEntry>();
        DefaultPolicyScanner.KeystoreEntry[] keystoreEntryArray = new DefaultPolicyScanner.KeystoreEntry[1];
        try {
            this.scanner.scanStream(bufferedReader, hashSet, keystoreEntryArray);
        }
        finally {
            ((Reader)bufferedReader).close();
        }
        KeyStore keyStore = this.initKeyStore(keystoreEntryArray[0], uRL, properties, bl);
        HashSet<PolicyEntry> hashSet2 = new HashSet<PolicyEntry>();
        for (DefaultPolicyScanner.GrantEntry grantEntry : hashSet) {
            try {
                PolicyEntry policyEntry = this.resolveGrant(grantEntry, keyStore, properties, bl);
                if (policyEntry.isVoid()) continue;
                hashSet2.add(policyEntry);
            }
            catch (Exception exception) {}
        }
        return hashSet2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String detectEncoding(URL uRL) throws Exception {
        InputStream inputStream = AccessController.doPrivileged(new PolicyUtils.URLLoader(uRL));
        try {
            byte by;
            while ((by = (byte)inputStream.read()) != -1) {
                if (by == 35 || by == 10 || by == 61) {
                    String string = "ASCII";
                    return string;
                }
                if (by != 21) continue;
                String string = "cp037";
                return string;
            }
        }
        finally {
            inputStream.close();
        }
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("file.encoding");
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    protected PolicyEntry resolveGrant(DefaultPolicyScanner.GrantEntry grantEntry, KeyStore keyStore, Properties properties, boolean bl) throws Exception {
        Object object;
        String object22;
        URL uRL = null;
        Certificate[] certificateArray = null;
        HashSet<Principal> hashSet = new HashSet<Principal>();
        HashSet<Permission> hashSet2 = new HashSet<Permission>();
        if (grantEntry.codebase != null && "file".equals((uRL = new URL(bl ? PolicyUtils.expandURL(grantEntry.codebase, properties) : grantEntry.codebase)).getProtocol()) && (object22 = DefaultPolicyParser.getCannonicalPath((File)(object = new File(uRL.getFile())))) != null) {
            if (object22.startsWith("/")) {
                uRL = new URL("file://" + DefaultPolicyParser.formalizePath(object22));
            } else {
                void var10_12;
                char c;
                int n = 1;
                if (object22.length() > n && object22.charAt(n) == ':' && (c = object22.charAt(0)) >= 'a' && c <= 'z') {
                    c = Character.toUpperCase(c);
                    String string = Character.toString(c) + object22.substring(n, object22.length());
                }
                uRL = new URL("file:/" + DefaultPolicyParser.formalizePath((String)var10_12));
            }
        }
        if (grantEntry.signers != null) {
            if (bl) {
                grantEntry.signers = PolicyUtils.expand(grantEntry.signers, properties);
            }
            certificateArray = this.resolveSigners(keyStore, grantEntry.signers);
        }
        if (grantEntry.principals != null) {
            for (DefaultPolicyScanner.PrincipalEntry principalEntry : grantEntry.principals) {
                if (bl) {
                    principalEntry.name = PolicyUtils.expand(principalEntry.name, properties);
                }
                if (principalEntry.klass == null) {
                    hashSet.add(this.getPrincipalByAlias(keyStore, principalEntry.name));
                    continue;
                }
                hashSet.add(new UnresolvedPrincipal(principalEntry.klass, principalEntry.name));
            }
        }
        if (grantEntry.permissions != null) {
            for (DefaultPolicyScanner.PermissionEntry permissionEntry : grantEntry.permissions) {
                try {
                    hashSet2.add(this.resolvePermission(permissionEntry, grantEntry, keyStore, properties, bl));
                }
                catch (Exception exception) {}
            }
        }
        return new PolicyEntry(new CodeSource(uRL, certificateArray), hashSet, hashSet2);
    }

    protected Permission resolvePermission(DefaultPolicyScanner.PermissionEntry permissionEntry, DefaultPolicyScanner.GrantEntry grantEntry, KeyStore keyStore, Properties properties, boolean bl) throws Exception {
        if (permissionEntry.name != null) {
            permissionEntry.name = PolicyUtils.expandGeneral(permissionEntry.name, new PermissionExpander().configure(grantEntry, keyStore));
        }
        if (bl) {
            if (permissionEntry.name != null) {
                permissionEntry.name = PolicyUtils.expand(permissionEntry.name, properties);
            }
            if (permissionEntry.actions != null) {
                permissionEntry.actions = PolicyUtils.expand(permissionEntry.actions, properties);
            }
            if (permissionEntry.signers != null) {
                permissionEntry.signers = PolicyUtils.expand(permissionEntry.signers, properties);
            }
        }
        Object[] objectArray = permissionEntry.signers == null ? null : this.resolveSigners(keyStore, permissionEntry.signers);
        try {
            Class<?> clazz = Class.forName(permissionEntry.klass);
            if (PolicyUtils.matchSubset(objectArray, clazz.getSigners())) {
                return PolicyUtils.instantiatePermission(clazz, permissionEntry.name, permissionEntry.actions);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return new UnresolvedPermission(permissionEntry.klass, permissionEntry.name, permissionEntry.actions, (Certificate[])objectArray);
    }

    protected Certificate[] resolveSigners(KeyStore keyStore, String string) throws Exception {
        if (keyStore == null) {
            throw new KeyStoreException(Messages.getString("security.146", string));
        }
        HashSet<Certificate> hashSet = new HashSet<Certificate>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            Certificate certificate = keyStore.getCertificate(stringTokenizer.nextToken().trim());
            if (null == certificate) {
                throw new Exception();
            }
            hashSet.add(certificate);
        }
        return hashSet.toArray(new Certificate[hashSet.size()]);
    }

    protected Principal getPrincipalByAlias(KeyStore keyStore, String string) throws KeyStoreException, CertificateException {
        if (keyStore == null) {
            throw new KeyStoreException(Messages.getString("security.147", string));
        }
        Certificate certificate = keyStore.getCertificate(string);
        if (certificate instanceof X509Certificate) {
            return ((X509Certificate)certificate).getSubjectX500Principal();
        }
        throw new CertificateException(Messages.getString("security.148", string, certificate));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected KeyStore initKeyStore(DefaultPolicyScanner.KeystoreEntry keystoreEntry, URL uRL, Properties properties, boolean bl) {
        if (null == keystoreEntry) {
            return null;
        }
        try {
            Object object;
            InputStream inputStream;
            if (bl) {
                keystoreEntry.url = PolicyUtils.expandURL(keystoreEntry.url, properties);
                if (keystoreEntry.type != null) {
                    keystoreEntry.type = PolicyUtils.expand(keystoreEntry.type, properties);
                }
                if (keystoreEntry.keypassword_url != null) {
                    keystoreEntry.keypassword_url = PolicyUtils.expand(keystoreEntry.keypassword_url, properties);
                }
            }
            if (keystoreEntry.type == null || keystoreEntry.type.length() == 0) {
                keystoreEntry.type = KeyStore.getDefaultType();
            }
            KeyStore keyStore = KeyStore.getInstance(keystoreEntry.type);
            if (SecurityUtils.equalsIgnoreCase(NONE_KEY_STORE, keystoreEntry.url)) {
                inputStream = null;
            } else {
                object = DefaultPolicyParser.getURL(keystoreEntry.url, uRL);
                inputStream = AccessController.doPrivileged(new PolicyUtils.URLLoader((URL)object));
            }
            if (keystoreEntry.keypassword_url == null) {
                object = null;
            } else {
                final URL uRL2 = DefaultPolicyParser.getURL(keystoreEntry.keypassword_url, uRL);
                object = AccessController.doPrivileged(new PrivilegedAction<char[]>(){

                    @Override
                    public char[] run() {
                        try {
                            return DefaultPolicyParser.getKeystorePassword(uRL2);
                        }
                        catch (Exception exception) {
                            return null;
                        }
                    }
                });
            }
            try {
                keyStore.load(inputStream, (char[])object);
            }
            finally {
                inputStream.close();
            }
            return keyStore;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static String formalizePath(String string) {
        return string.replaceAll(" ", "%20");
    }

    private static String getCannonicalPath(File file) {
        String string;
        String string2 = file.getPath();
        boolean bl = false;
        File file2 = file;
        char c = string2.charAt(string2.length() - 1);
        if (c == '-' || c == '*') {
            bl = true;
            String string3 = string2.substring(0, string2.length() - 1);
            if (0 == string3.length()) {
                string3 = ".";
            }
            file2 = new File(string3);
        }
        if (!file2.exists() && !file.isAbsolute()) {
            return null;
        }
        try {
            string = file2.getCanonicalPath();
            if (bl) {
                if (!string.endsWith(File.separator)) {
                    string = string + File.separator;
                }
                string = string + Character.toString(c);
            }
        }
        catch (IOException iOException) {
            string = file.getAbsolutePath();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static char[] getKeystorePassword(URL uRL) throws IOException {
        InputStream inputStream = uRL.openStream();
        char[] cArray = new char[512];
        int n = 0;
        int n2 = -1;
        boolean bl = false;
        try {
            while ((n2 = inputStream.read()) != -1) {
                if (n2 == 10) {
                    break;
                }
                if (bl) {
                    cArray = DefaultPolicyParser.appendChars(cArray, '\r', n++);
                    bl = false;
                }
                if (n2 == 13) {
                    bl = true;
                    continue;
                }
                cArray = DefaultPolicyParser.appendChars(cArray, (char)n2, n++);
            }
        }
        finally {
            inputStream.close();
        }
        if (n == 0) {
            return null;
        }
        char[] cArray2 = new char[n];
        System.arraycopy(cArray, 0, cArray2, 0, n);
        return cArray2;
    }

    private static char[] appendChars(char[] cArray, char c, int n) {
        char[] cArray2 = cArray;
        if (n == cArray.length) {
            cArray2 = new char[cArray.length * 2];
            System.arraycopy(cArray, 0, cArray2, 0, cArray.length);
        }
        cArray2[n] = c;
        return cArray2;
    }

    private static URL getURL(String string, URL uRL) throws MalformedURLException {
        URL uRL2 = new URL(string);
        if (uRL2.getPath().startsWith(".")) {
            uRL2 = new URL(uRL, string);
        }
        return uRL2;
    }

    class PermissionExpander
    implements PolicyUtils.GeneralExpansionHandler {
        private KeyStore ks;
        private DefaultPolicyScanner.GrantEntry ge;

        PermissionExpander() {
        }

        public PermissionExpander configure(DefaultPolicyScanner.GrantEntry grantEntry, KeyStore keyStore) {
            this.ge = grantEntry;
            this.ks = keyStore;
            return this;
        }

        @Override
        public String resolve(String string, String string2) throws PolicyUtils.ExpansionFailedException {
            if ("self".equals(string)) {
                if (this.ge.principals != null && this.ge.principals.size() != 0) {
                    StringBuffer stringBuffer = new StringBuffer();
                    for (DefaultPolicyScanner.PrincipalEntry principalEntry : this.ge.principals) {
                        if (principalEntry.klass == null) {
                            try {
                                stringBuffer.append(this.pc2str(DefaultPolicyParser.this.getPrincipalByAlias(this.ks, principalEntry.name)));
                                continue;
                            }
                            catch (Exception exception) {
                                throw new PolicyUtils.ExpansionFailedException(Messages.getString("security.143", principalEntry.name), exception);
                            }
                        }
                        stringBuffer.append(principalEntry.klass).append(" \"").append(principalEntry.name).append("\" ");
                    }
                    return stringBuffer.toString();
                }
                throw new PolicyUtils.ExpansionFailedException(Messages.getString("security.144"));
            }
            if ("alias".equals(string)) {
                try {
                    return this.pc2str(DefaultPolicyParser.this.getPrincipalByAlias(this.ks, string2));
                }
                catch (Exception exception) {
                    throw new PolicyUtils.ExpansionFailedException(Messages.getString("security.143", string2), exception);
                }
            }
            throw new PolicyUtils.ExpansionFailedException(Messages.getString("security.145", string));
        }

        private String pc2str(Principal principal) {
            String string = principal.getClass().getName();
            String string2 = principal.getName();
            StringBuffer stringBuffer = new StringBuffer(string.length() + string2.length() + 5);
            return stringBuffer.append(string).append(" \"").append(string2).append("\"").toString();
        }
    }
}

