/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.security.asn1;

import java.util.Arrays;
import org.apache.harmony.security.internal.nls.Messages;

public final class ObjectIdentifier {
    private final int[] oid;
    private String soid;

    public ObjectIdentifier(int[] nArray) {
        ObjectIdentifier.validate(nArray);
        this.oid = nArray;
    }

    public ObjectIdentifier(String string) {
        this.oid = ObjectIdentifier.toIntArray(string);
        this.soid = string;
    }

    public int[] getOid() {
        return this.oid;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        return Arrays.equals(this.oid, ((ObjectIdentifier)object).oid);
    }

    public String toString() {
        if (this.soid == null) {
            this.soid = ObjectIdentifier.toString(this.oid);
        }
        return this.soid;
    }

    public int hashCode() {
        int n = 0;
        for (int i = 0; i < this.oid.length && i < 4; ++i) {
            n += this.oid[i] << 8 * i;
        }
        return n & Integer.MAX_VALUE;
    }

    public static void validate(int[] nArray) {
        if (nArray == null) {
            throw new IllegalArgumentException(Messages.getString("security.98"));
        }
        if (nArray.length < 2) {
            throw new IllegalArgumentException(Messages.getString("security.99"));
        }
        if (nArray[0] > 2) {
            throw new IllegalArgumentException(Messages.getString("security.9A"));
        }
        if (nArray[0] != 2 && nArray[1] > 39) {
            throw new IllegalArgumentException(Messages.getString("security.9B"));
        }
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] >= 0) continue;
            throw new IllegalArgumentException(Messages.getString("security.9C"));
        }
    }

    public static String toString(int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer(3 * nArray.length);
        for (int i = 0; i < nArray.length - 1; ++i) {
            stringBuffer.append(nArray[i]);
            stringBuffer.append('.');
        }
        stringBuffer.append(nArray[nArray.length - 1]);
        return stringBuffer.toString();
    }

    public static int[] toIntArray(String string) {
        char c;
        if (string == null) {
            throw new IllegalArgumentException(Messages.getString("security.9D"));
        }
        int n = string.length();
        if (n == 0) {
            throw new IllegalArgumentException(Messages.getString("security.9E"));
        }
        int n2 = 1;
        boolean bl = true;
        for (int i = 0; i < n; ++i) {
            c = string.charAt(i);
            if (c == '.') {
                if (bl) {
                    throw new IllegalArgumentException(Messages.getString("security.9E"));
                }
                bl = true;
                ++n2;
                continue;
            }
            if (c >= '0' && c <= '9') {
                bl = false;
                continue;
            }
            throw new IllegalArgumentException(Messages.getString("security.9E"));
        }
        if (bl) {
            throw new IllegalArgumentException(Messages.getString("security.9E"));
        }
        if (n2 < 2) {
            throw new IllegalArgumentException(Messages.getString("security.99"));
        }
        int[] nArray = new int[n2];
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            c = string.charAt(i);
            if (c == '.') {
                ++n3;
                continue;
            }
            nArray[n3] = nArray[n3] * 10 + c - 48;
        }
        if (nArray[0] > 2) {
            throw new IllegalArgumentException(Messages.getString("security.9A"));
        }
        if (nArray[0] != 2 && nArray[1] > 39) {
            throw new IllegalArgumentException(Messages.getString("security.9B"));
        }
        return nArray;
    }
}

