/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.security.asn1;

import org.apache.harmony.security.internal.nls.Messages;

public final class BitString {
    private static final byte[] SET_MASK = new byte[]{-128, 64, 32, 16, 8, 4, 2, 1};
    private static final byte[] RESET_MASK = new byte[]{127, -65, -33, -17, -9, -5, -3, -2};
    public final byte[] bytes;
    public final int unusedBits;

    public BitString(byte[] byArray, int n) {
        if (n < 0 || n > 7) {
            throw new IllegalArgumentException(Messages.getString("security.13D"));
        }
        if (byArray.length == 0 && n != 0) {
            throw new IllegalArgumentException(Messages.getString("security.13E"));
        }
        this.bytes = byArray;
        this.unusedBits = n;
    }

    public BitString(boolean[] blArray) {
        this.unusedBits = blArray.length % 8;
        int n = blArray.length / 8;
        if (this.unusedBits != 0) {
            ++n;
        }
        this.bytes = new byte[n];
        for (int i = 0; i < blArray.length; ++i) {
            this.setBit(i, blArray[i]);
        }
    }

    public boolean getBit(int n) {
        int n2 = n / 8;
        int n3 = n % 8;
        return (this.bytes[n2] & SET_MASK[n3]) != 0;
    }

    public void setBit(int n, boolean bl) {
        int n2 = n % 8;
        int n3 = n / 8;
        if (bl) {
            int n4 = n3;
            this.bytes[n4] = (byte)(this.bytes[n4] | SET_MASK[n2]);
        } else {
            int n5 = n3;
            this.bytes[n5] = (byte)(this.bytes[n5] & RESET_MASK[n2]);
        }
    }

    public boolean[] toBooleanArray() {
        boolean[] blArray = new boolean[this.bytes.length * 8 - this.unusedBits];
        for (int i = 0; i < blArray.length; ++i) {
            blArray[i] = this.getBit(i);
        }
        return blArray;
    }
}

