/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.security.asn1;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.harmony.security.asn1.ASN1Exception;
import org.apache.harmony.security.asn1.ASN1Sequence;
import org.apache.harmony.security.asn1.ASN1SequenceOf;
import org.apache.harmony.security.asn1.ASN1Set;
import org.apache.harmony.security.asn1.ASN1SetOf;
import org.apache.harmony.security.asn1.ASN1StringType;
import org.apache.harmony.security.asn1.ASN1Type;
import org.apache.harmony.security.asn1.ASN1ValueCollection;
import org.apache.harmony.security.internal.nls.Messages;

public class BerInputStream {
    protected InputStream in;
    protected byte[] buffer;
    protected int offset = 0;
    private static final int BUF_INCREASE_SIZE = 16384;
    protected static final int INDEFINIT_LENGTH = -1;
    public int tag;
    protected int length;
    public Object content;
    protected int tagOffset;
    protected int contentOffset;
    public int choiceIndex;
    public int[] times;
    public int oidElement;
    protected boolean isVerify;
    protected boolean isIndefinedLength;
    private Object[][] pool;

    public BerInputStream() {
    }

    public BerInputStream(byte[] byArray) throws IOException {
        this(byArray, 0, byArray.length);
    }

    public BerInputStream(byte[] byArray, int n, int n2) throws IOException {
        this.buffer = byArray;
        this.offset = n;
        this.next();
        if (this.length != -1 && n + n2 != this.offset + this.length) {
            throw new ASN1Exception(Messages.getString("security.111"));
        }
    }

    public BerInputStream(InputStream inputStream) throws IOException {
        this(inputStream, 16384);
    }

    public BerInputStream(InputStream inputStream, int n) throws IOException {
        this.in = inputStream;
        this.buffer = new byte[n];
        this.next();
        if (this.length != -1) {
            if (this.buffer.length < this.length) {
                byte[] byArray = new byte[this.length];
                System.arraycopy(this.buffer, 0, byArray, 0, this.offset);
                this.buffer = byArray;
            }
        } else {
            this.isIndefinedLength = true;
            throw new ASN1Exception(Messages.getString("security.112"));
        }
    }

    public final void reset(byte[] byArray) throws IOException {
        this.buffer = byArray;
        this.next();
    }

    public int next() throws IOException {
        this.tagOffset = this.offset;
        this.tag = this.read();
        this.length = this.read();
        if (this.length != 128) {
            if ((this.length & 0x80) != 0) {
                int n = this.length & 0x7F;
                if (n > 5) {
                    throw new ASN1Exception(Messages.getString("security.113", this.tagOffset));
                }
                this.length = this.read();
                for (int i = 1; i < n; ++i) {
                    int n2 = this.read();
                    this.length = (this.length << 8) + n2;
                }
                if (this.length > 0xFFFFFF) {
                    throw new ASN1Exception(Messages.getString("security.113", this.tagOffset));
                }
            }
        } else {
            this.length = -1;
        }
        this.contentOffset = this.offset;
        return this.tag;
    }

    public static int getLength(byte[] byArray) {
        int n = byArray[1] & 0xFF;
        int n2 = 0;
        if ((n & 0x80) != 0) {
            n2 = n & 0x7F;
            n = byArray[2] & 0xFF;
            for (int i = 3; i < n2 + 2; ++i) {
                n = (n << 8) + (byArray[i] & 0xFF);
            }
        }
        return 2 + n2 + n;
    }

    public void readBitString() throws IOException {
        if (this.tag == 3) {
            if (this.length == 0) {
                throw new ASN1Exception(Messages.getString("security.114", this.tagOffset));
            }
            this.readContent();
            if (this.buffer[this.contentOffset] > 7) {
                throw new ASN1Exception(Messages.getString("security.115", this.contentOffset));
            }
            if (this.length == 1 && this.buffer[this.contentOffset] != 0) {
                throw new ASN1Exception(Messages.getString("security.116", this.contentOffset));
            }
        } else {
            if (this.tag == 35) {
                throw new ASN1Exception(Messages.getString("security.117"));
            }
            throw new ASN1Exception(Messages.getString("security.118", this.tagOffset, Integer.toHexString(this.tag)));
        }
    }

    public void readEnumerated() throws IOException {
        if (this.tag != 10) {
            throw new ASN1Exception(Messages.getString("security.119", this.tagOffset, Integer.toHexString(this.tag)));
        }
        if (this.length == 0) {
            throw new ASN1Exception(Messages.getString("security.11A", this.tagOffset));
        }
        this.readContent();
        if (this.length > 1) {
            int n = this.buffer[this.contentOffset] & 0xFF;
            if (this.buffer[this.contentOffset + 1] < 0) {
                n += 256;
            }
            if (n == 0 || n == 511) {
                throw new ASN1Exception(Messages.getString("security.11B", this.contentOffset));
            }
        }
    }

    public void readBoolean() throws IOException {
        if (this.tag != 1) {
            throw new ASN1Exception(Messages.getString("security.11C", this.tagOffset, Integer.toHexString(this.tag)));
        }
        if (this.length != 1) {
            throw new ASN1Exception(Messages.getString("security.11D", this.tagOffset));
        }
        this.readContent();
    }

    public void readGeneralizedTime() throws IOException {
        if (this.tag == 24) {
            byte by;
            this.readContent();
            if (this.buffer[this.offset - 1] != 90) {
                throw new ASN1Exception(Messages.getString("security.11E"));
            }
            if (this.length != 15 && (this.length < 17 || this.length > 19)) {
                throw new ASN1Exception(Messages.getString("security.11F", this.contentOffset));
            }
            if (this.length > 16 && (by = this.buffer[this.contentOffset + 14]) != 46 && by != 44) {
                throw new ASN1Exception(Messages.getString("security.11F", this.contentOffset));
            }
            if (this.times == null) {
                this.times = new int[7];
            }
            this.times[0] = this.strToInt(this.contentOffset, 4);
            this.times[1] = this.strToInt(this.contentOffset + 4, 2);
            this.times[2] = this.strToInt(this.contentOffset + 6, 2);
            this.times[3] = this.strToInt(this.contentOffset + 8, 2);
            this.times[4] = this.strToInt(this.contentOffset + 10, 2);
            this.times[5] = this.strToInt(this.contentOffset + 12, 2);
            if (this.length > 16) {
                this.times[6] = this.strToInt(this.contentOffset + 15, this.length - 16);
                if (this.length == 17) {
                    this.times[6] = this.times[6] * 100;
                } else if (this.length == 18) {
                    this.times[6] = this.times[6] * 10;
                }
            }
        } else {
            if (this.tag == 56) {
                throw new ASN1Exception(Messages.getString("security.120"));
            }
            throw new ASN1Exception(Messages.getString("security.121", this.tagOffset, Integer.toHexString(this.tag)));
        }
    }

    public void readUTCTime() throws IOException {
        if (this.tag == 23) {
            switch (this.length) {
                case 11: 
                case 13: {
                    break;
                }
                case 15: 
                case 17: {
                    throw new ASN1Exception(Messages.getString("security.122"));
                }
                default: {
                    throw new ASN1Exception(Messages.getString("security.123", this.tagOffset));
                }
            }
            this.readContent();
            if (this.buffer[this.offset - 1] != 90) {
                throw new ASN1Exception("ASN.1 UTCTime wrongly encoded at [" + this.contentOffset + ']');
            }
            if (this.times == null) {
                this.times = new int[7];
            }
            this.times[0] = this.strToInt(this.contentOffset, 2);
            this.times[0] = this.times[0] > 49 ? this.times[0] + 1900 : this.times[0] + 2000;
            this.times[1] = this.strToInt(this.contentOffset + 2, 2);
            this.times[2] = this.strToInt(this.contentOffset + 4, 2);
            this.times[3] = this.strToInt(this.contentOffset + 6, 2);
            this.times[4] = this.strToInt(this.contentOffset + 8, 2);
            if (this.length == 13) {
                this.times[5] = this.strToInt(this.contentOffset + 10, 2);
            }
        } else {
            if (this.tag == 55) {
                throw new ASN1Exception(Messages.getString("security.124"));
            }
            throw new ASN1Exception(Messages.getString("security.125", this.tagOffset, Integer.toHexString(this.tag)));
        }
    }

    private int strToInt(int n, int n2) throws ASN1Exception {
        int n3 = 0;
        int n4 = n + n2;
        for (int i = n; i < n4; ++i) {
            int n5 = this.buffer[i] - 48;
            if (n5 < 0 || n5 > 9) {
                throw new ASN1Exception(Messages.getString("security.126"));
            }
            n3 = n3 * 10 + n5;
        }
        return n3;
    }

    public void readInteger() throws IOException {
        if (this.tag != 2) {
            throw new ASN1Exception(Messages.getString("security.127", this.tagOffset, Integer.toHexString(this.tag)));
        }
        if (this.length < 1) {
            throw new ASN1Exception(Messages.getString("security.128", this.tagOffset));
        }
        this.readContent();
        if (this.length > 1) {
            byte by = this.buffer[this.offset - this.length];
            byte by2 = (byte)(this.buffer[this.offset - this.length + 1] & 0x80);
            if (by == 0 && by2 == 0 || by == -1 && by2 == -128) {
                throw new ASN1Exception(Messages.getString("security.129", this.offset - this.length));
            }
        }
    }

    public void readOctetString() throws IOException {
        if (this.tag != 4) {
            if (this.tag == 36) {
                throw new ASN1Exception(Messages.getString("security.12A"));
            }
            throw new ASN1Exception(Messages.getString("security.12B", this.tagOffset, Integer.toHexString(this.tag)));
        }
        this.readContent();
    }

    public void readOID() throws IOException {
        if (this.tag != 6) {
            throw new ASN1Exception(Messages.getString("security.12C", this.tagOffset, Integer.toHexString(this.tag)));
        }
        if (this.length < 1) {
            throw new ASN1Exception(Messages.getString("security.12D", this.tagOffset));
        }
        this.readContent();
        if ((this.buffer[this.offset - 1] & 0x80) != 0) {
            throw new ASN1Exception(Messages.getString("security.12E", this.offset - 1));
        }
        this.oidElement = 1;
        int n = 0;
        while (n < this.length) {
            while ((this.buffer[this.contentOffset + n] & 0x80) == 128) {
                ++n;
            }
            ++n;
            ++this.oidElement;
        }
    }

    public void readSequence(ASN1Sequence aSN1Sequence) throws IOException {
        int n;
        if (this.tag != 48) {
            throw new ASN1Exception(Messages.getString("security.12F", this.tagOffset, Integer.toHexString(this.tag)));
        }
        int n2 = this.offset;
        int n3 = n2 + this.length;
        ASN1Type[] aSN1TypeArray = aSN1Sequence.type;
        if (this.isVerify) {
            for (n = 0; this.offset < n3 && n < aSN1TypeArray.length; ++n) {
                this.next();
                while (!aSN1TypeArray[n].checkTag(this.tag)) {
                    if (!aSN1Sequence.OPTIONAL[n] || n == aSN1TypeArray.length - 1) {
                        throw new ASN1Exception(Messages.getString("security.130", this.tagOffset));
                    }
                    ++n;
                }
                aSN1TypeArray[n].decode(this);
            }
            while (n < aSN1TypeArray.length) {
                if (!aSN1Sequence.OPTIONAL[n]) {
                    throw new ASN1Exception(Messages.getString("security.131", this.tagOffset));
                }
                ++n;
            }
        } else {
            int n4 = this.tagOffset;
            Object[] objectArray = new Object[aSN1TypeArray.length];
            while (this.offset < n3 && n < aSN1TypeArray.length) {
                this.next();
                while (!aSN1TypeArray[n].checkTag(this.tag)) {
                    if (!aSN1Sequence.OPTIONAL[n] || n == aSN1TypeArray.length - 1) {
                        throw new ASN1Exception(Messages.getString("security.132", this.tagOffset));
                    }
                    if (aSN1Sequence.DEFAULT[n] != null) {
                        objectArray[n] = aSN1Sequence.DEFAULT[n];
                    }
                    ++n;
                }
                objectArray[n] = aSN1TypeArray[n].decode(this);
                ++n;
            }
            while (n < aSN1TypeArray.length) {
                if (!aSN1Sequence.OPTIONAL[n]) {
                    throw new ASN1Exception(Messages.getString("security.133", this.tagOffset));
                }
                if (aSN1Sequence.DEFAULT[n] != null) {
                    objectArray[n] = aSN1Sequence.DEFAULT[n];
                }
                ++n;
            }
            this.content = objectArray;
            this.tagOffset = n4;
        }
        if (this.offset != n3) {
            throw new ASN1Exception(Messages.getString("security.134", n2));
        }
    }

    public void readSequenceOf(ASN1SequenceOf aSN1SequenceOf) throws IOException {
        if (this.tag != 48) {
            throw new ASN1Exception(Messages.getString("security.135", this.tagOffset, Integer.toHexString(this.tag)));
        }
        this.decodeValueCollection(aSN1SequenceOf);
    }

    public void readSet(ASN1Set aSN1Set) throws IOException {
        if (this.tag != 49) {
            throw new ASN1Exception(Messages.getString("security.136", this.tagOffset, Integer.toHexString(this.tag)));
        }
        throw new ASN1Exception(Messages.getString("security.137"));
    }

    public void readSetOf(ASN1SetOf aSN1SetOf) throws IOException {
        if (this.tag != 49) {
            throw new ASN1Exception(Messages.getString("security.138", this.tagOffset, Integer.toHexString(this.tag)));
        }
        this.decodeValueCollection(aSN1SetOf);
    }

    private final void decodeValueCollection(ASN1ValueCollection aSN1ValueCollection) throws IOException {
        int n = this.offset;
        int n2 = n + this.length;
        ASN1Type aSN1Type = aSN1ValueCollection.type;
        if (this.isVerify) {
            while (n2 > this.offset) {
                this.next();
                aSN1Type.decode(this);
            }
        } else {
            int n3 = this.tagOffset;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            while (n2 > this.offset) {
                this.next();
                arrayList.add(aSN1Type.decode(this));
            }
            this.content = arrayList;
            this.tagOffset = n3;
        }
        if (this.offset != n2) {
            throw new ASN1Exception(Messages.getString("security.134", n));
        }
    }

    public void readString(ASN1StringType aSN1StringType) throws IOException {
        if (this.tag != aSN1StringType.id) {
            if (this.tag == aSN1StringType.constrId) {
                throw new ASN1Exception(Messages.getString("security.139"));
            }
            throw new ASN1Exception(Messages.getString("security.13A", this.tagOffset, Integer.toHexString(this.tag)));
        }
        this.readContent();
    }

    public byte[] getEncoded() {
        byte[] byArray = new byte[this.offset - this.tagOffset];
        System.arraycopy(this.buffer, this.tagOffset, byArray, 0, byArray.length);
        return byArray;
    }

    public final byte[] getBuffer() {
        return this.buffer;
    }

    public final int getLength() {
        return this.length;
    }

    public final int getOffset() {
        return this.offset;
    }

    public final int getEndOffset() {
        return this.offset + this.length;
    }

    public final int getTagOffset() {
        return this.tagOffset;
    }

    public final int getContentOffset() {
        return this.contentOffset;
    }

    public final void setVerify() {
        this.isVerify = true;
    }

    protected int read() throws IOException {
        if (this.offset == this.buffer.length) {
            throw new ASN1Exception(Messages.getString("security.13B"));
        }
        if (this.in == null) {
            return this.buffer[this.offset++] & 0xFF;
        }
        int n = this.in.read();
        if (n == -1) {
            throw new ASN1Exception(Messages.getString("security.13B"));
        }
        this.buffer[this.offset++] = (byte)n;
        return n;
    }

    public void readContent() throws IOException {
        if (this.offset + this.length > this.buffer.length) {
            throw new ASN1Exception(Messages.getString("security.13B"));
        }
        if (this.in == null) {
            this.offset += this.length;
        } else {
            if (this.in.read(this.buffer, this.offset, this.length) != this.length) {
                throw new ASN1Exception(Messages.getString("security.13C"));
            }
            this.offset += this.length;
        }
    }

    public void compactBuffer() {
        if (this.offset != this.buffer.length) {
            byte[] byArray = new byte[this.offset];
            System.arraycopy(this.buffer, 0, byArray, 0, this.offset);
            this.buffer = byArray;
        }
    }

    public void put(Object object, Object object2) {
        int n;
        if (this.pool == null) {
            this.pool = new Object[2][10];
        }
        for (n = 0; n < this.pool[0].length && this.pool[0][n] != null; ++n) {
            if (this.pool[0][n] != object) continue;
            this.pool[1][n] = object2;
            return;
        }
        if (n == this.pool[0].length) {
            Object[][] objectArray = new Object[this.pool[0].length * 2][2];
            System.arraycopy(this.pool[0], 0, objectArray[0], 0, this.pool[0].length);
            System.arraycopy(this.pool[1], 0, objectArray[1], 0, this.pool[0].length);
            this.pool = objectArray;
        } else {
            this.pool[0][n] = object;
            this.pool[1][n] = object2;
        }
    }

    public Object get(Object object) {
        if (this.pool == null) {
            return null;
        }
        for (int i = 0; i < this.pool[0].length; ++i) {
            if (this.pool[0][i] != object) continue;
            return this.pool[1][i];
        }
        return null;
    }
}

