/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.security.asn1;

import java.io.IOException;
import org.apache.harmony.security.asn1.ASN1Primitive;
import org.apache.harmony.security.asn1.BerInputStream;
import org.apache.harmony.security.asn1.BerOutputStream;
import org.apache.harmony.security.asn1.ObjectIdentifier;

public class ASN1Oid
extends ASN1Primitive {
    private static final ASN1Oid ASN1 = new ASN1Oid();
    private static final ASN1Oid STRING_OID = new ASN1Oid(){

        @Override
        public Object getDecodedObject(BerInputStream berInputStream) throws IOException {
            StringBuffer stringBuffer = new StringBuffer();
            byte by = berInputStream.buffer[berInputStream.contentOffset];
            int n = by & 0x7F;
            int n2 = 0;
            while ((by & 0x80) != 0) {
                by = berInputStream.buffer[berInputStream.contentOffset + ++n2];
                n = n << 7 | by & 0x7F;
            }
            if (n > 79) {
                stringBuffer.append('2');
                stringBuffer.append('.');
                stringBuffer.append(n - 80);
            } else {
                stringBuffer.append(n / 40);
                stringBuffer.append('.');
                stringBuffer.append(n % 40);
            }
            for (int i = 2; i < berInputStream.oidElement; ++i) {
                stringBuffer.append('.');
                by = berInputStream.buffer[berInputStream.contentOffset + ++n2];
                n = by & 0x7F;
                while ((by & 0x80) != 0) {
                    by = berInputStream.buffer[berInputStream.contentOffset + ++n2];
                    n = n << 7 | by & 0x7F;
                }
                stringBuffer.append(n);
            }
            return stringBuffer.toString();
        }

        @Override
        public void setEncodingContent(BerOutputStream berOutputStream) {
            berOutputStream.content = ObjectIdentifier.toIntArray((String)berOutputStream.content);
            super.setEncodingContent(berOutputStream);
        }
    };

    public ASN1Oid() {
        super(6);
    }

    public static ASN1Oid getInstance() {
        return ASN1;
    }

    @Override
    public Object decode(BerInputStream berInputStream) throws IOException {
        berInputStream.readOID();
        if (berInputStream.isVerify) {
            return null;
        }
        return this.getDecodedObject(berInputStream);
    }

    @Override
    public Object getDecodedObject(BerInputStream berInputStream) throws IOException {
        int n = berInputStream.oidElement;
        int[] nArray = new int[n];
        int n2 = 1;
        int n3 = 0;
        while (n2 < nArray.length) {
            byte by = berInputStream.buffer[berInputStream.contentOffset + n3];
            n = by & 0x7F;
            while ((by & 0x80) != 0) {
                by = berInputStream.buffer[berInputStream.contentOffset + ++n3];
                n = n << 7 | by & 0x7F;
            }
            nArray[n2] = n;
            ++n2;
            ++n3;
        }
        if (nArray[1] > 79) {
            nArray[0] = 2;
            nArray[1] = nArray[1] - 80;
        } else {
            nArray[0] = nArray[1] / 40;
            nArray[1] = nArray[1] % 40;
        }
        return nArray;
    }

    @Override
    public void encodeContent(BerOutputStream berOutputStream) {
        berOutputStream.encodeOID();
    }

    @Override
    public void setEncodingContent(BerOutputStream berOutputStream) {
        int[] nArray = (int[])berOutputStream.content;
        int n = 0;
        int n2 = nArray[0] * 40 + nArray[1];
        if (n2 == 0) {
            n = 1;
        } else {
            while (n2 > 0) {
                ++n;
                n2 >>= 7;
            }
        }
        for (int i = 2; i < nArray.length; ++i) {
            if (nArray[i] == 0) {
                ++n;
                continue;
            }
            for (n2 = nArray[i]; n2 > 0; n2 >>= 7) {
                ++n;
            }
        }
        berOutputStream.length = n;
    }

    public static ASN1Oid getInstanceForString() {
        return STRING_OID;
    }
}

