/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.security.asn1;

import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import org.apache.harmony.security.asn1.ASN1Any;
import org.apache.harmony.security.asn1.ASN1Exception;
import org.apache.harmony.security.asn1.ASN1Type;
import org.apache.harmony.security.asn1.BerInputStream;
import org.apache.harmony.security.asn1.BerOutputStream;
import org.apache.harmony.security.internal.nls.Messages;

public abstract class ASN1Choice
extends ASN1Type {
    public final ASN1Type[] type;
    private final int[][] identifiers;

    public ASN1Choice(ASN1Type[] aSN1TypeArray) {
        super(0);
        Object object;
        int n;
        if (aSN1TypeArray.length == 0) {
            throw new IllegalArgumentException(Messages.getString("security.10E", this.getClass().getName()));
        }
        TreeMap treeMap = new TreeMap();
        for (n = 0; n < aSN1TypeArray.length; ++n) {
            object = aSN1TypeArray[n];
            if (object instanceof ASN1Any) {
                throw new IllegalArgumentException(Messages.getString("security.10F", this.getClass().getName()));
            }
            if (object instanceof ASN1Choice) {
                int[][] nArray = ((ASN1Choice)object).identifiers;
                for (int i = 0; i < nArray[0].length; ++i) {
                    this.addIdentifier(treeMap, nArray[0][i], n);
                }
                continue;
            }
            if (((ASN1Type)object).checkTag(((ASN1Type)object).id)) {
                this.addIdentifier(treeMap, ((ASN1Type)object).id, n);
            }
            if (!((ASN1Type)object).checkTag(((ASN1Type)object).constrId)) continue;
            this.addIdentifier(treeMap, ((ASN1Type)object).constrId, n);
        }
        n = treeMap.size();
        this.identifiers = new int[2][n];
        object = treeMap.entrySet().iterator();
        for (int i = 0; i < n; ++i) {
            Map.Entry entry = (Map.Entry)object.next();
            BigInteger bigInteger = (BigInteger)entry.getKey();
            this.identifiers[0][i] = bigInteger.intValue();
            this.identifiers[1][i] = ((BigInteger)entry.getValue()).intValue();
        }
        this.type = aSN1TypeArray;
    }

    private void addIdentifier(TreeMap treeMap, int n, int n2) {
        if (treeMap.put(BigInteger.valueOf(n), BigInteger.valueOf(n2)) != null) {
            throw new IllegalArgumentException(Messages.getString("security.10F", this.getClass().getName()));
        }
    }

    @Override
    public final boolean checkTag(int n) {
        return Arrays.binarySearch(this.identifiers[0], n) >= 0;
    }

    @Override
    public Object decode(BerInputStream berInputStream) throws IOException {
        int n = Arrays.binarySearch(this.identifiers[0], berInputStream.tag);
        if (n < 0) {
            throw new ASN1Exception(Messages.getString("security.110", this.getClass().getName()));
        }
        n = this.identifiers[1][n];
        berInputStream.content = this.type[n].decode(berInputStream);
        berInputStream.choiceIndex = n;
        if (berInputStream.isVerify) {
            return null;
        }
        return this.getDecodedObject(berInputStream);
    }

    @Override
    public void encodeASN(BerOutputStream berOutputStream) {
        this.encodeContent(berOutputStream);
    }

    @Override
    public final void encodeContent(BerOutputStream berOutputStream) {
        berOutputStream.encodeChoice(this);
    }

    public abstract int getIndex(Object var1);

    public abstract Object getObjectToEncode(Object var1);

    @Override
    public final void setEncodingContent(BerOutputStream berOutputStream) {
        berOutputStream.getChoiceLength(this);
    }
}

