/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.security.asn1;

import java.io.IOException;
import org.apache.harmony.security.asn1.ASN1Primitive;
import org.apache.harmony.security.asn1.BerInputStream;
import org.apache.harmony.security.asn1.BerOutputStream;

public class ASN1Boolean
extends ASN1Primitive {
    private static final ASN1Boolean ASN1 = new ASN1Boolean();

    public ASN1Boolean() {
        super(1);
    }

    public static ASN1Boolean getInstance() {
        return ASN1;
    }

    @Override
    public Object decode(BerInputStream berInputStream) throws IOException {
        berInputStream.readBoolean();
        if (berInputStream.isVerify) {
            return null;
        }
        return this.getDecodedObject(berInputStream);
    }

    @Override
    public Object getDecodedObject(BerInputStream berInputStream) throws IOException {
        if (berInputStream.buffer[berInputStream.contentOffset] == 0) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public void encodeContent(BerOutputStream berOutputStream) {
        berOutputStream.encodeBoolean();
    }

    @Override
    public void setEncodingContent(BerOutputStream berOutputStream) {
        berOutputStream.length = 1;
    }
}

