/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.security;

import java.security.Principal;
import org.apache.harmony.security.internal.nls.Messages;

public final class UnresolvedPrincipal
implements Principal {
    public static final String WILDCARD = "*";
    private final String klass;
    private final String name;

    public UnresolvedPrincipal(String string, String string2) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException(Messages.getString("security.91"));
        }
        this.klass = string;
        this.name = string2;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getClassName() {
        return this.klass;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof UnresolvedPrincipal) {
            UnresolvedPrincipal unresolvedPrincipal = (UnresolvedPrincipal)object;
            return this.klass.equals(unresolvedPrincipal.klass) && (this.name == null ? unresolvedPrincipal.name == null : this.name.equals(unresolvedPrincipal.name));
        }
        if (object instanceof Principal) {
            return this.implies((Principal)object);
        }
        return false;
    }

    public boolean implies(Principal principal) {
        return principal != null && (WILDCARD.equals(this.klass) || this.klass.equals(principal.getClass().getName()) && (WILDCARD.equals(this.name) || (this.name == null ? principal.getName() == null : this.name.equals(principal.getName()))));
    }

    @Override
    public int hashCode() {
        int n = 0;
        if (this.name != null) {
            n ^= this.name.hashCode();
        }
        if (this.klass != null) {
            n ^= this.klass.hashCode();
        }
        return n;
    }

    @Override
    public String toString() {
        return "Principal " + this.klass + " \"" + this.name + "\"";
    }
}

