/*
 * Decompiled with CFR 0.152.
 */
package java.security.spec;

import java.math.BigInteger;
import java.security.spec.RSAOtherPrimeInfo;
import java.security.spec.RSAPrivateKeySpec;
import org.apache.harmony.security.internal.nls.Messages;

public class RSAMultiPrimePrivateCrtKeySpec
extends RSAPrivateKeySpec {
    private final BigInteger publicExponent;
    private final BigInteger primeP;
    private final BigInteger primeQ;
    private final BigInteger primeExponentP;
    private final BigInteger primeExponentQ;
    private final BigInteger crtCoefficient;
    private final RSAOtherPrimeInfo[] otherPrimeInfo;

    public RSAMultiPrimePrivateCrtKeySpec(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5, BigInteger bigInteger6, BigInteger bigInteger7, BigInteger bigInteger8, RSAOtherPrimeInfo[] rSAOtherPrimeInfoArray) {
        super(bigInteger, bigInteger3);
        if (bigInteger == null) {
            throw new NullPointerException(Messages.getString("security.83", "modulus"));
        }
        if (bigInteger3 == null) {
            throw new NullPointerException(Messages.getString("security.83", "privateExponent"));
        }
        if (bigInteger2 == null) {
            throw new NullPointerException(Messages.getString("security.83", "publicExponent"));
        }
        if (bigInteger4 == null) {
            throw new NullPointerException(Messages.getString("security.83", "primeP"));
        }
        if (bigInteger5 == null) {
            throw new NullPointerException(Messages.getString("security.83", "primeQ"));
        }
        if (bigInteger6 == null) {
            throw new NullPointerException(Messages.getString("security.83", "primeExponentP"));
        }
        if (bigInteger7 == null) {
            throw new NullPointerException(Messages.getString("security.83", "primeExponentQ"));
        }
        if (bigInteger8 == null) {
            throw new NullPointerException(Messages.getString("security.83", "crtCoefficient"));
        }
        if (rSAOtherPrimeInfoArray != null) {
            if (rSAOtherPrimeInfoArray.length == 0) {
                throw new IllegalArgumentException(Messages.getString("security.85"));
            }
            this.otherPrimeInfo = new RSAOtherPrimeInfo[rSAOtherPrimeInfoArray.length];
            System.arraycopy(rSAOtherPrimeInfoArray, 0, this.otherPrimeInfo, 0, this.otherPrimeInfo.length);
        } else {
            this.otherPrimeInfo = null;
        }
        this.publicExponent = bigInteger2;
        this.primeP = bigInteger4;
        this.primeQ = bigInteger5;
        this.primeExponentP = bigInteger6;
        this.primeExponentQ = bigInteger7;
        this.crtCoefficient = bigInteger8;
    }

    public BigInteger getCrtCoefficient() {
        return this.crtCoefficient;
    }

    public RSAOtherPrimeInfo[] getOtherPrimeInfo() {
        if (this.otherPrimeInfo == null) {
            return null;
        }
        RSAOtherPrimeInfo[] rSAOtherPrimeInfoArray = new RSAOtherPrimeInfo[this.otherPrimeInfo.length];
        System.arraycopy(this.otherPrimeInfo, 0, rSAOtherPrimeInfoArray, 0, rSAOtherPrimeInfoArray.length);
        return rSAOtherPrimeInfoArray;
    }

    public BigInteger getPrimeExponentP() {
        return this.primeExponentP;
    }

    public BigInteger getPrimeExponentQ() {
        return this.primeExponentQ;
    }

    public BigInteger getPrimeP() {
        return this.primeP;
    }

    public BigInteger getPrimeQ() {
        return this.primeQ;
    }

    public BigInteger getPublicExponent() {
        return this.publicExponent;
    }
}

