/*
 * Decompiled with CFR 0.152.
 */
package java.security.spec;

import java.math.BigInteger;
import java.security.spec.ECField;
import java.security.spec.ECFieldF2m;
import java.security.spec.ECFieldFp;
import java.util.Arrays;
import org.apache.harmony.security.internal.nls.Messages;

public class EllipticCurve {
    private final ECField field;
    private final BigInteger a;
    private final BigInteger b;
    private final byte[] seed;
    private volatile int hash;

    public EllipticCurve(ECField eCField, BigInteger bigInteger, BigInteger bigInteger2, byte[] byArray) {
        this.field = eCField;
        if (this.field == null) {
            throw new NullPointerException(Messages.getString("security.7A"));
        }
        this.a = bigInteger;
        if (this.a == null) {
            throw new NullPointerException(Messages.getString("security.7B"));
        }
        this.b = bigInteger2;
        if (this.b == null) {
            throw new NullPointerException(Messages.getString("security.7C"));
        }
        if (byArray == null) {
            this.seed = null;
        } else {
            this.seed = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.seed, 0, this.seed.length);
        }
        if (this.field instanceof ECFieldFp) {
            BigInteger bigInteger3 = ((ECFieldFp)this.field).getP();
            if (this.a.signum() < 0 || this.a.compareTo(bigInteger3) >= 0) {
                throw new IllegalArgumentException(Messages.getString("security.7D"));
            }
            if (this.b.signum() < 0 || this.b.compareTo(bigInteger3) >= 0) {
                throw new IllegalArgumentException(Messages.getString("security.7E"));
            }
        } else if (this.field instanceof ECFieldF2m) {
            int n = this.field.getFieldSize();
            if (this.a.bitLength() > n) {
                throw new IllegalArgumentException(Messages.getString("security.7D"));
            }
            if (this.b.bitLength() > n) {
                throw new IllegalArgumentException(Messages.getString("security.7E"));
            }
        }
    }

    public EllipticCurve(ECField eCField, BigInteger bigInteger, BigInteger bigInteger2) {
        this(eCField, bigInteger, bigInteger2, null);
    }

    public BigInteger getA() {
        return this.a;
    }

    public BigInteger getB() {
        return this.b;
    }

    public ECField getField() {
        return this.field;
    }

    public byte[] getSeed() {
        if (this.seed == null) {
            return null;
        }
        byte[] byArray = new byte[this.seed.length];
        System.arraycopy(this.seed, 0, byArray, 0, byArray.length);
        return byArray;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof EllipticCurve)) {
            return false;
        }
        EllipticCurve ellipticCurve = (EllipticCurve)object;
        return this.field.equals(ellipticCurve.field) && this.a.equals(ellipticCurve.a) && this.b.equals(ellipticCurve.b) && Arrays.equals(this.seed, ellipticCurve.seed);
    }

    public int hashCode() {
        if (this.hash == 0) {
            int n = 11;
            n = n * 31 + this.field.hashCode();
            n = n * 31 + this.a.hashCode();
            n = n * 31 + this.b.hashCode();
            if (this.seed != null) {
                for (int i = 0; i < this.seed.length; ++i) {
                    n = n * 31 + this.seed[i];
                }
            } else {
                n *= 31;
            }
            this.hash = n;
        }
        return this.hash;
    }
}

