/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.Serializable;
import java.security.cert.CertPath;
import java.util.Date;
import org.apache.harmony.security.internal.nls.Messages;

public final class Timestamp
implements Serializable {
    private static final long serialVersionUID = -5502683707821851294L;
    private Date timestamp;
    private CertPath signerCertPath;
    private transient int hash;

    public Timestamp(Date date, CertPath certPath) {
        if (date == null) {
            throw new NullPointerException(Messages.getString("security.0F"));
        }
        if (certPath == null) {
            throw new NullPointerException(Messages.getString("security.10"));
        }
        this.timestamp = new Date(date.getTime());
        this.signerCertPath = certPath;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)object;
            return this.timestamp.equals(timestamp.timestamp) && this.signerCertPath.equals(timestamp.signerCertPath);
        }
        return false;
    }

    public CertPath getSignerCertPath() {
        return this.signerCertPath;
    }

    public Date getTimestamp() {
        return (Date)this.timestamp.clone();
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = this.timestamp.hashCode() ^ this.signerCertPath.hashCode();
        }
        return this.hash;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append("Timestamp [").append(this.timestamp).append(" certPath=");
        stringBuffer.append(this.signerCertPath.getCertificates().get(0)).append("]");
        return stringBuffer.toString();
    }
}

