/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.security.AccessController;
import java.security.Identity;
import java.security.IdentityScope;
import java.security.InvalidParameterException;
import java.security.KeyException;
import java.security.KeyManagementException;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.PublicKey;

@Deprecated
public abstract class Signer
extends Identity {
    private static final long serialVersionUID = -1763464102261361480L;
    private PrivateKey privateKey;

    protected Signer() {
    }

    public Signer(String string) {
        super(string);
    }

    public Signer(String string, IdentityScope identityScope) throws KeyManagementException {
        super(string, identityScope);
    }

    public PrivateKey getPrivateKey() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSecurityAccess("getSignerPrivateKey");
        }
        return this.privateKey;
    }

    public final void setKeyPair(KeyPair keyPair) throws InvalidParameterException, KeyException {
        if (keyPair == null) {
            throw new NullPointerException();
        }
        if (keyPair.getPrivate() == null || keyPair.getPublic() == null) {
            throw new InvalidParameterException();
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSecurityAccess("setSignerKeyPair");
        }
        final PublicKey publicKey = keyPair.getPublic();
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws KeyManagementException {
                    Signer.this.setPublicKey(publicKey);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw new KeyException(privilegedActionException.getException());
        }
        this.privateKey = keyPair.getPrivate();
    }

    @Override
    public String toString() {
        String string = "[Signer]" + this.getName();
        if (this.getScope() != null) {
            string = string + '[' + this.getScope().toString() + ']';
        }
        return string;
    }
}

