/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;

public final class SignedObject
implements Serializable {
    private static final long serialVersionUID = 720502720485447167L;
    private byte[] content;
    private byte[] signature;
    private String thealgorithm;

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        byte[] byArray = new byte[this.content.length];
        System.arraycopy(this.content, 0, byArray, 0, this.content.length);
        this.content = byArray;
        byArray = new byte[this.signature.length];
        System.arraycopy(this.signature, 0, byArray, 0, this.signature.length);
        this.signature = byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SignedObject(Serializable serializable, PrivateKey privateKey, Signature signature) throws IOException, InvalidKeyException, SignatureException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        try {
            objectOutputStream.writeObject(serializable);
            objectOutputStream.flush();
        }
        finally {
            objectOutputStream.close();
        }
        this.content = byteArrayOutputStream.toByteArray();
        signature.initSign(privateKey);
        this.thealgorithm = signature.getAlgorithm();
        signature.update(this.content);
        this.signature = signature.sign();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject() throws IOException, ClassNotFoundException {
        ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(this.content));
        try {
            Object object = objectInputStream.readObject();
            return object;
        }
        finally {
            objectInputStream.close();
        }
    }

    public byte[] getSignature() {
        byte[] byArray = new byte[this.signature.length];
        System.arraycopy(this.signature, 0, byArray, 0, this.signature.length);
        return byArray;
    }

    public String getAlgorithm() {
        return this.thealgorithm;
    }

    public boolean verify(PublicKey publicKey, Signature signature) throws InvalidKeyException, SignatureException {
        signature.initVerify(publicKey);
        signature.update(this.content);
        return signature.verify(this.signature);
    }
}

