/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.nio.ByteBuffer;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.ProtectionDomain;
import java.util.HashMap;

public class SecureClassLoader
extends ClassLoader {
    private HashMap pds = new HashMap();

    protected SecureClassLoader() {
    }

    protected SecureClassLoader(ClassLoader classLoader) {
        super(classLoader);
    }

    protected PermissionCollection getPermissions(CodeSource codeSource) {
        return new Permissions();
    }

    protected final Class<?> defineClass(String string, byte[] byArray, int n, int n2, CodeSource codeSource) {
        return codeSource == null ? this.defineClass(string, byArray, n, n2) : this.defineClass(string, byArray, n, n2, this.getPD(codeSource));
    }

    protected final Class<?> defineClass(String string, ByteBuffer byteBuffer, CodeSource codeSource) {
        byte[] byArray = byteBuffer.array();
        return codeSource == null ? this.defineClass(string, byArray, 0, byArray.length) : this.defineClass(string, byArray, 0, byArray.length, this.getPD(codeSource));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProtectionDomain getPD(CodeSource codeSource) {
        ProtectionDomain protectionDomain;
        if (codeSource == null) {
            return null;
        }
        HashMap hashMap = this.pds;
        synchronized (hashMap) {
            protectionDomain = (ProtectionDomain)this.pds.get(codeSource);
            if (protectionDomain != null) {
                return protectionDomain;
            }
            PermissionCollection permissionCollection = this.getPermissions(codeSource);
            protectionDomain = new ProtectionDomain(codeSource, permissionCollection, this, null);
            this.pds.put(codeSource, protectionDomain);
        }
        return protectionDomain;
    }
}

