/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.security.Provider;
import java.security.Security;
import java.security.UnrecoverableEntryException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import javax.crypto.SecretKey;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Destroyable;
import javax.security.auth.callback.CallbackHandler;
import org.apache.harmony.security.fortress.Engine;
import org.apache.harmony.security.internal.nls.Messages;

public class KeyStore {
    private static final String SERVICE = "KeyStore";
    private static Engine engine = new Engine("KeyStore");
    private static final String PROPERTYNAME = "keystore.type";
    private static final String DEFAULT_KEYSTORE_TYPE = "jks";
    private static final String NOTINITKEYSTORE = Messages.getString("security.4F");
    private boolean isInit;
    private final KeyStoreSpi implSpi;
    private final Provider provider;
    private final String type;

    protected KeyStore(KeyStoreSpi keyStoreSpi, Provider provider, String string) {
        this.type = string;
        this.provider = provider;
        this.implSpi = keyStoreSpi;
        this.isInit = false;
    }

    public static KeyStore getInstance(String string) throws KeyStoreException {
        if (string == null) {
            throw new NullPointerException(Messages.getString("security.07"));
        }
        try {
            Engine.ServiceResult serviceResult = engine.getInstance(string, null);
            return new KeyStore((KeyStoreSpi)serviceResult.spi, serviceResult.provider, string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new KeyStoreException(noSuchAlgorithmException.getMessage());
        }
    }

    public static KeyStore getInstance(String string, String string2) throws KeyStoreException, NoSuchProviderException {
        if (string2 == null || string2.length() == 0) {
            throw new IllegalArgumentException(Messages.getString("security.02"));
        }
        Provider provider = Security.getProvider(string2);
        if (provider == null) {
            throw new NoSuchProviderException(string2);
        }
        try {
            return KeyStore.getInstance(string, provider);
        }
        catch (Exception exception) {
            throw new KeyStoreException(exception.getMessage(), exception);
        }
    }

    public static KeyStore getInstance(String string, Provider provider) throws KeyStoreException {
        if (provider == null) {
            throw new IllegalArgumentException(Messages.getString("security.04"));
        }
        if (string == null) {
            throw new NullPointerException(Messages.getString("security.07"));
        }
        try {
            Engine.ServiceResult serviceResult = engine.getInstance(string, provider, null);
            return new KeyStore((KeyStoreSpi)serviceResult.spi, provider, string);
        }
        catch (Exception exception) {
            throw new KeyStoreException(exception.getMessage());
        }
    }

    public static final String getDefaultType() {
        String string = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return Security.getProperty(KeyStore.PROPERTYNAME);
            }
        });
        return string == null ? DEFAULT_KEYSTORE_TYPE : string;
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final String getType() {
        return this.type;
    }

    public final Key getKey(String string, char[] cArray) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        if (!this.isInit) {
            throw new KeyStoreException(NOTINITKEYSTORE);
        }
        return this.implSpi.engineGetKey(string, cArray);
    }

    public final Certificate[] getCertificateChain(String string) throws KeyStoreException {
        if (!this.isInit) {
            throw new KeyStoreException(NOTINITKEYSTORE);
        }
        return this.implSpi.engineGetCertificateChain(string);
    }

    public final Certificate getCertificate(String string) throws KeyStoreException {
        if (!this.isInit) {
            throw new KeyStoreException(NOTINITKEYSTORE);
        }
        return this.implSpi.engineGetCertificate(string);
    }

    public final Date getCreationDate(String string) throws KeyStoreException {
        if (!this.isInit) {
            throw new KeyStoreException(NOTINITKEYSTORE);
        }
        return this.implSpi.engineGetCreationDate(string);
    }

    public final void setKeyEntry(String string, Key key, char[] cArray, Certificate[] certificateArray) throws KeyStoreException {
        if (!this.isInit) {
            throw new KeyStoreException(NOTINITKEYSTORE);
        }
        if (null != key && key instanceof PrivateKey && (certificateArray == null || certificateArray.length == 0)) {
            throw new IllegalArgumentException(Messages.getString("security.52"));
        }
        this.implSpi.engineSetKeyEntry(string, key, cArray, certificateArray);
    }

    public final void setKeyEntry(String string, byte[] byArray, Certificate[] certificateArray) throws KeyStoreException {
        if (!this.isInit) {
            throw new KeyStoreException(NOTINITKEYSTORE);
        }
        this.implSpi.engineSetKeyEntry(string, byArray, certificateArray);
    }

    public final void setCertificateEntry(String string, Certificate certificate) throws KeyStoreException {
        if (!this.isInit) {
            throw new KeyStoreException(NOTINITKEYSTORE);
        }
        this.implSpi.engineSetCertificateEntry(string, certificate);
    }

    public final void deleteEntry(String string) throws KeyStoreException {
        if (!this.isInit) {
            throw new KeyStoreException(NOTINITKEYSTORE);
        }
        if (string == null) {
            throw new NullPointerException(Messages.getString("security.3F"));
        }
        this.implSpi.engineDeleteEntry(string);
    }

    public final Enumeration<String> aliases() throws KeyStoreException {
        if (!this.isInit) {
            throw new KeyStoreException(NOTINITKEYSTORE);
        }
        return this.implSpi.engineAliases();
    }

    public final boolean containsAlias(String string) throws KeyStoreException {
        if (!this.isInit) {
            throw new KeyStoreException(NOTINITKEYSTORE);
        }
        if (string == null) {
            throw new NullPointerException(Messages.getString("security.3F"));
        }
        return this.implSpi.engineContainsAlias(string);
    }

    public final int size() throws KeyStoreException {
        if (!this.isInit) {
            throw new KeyStoreException(NOTINITKEYSTORE);
        }
        return this.implSpi.engineSize();
    }

    public final boolean isKeyEntry(String string) throws KeyStoreException {
        if (!this.isInit) {
            throw new KeyStoreException(NOTINITKEYSTORE);
        }
        if (string == null) {
            throw new NullPointerException(Messages.getString("security.3F"));
        }
        return this.implSpi.engineIsKeyEntry(string);
    }

    public final boolean isCertificateEntry(String string) throws KeyStoreException {
        if (!this.isInit) {
            throw new KeyStoreException(NOTINITKEYSTORE);
        }
        if (string == null) {
            throw new NullPointerException(Messages.getString("security.3F"));
        }
        return this.implSpi.engineIsCertificateEntry(string);
    }

    public final String getCertificateAlias(Certificate certificate) throws KeyStoreException {
        if (!this.isInit) {
            throw new KeyStoreException(NOTINITKEYSTORE);
        }
        return this.implSpi.engineGetCertificateAlias(certificate);
    }

    public final void store(OutputStream outputStream, char[] cArray) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        if (!this.isInit) {
            throw new KeyStoreException(NOTINITKEYSTORE);
        }
        this.implSpi.engineStore(outputStream, cArray);
    }

    public final void store(LoadStoreParameter loadStoreParameter) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        if (!this.isInit) {
            throw new KeyStoreException(NOTINITKEYSTORE);
        }
        this.implSpi.engineStore(loadStoreParameter);
    }

    public final void load(InputStream inputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        this.implSpi.engineLoad(inputStream, cArray);
        this.isInit = true;
    }

    public final void load(LoadStoreParameter loadStoreParameter) throws IOException, NoSuchAlgorithmException, CertificateException {
        this.implSpi.engineLoad(loadStoreParameter);
        this.isInit = true;
    }

    public final Entry getEntry(String string, ProtectionParameter protectionParameter) throws NoSuchAlgorithmException, UnrecoverableEntryException, KeyStoreException {
        if (string == null) {
            throw new NullPointerException(Messages.getString("security.3F"));
        }
        if (!this.isInit) {
            throw new KeyStoreException(NOTINITKEYSTORE);
        }
        return this.implSpi.engineGetEntry(string, protectionParameter);
    }

    public final void setEntry(String string, Entry entry, ProtectionParameter protectionParameter) throws KeyStoreException {
        if (!this.isInit) {
            throw new KeyStoreException(NOTINITKEYSTORE);
        }
        if (string == null) {
            throw new NullPointerException(Messages.getString("security.3F"));
        }
        if (entry == null) {
            throw new NullPointerException(Messages.getString("security.39"));
        }
        this.implSpi.engineSetEntry(string, entry, protectionParameter);
    }

    public final boolean entryInstanceOf(String string, Class<? extends Entry> clazz) throws KeyStoreException {
        if (string == null) {
            throw new NullPointerException(Messages.getString("security.3F"));
        }
        if (clazz == null) {
            throw new NullPointerException(Messages.getString("security.40"));
        }
        if (!this.isInit) {
            throw new KeyStoreException(NOTINITKEYSTORE);
        }
        return this.implSpi.engineEntryInstanceOf(string, clazz);
    }

    public static final class TrustedCertificateEntry
    implements Entry {
        private final Certificate trustCertificate;

        public TrustedCertificateEntry(Certificate certificate) {
            if (certificate == null) {
                throw new NullPointerException(Messages.getString("security.4E"));
            }
            this.trustCertificate = certificate;
        }

        public Certificate getTrustedCertificate() {
            return this.trustCertificate;
        }

        public String toString() {
            return "Trusted certificate entry:\n" + this.trustCertificate;
        }
    }

    public static final class SecretKeyEntry
    implements Entry {
        private final SecretKey secretKey;

        public SecretKeyEntry(SecretKey secretKey) {
            if (secretKey == null) {
                throw new NullPointerException(Messages.getString("security.4D"));
            }
            this.secretKey = secretKey;
        }

        public SecretKey getSecretKey() {
            return this.secretKey;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer("SecretKeyEntry: algorithm - ");
            stringBuffer.append(this.secretKey.getAlgorithm());
            return stringBuffer.toString();
        }
    }

    public static final class PrivateKeyEntry
    implements Entry {
        private Certificate[] chain;
        private PrivateKey privateKey;

        public PrivateKeyEntry(PrivateKey privateKey, Certificate[] certificateArray) {
            int n;
            if (privateKey == null) {
                throw new NullPointerException(Messages.getString("security.48"));
            }
            if (certificateArray == null) {
                throw new NullPointerException(Messages.getString("security.49"));
            }
            if (certificateArray.length == 0) {
                throw new IllegalArgumentException(Messages.getString("security.4A"));
            }
            String string = certificateArray[0].getType();
            if (!certificateArray[0].getPublicKey().getAlgorithm().equals(privateKey.getAlgorithm())) {
                throw new IllegalArgumentException(Messages.getString("security.4B"));
            }
            for (n = 1; n < certificateArray.length; ++n) {
                if (string.equals(certificateArray[n].getType())) continue;
                throw new IllegalArgumentException(Messages.getString("security.4C"));
            }
            n = 1;
            for (Certificate certificate : certificateArray) {
                if (certificate instanceof X509Certificate) continue;
                n = 0;
                break;
            }
            this.chain = n != 0 ? new X509Certificate[certificateArray.length] : new Certificate[certificateArray.length];
            System.arraycopy(certificateArray, 0, this.chain, 0, certificateArray.length);
            this.privateKey = privateKey;
        }

        public PrivateKey getPrivateKey() {
            return this.privateKey;
        }

        public Certificate[] getCertificateChain() {
            return (Certificate[])this.chain.clone();
        }

        public Certificate getCertificate() {
            return this.chain[0];
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer("PrivateKeyEntry: number of elements in certificate chain is ");
            stringBuffer.append(Integer.toString(this.chain.length));
            stringBuffer.append("\n");
            for (int i = 0; i < this.chain.length; ++i) {
                stringBuffer.append(this.chain[i].toString());
                stringBuffer.append("\n");
            }
            return stringBuffer.toString();
        }
    }

    public static interface ProtectionParameter {
    }

    public static class PasswordProtection
    implements ProtectionParameter,
    Destroyable {
        private char[] password;
        private boolean isDestroyed = false;

        public PasswordProtection(char[] cArray) {
            if (cArray != null) {
                this.password = (char[])cArray.clone();
            }
        }

        public synchronized char[] getPassword() {
            if (this.isDestroyed) {
                throw new IllegalStateException(Messages.getString("security.36"));
            }
            return this.password;
        }

        @Override
        public synchronized void destroy() throws DestroyFailedException {
            this.isDestroyed = true;
            if (this.password != null) {
                Arrays.fill(this.password, '\u0000');
                this.password = null;
            }
        }

        @Override
        public synchronized boolean isDestroyed() {
            return this.isDestroyed;
        }
    }

    public static interface LoadStoreParameter {
        public ProtectionParameter getProtectionParameter();
    }

    public static interface Entry {
    }

    public static class CallbackHandlerProtection
    implements ProtectionParameter {
        private final CallbackHandler callbackHandler;

        public CallbackHandlerProtection(CallbackHandler callbackHandler) {
            if (callbackHandler == null) {
                throw new NullPointerException(Messages.getString("security.47"));
            }
            this.callbackHandler = callbackHandler;
        }

        public CallbackHandler getCallbackHandler() {
            return this.callbackHandler;
        }
    }

    public static abstract class Builder {
        protected Builder() {
        }

        public abstract KeyStore getKeyStore() throws KeyStoreException;

        public abstract ProtectionParameter getProtectionParameter(String var1) throws KeyStoreException;

        public static Builder newInstance(KeyStore keyStore, ProtectionParameter protectionParameter) {
            if (keyStore == null) {
                throw new NullPointerException(Messages.getString("security.41"));
            }
            if (protectionParameter == null) {
                throw new NullPointerException(Messages.getString("security.42"));
            }
            if (!keyStore.isInit) {
                throw new IllegalArgumentException(NOTINITKEYSTORE);
            }
            return new BuilderImpl(keyStore, protectionParameter, null, null, null, null);
        }

        public static Builder newInstance(String string, Provider provider, File file, ProtectionParameter protectionParameter) {
            if (string == null) {
                throw new NullPointerException(Messages.getString("security.07"));
            }
            if (protectionParameter == null) {
                throw new NullPointerException(Messages.getString("security.42"));
            }
            if (file == null) {
                throw new NullPointerException(Messages.getString("security.43"));
            }
            if (!(protectionParameter instanceof PasswordProtection) && !(protectionParameter instanceof CallbackHandlerProtection)) {
                throw new IllegalArgumentException(Messages.getString("security.35"));
            }
            if (!file.exists()) {
                throw new IllegalArgumentException(Messages.getString("security.44", file.getName()));
            }
            if (!file.isFile()) {
                throw new IllegalArgumentException(Messages.getString("security.45", file.getName()));
            }
            return new BuilderImpl(null, protectionParameter, file, string, provider, AccessController.getContext());
        }

        public static Builder newInstance(String string, Provider provider, ProtectionParameter protectionParameter) {
            if (string == null) {
                throw new NullPointerException(Messages.getString("security.07"));
            }
            if (protectionParameter == null) {
                throw new NullPointerException(Messages.getString("security.42"));
            }
            return new BuilderImpl(null, protectionParameter, null, string, provider, AccessController.getContext());
        }

        private static class TmpLSParameter
        implements LoadStoreParameter {
            private final ProtectionParameter protPar;

            public TmpLSParameter(ProtectionParameter protectionParameter) {
                this.protPar = protectionParameter;
            }

            @Override
            public ProtectionParameter getProtectionParameter() {
                return this.protPar;
            }
        }

        private static class BuilderImpl
        extends Builder {
            private KeyStore keyStore;
            private ProtectionParameter protParameter;
            private final String typeForKeyStore;
            private final Provider providerForKeyStore;
            private final File fileForLoad;
            private boolean isGetKeyStore = false;
            private KeyStoreException lastException;
            private final AccessControlContext accControlContext;

            BuilderImpl(KeyStore keyStore, ProtectionParameter protectionParameter, File file, String string, Provider provider, AccessControlContext accessControlContext) {
                this.keyStore = keyStore;
                this.protParameter = protectionParameter;
                this.fileForLoad = file;
                this.typeForKeyStore = string;
                this.providerForKeyStore = provider;
                this.isGetKeyStore = false;
                this.lastException = null;
                this.accControlContext = accessControlContext;
            }

            @Override
            public synchronized KeyStore getKeyStore() throws KeyStoreException {
                if (this.lastException != null) {
                    throw this.lastException;
                }
                if (this.keyStore != null) {
                    this.isGetKeyStore = true;
                    return this.keyStore;
                }
                try {
                    char[] cArray;
                    KeyStore keyStore;
                    KeyStore keyStore2 = keyStore = this.providerForKeyStore == null ? KeyStore.getInstance(this.typeForKeyStore) : KeyStore.getInstance(this.typeForKeyStore, this.providerForKeyStore);
                    if (this.protParameter instanceof PasswordProtection) {
                        cArray = ((PasswordProtection)this.protParameter).getPassword();
                    } else if (this.protParameter instanceof CallbackHandlerProtection) {
                        cArray = KeyStoreSpi.getPasswordFromCallBack(this.protParameter);
                    } else {
                        throw new KeyStoreException(Messages.getString("security.35"));
                    }
                    AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public Object run() throws Exception {
                            if (BuilderImpl.this.fileForLoad != null) {
                                FileInputStream fileInputStream = null;
                                try {
                                    fileInputStream = new FileInputStream(BuilderImpl.this.fileForLoad);
                                    keyStore.load(fileInputStream, cArray);
                                }
                                finally {
                                    if (fileInputStream != null) {
                                        fileInputStream.close();
                                    }
                                }
                            } else {
                                keyStore.load(new TmpLSParameter(BuilderImpl.this.protParameter));
                            }
                            return null;
                        }
                    }, this.accControlContext);
                    this.isGetKeyStore = true;
                    this.keyStore = keyStore;
                    return this.keyStore;
                }
                catch (KeyStoreException keyStoreException) {
                    this.lastException = keyStoreException;
                    throw this.lastException;
                }
                catch (Exception exception) {
                    this.lastException = new KeyStoreException(exception);
                    throw this.lastException;
                }
            }

            @Override
            public synchronized ProtectionParameter getProtectionParameter(String string) throws KeyStoreException {
                if (string == null) {
                    throw new NullPointerException(Messages.getString("security.3F"));
                }
                if (!this.isGetKeyStore) {
                    throw new IllegalStateException(Messages.getString("security.46"));
                }
                return this.protParameter;
            }
        }
    }
}

