/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.harmony.security.internal.nls.Messages;

public class KeyRep
implements Serializable {
    private static final long serialVersionUID = -4757683898830641853L;
    private final Type type;
    private final String algorithm;
    private final String format;
    private byte[] encoded;

    public KeyRep(Type type, String string, String string2, byte[] byArray) {
        this.type = type;
        this.algorithm = string;
        this.format = string2;
        this.encoded = byArray;
        if (this.type == null) {
            throw new NullPointerException(Messages.getString("security.07"));
        }
        if (this.algorithm == null) {
            throw new NullPointerException(Messages.getString("security.08"));
        }
        if (this.format == null) {
            throw new NullPointerException(Messages.getString("security.09"));
        }
        if (this.encoded == null) {
            throw new NullPointerException(Messages.getString("security.0A"));
        }
    }

    protected Object readResolve() throws ObjectStreamException {
        switch (this.type) {
            case SECRET: {
                if ("RAW".equals(this.format)) {
                    try {
                        return new SecretKeySpec(this.encoded, this.algorithm);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new NotSerializableException(Messages.getString("security.0B", illegalArgumentException));
                    }
                }
                throw new NotSerializableException(Messages.getString("security.0C", (Object)this.type, this.format));
            }
            case PUBLIC: {
                if ("X.509".equals(this.format)) {
                    try {
                        KeyFactory keyFactory = KeyFactory.getInstance(this.algorithm);
                        return keyFactory.generatePublic(new X509EncodedKeySpec(this.encoded));
                    }
                    catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                        throw new NotSerializableException(Messages.getString("security.0D", noSuchAlgorithmException));
                    }
                    catch (InvalidKeySpecException invalidKeySpecException) {
                        throw new NotSerializableException(Messages.getString("security.0D", invalidKeySpecException));
                    }
                }
                throw new NotSerializableException(Messages.getString("security.0C", (Object)this.type, this.format));
            }
            case PRIVATE: {
                if ("PKCS#8".equals(this.format)) {
                    try {
                        KeyFactory keyFactory = KeyFactory.getInstance(this.algorithm);
                        return keyFactory.generatePrivate(new PKCS8EncodedKeySpec(this.encoded));
                    }
                    catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                        throw new NotSerializableException(Messages.getString("security.0D", noSuchAlgorithmException));
                    }
                    catch (InvalidKeySpecException invalidKeySpecException) {
                        throw new NotSerializableException(Messages.getString("security.0D", invalidKeySpecException));
                    }
                }
                throw new NotSerializableException(Messages.getString("security.0C", (Object)this.type, this.format));
            }
        }
        throw new NotSerializableException(Messages.getString("security.0E", (Object)this.type));
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        byte[] byArray = new byte[this.encoded.length];
        System.arraycopy(this.encoded, 0, byArray, 0, byArray.length);
        this.encoded = byArray;
    }

    public static enum Type {
        SECRET,
        PUBLIC,
        PRIVATE;

    }
}

