/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import org.apache.harmony.security.fortress.Engine;
import org.apache.harmony.security.internal.nls.Messages;

public class KeyFactory {
    private static final String SERVICE = "KeyFactory";
    private Provider provider;
    private static Engine engine = new Engine("KeyFactory");
    private KeyFactorySpi spiImpl;
    private String algorithm;

    protected KeyFactory(KeyFactorySpi keyFactorySpi, Provider provider, String string) {
        this.provider = provider;
        this.algorithm = string;
        this.spiImpl = keyFactorySpi;
    }

    public static KeyFactory getInstance(String string) throws NoSuchAlgorithmException {
        if (string == null) {
            throw new NullPointerException(Messages.getString("security.01"));
        }
        Engine.ServiceResult serviceResult = engine.getInstance(string, null);
        return new KeyFactory((KeyFactorySpi)serviceResult.spi, serviceResult.provider, string);
    }

    public static KeyFactory getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (string2 == null || string2.length() == 0) {
            throw new IllegalArgumentException(Messages.getString("security.02"));
        }
        Provider provider = Security.getProvider(string2);
        if (provider == null) {
            throw new NoSuchProviderException(Messages.getString("security.03", string2));
        }
        return KeyFactory.getInstance(string, provider);
    }

    public static KeyFactory getInstance(String string, Provider provider) throws NoSuchAlgorithmException {
        if (provider == null) {
            throw new IllegalArgumentException(Messages.getString("security.04"));
        }
        if (string == null) {
            throw new NullPointerException(Messages.getString("security.01"));
        }
        Engine.ServiceResult serviceResult = engine.getInstance(string, provider, null);
        return new KeyFactory((KeyFactorySpi)serviceResult.spi, provider, string);
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public final PublicKey generatePublic(KeySpec keySpec) throws InvalidKeySpecException {
        return this.spiImpl.engineGeneratePublic(keySpec);
    }

    public final PrivateKey generatePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        return this.spiImpl.engineGeneratePrivate(keySpec);
    }

    public final <T extends KeySpec> T getKeySpec(Key key, Class<T> clazz) throws InvalidKeySpecException {
        return this.spiImpl.engineGetKeySpec(key, clazz);
    }

    public final Key translateKey(Key key) throws InvalidKeyException {
        return this.spiImpl.engineTranslateKey(key);
    }
}

