/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.security.BasicPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.apache.harmony.security.internal.nls.Messages;

final class BasicPermissionCollection
extends PermissionCollection {
    private static final long serialVersionUID = 739301742472979399L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("all_allowed", Boolean.TYPE), new ObjectStreamField("permissions", Hashtable.class), new ObjectStreamField("permClass", Class.class)};
    private transient Map<String, Permission> items = new HashMap<String, Permission>();
    private transient boolean allEnabled;
    private Class<? extends Permission> permClass;

    BasicPermissionCollection() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(Permission permission) {
        Object object;
        if (this.isReadOnly()) {
            throw new SecurityException(Messages.getString("security.15"));
        }
        if (permission == null) {
            throw new IllegalArgumentException(Messages.getString("security.20"));
        }
        Class<?> clazz = permission.getClass();
        if (this.permClass != null) {
            if (this.permClass != clazz) {
                throw new IllegalArgumentException(Messages.getString("security.16", permission));
            }
        } else {
            if (!(permission instanceof BasicPermission)) {
                throw new IllegalArgumentException(Messages.getString("security.16", permission));
            }
            object = this;
            synchronized (object) {
                if (this.permClass != null && clazz != this.permClass) {
                    throw new IllegalArgumentException(Messages.getString("security.16", permission));
                }
                this.permClass = clazz;
            }
        }
        object = permission.getName();
        this.items.put((String)object, permission);
        this.allEnabled = this.allEnabled || ((String)object).length() == 1 && '*' == ((String)object).charAt(0);
    }

    @Override
    public Enumeration<Permission> elements() {
        return Collections.enumeration(this.items.values());
    }

    @Override
    public boolean implies(Permission permission) {
        int n;
        if (permission == null || permission.getClass() != this.permClass) {
            return false;
        }
        if (this.allEnabled) {
            return true;
        }
        String string = permission.getName();
        if (this.items.containsKey(string)) {
            return true;
        }
        if (this.items.containsKey("exitVM") || this.items.containsKey("exitVM.*")) {
            if (string.endsWith("exitVM")) {
                return true;
            }
            if (string.startsWith("exitVM.") && string.length() > "exitVM.".length()) {
                return true;
            }
        }
        char[] cArray = string.toCharArray();
        for (n = cArray.length - 2; n >= 0 && cArray[n] != '.'; --n) {
        }
        while (n >= 0) {
            cArray[n + 1] = 42;
            if (this.items.containsKey(new String(cArray, 0, n + 2))) {
                return true;
            }
            --n;
            while (n >= 0 && cArray[n] != '.') {
                --n;
            }
        }
        return false;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        ObjectOutputStream.PutField putField = objectOutputStream.putFields();
        putField.put("all_allowed", this.allEnabled);
        putField.put("permissions", new Hashtable<String, Permission>(this.items));
        putField.put("permClass", this.permClass);
        objectOutputStream.writeFields();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        this.items = new HashMap<String, Permission>();
        BasicPermissionCollection basicPermissionCollection = this;
        synchronized (basicPermissionCollection) {
            this.permClass = (Class)getField.get("permClass", null);
            this.items.putAll((Hashtable)getField.get("permissions", new Hashtable()));
            Iterator<Permission> iterator = this.items.values().iterator();
            while (iterator.hasNext()) {
                if (iterator.next().getClass() == this.permClass) continue;
                throw new InvalidObjectException(Messages.getString("security.24"));
            }
            this.allEnabled = getField.get("all_allowed", false);
            if (this.allEnabled && !this.items.containsKey("*")) {
                throw new InvalidObjectException(Messages.getString("security.25"));
            }
        }
    }
}

