/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.security.AlgorithmParameterGeneratorSpi;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import org.apache.harmony.security.fortress.Engine;
import org.apache.harmony.security.internal.nls.Messages;

public class AlgorithmParameterGenerator {
    private static final String SERVICE = "AlgorithmParameterGenerator";
    private static Engine engine = new Engine("AlgorithmParameterGenerator");
    private static SecureRandom randm = new SecureRandom();
    private final Provider provider;
    private final AlgorithmParameterGeneratorSpi spiImpl;
    private final String algorithm;

    protected AlgorithmParameterGenerator(AlgorithmParameterGeneratorSpi algorithmParameterGeneratorSpi, Provider provider, String string) {
        this.provider = provider;
        this.algorithm = string;
        this.spiImpl = algorithmParameterGeneratorSpi;
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public static AlgorithmParameterGenerator getInstance(String string) throws NoSuchAlgorithmException {
        if (string == null) {
            throw new NullPointerException(Messages.getString("security.01"));
        }
        Engine.ServiceResult serviceResult = engine.getInstance(string, null);
        return new AlgorithmParameterGenerator((AlgorithmParameterGeneratorSpi)serviceResult.spi, serviceResult.provider, string);
    }

    public static AlgorithmParameterGenerator getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (string2 == null || string2.length() == 0) {
            throw new IllegalArgumentException(Messages.getString("security.02"));
        }
        Provider provider = Security.getProvider(string2);
        if (provider == null) {
            throw new NoSuchProviderException(string2);
        }
        return AlgorithmParameterGenerator.getInstance(string, provider);
    }

    public static AlgorithmParameterGenerator getInstance(String string, Provider provider) throws NoSuchAlgorithmException {
        if (provider == null) {
            throw new IllegalArgumentException(Messages.getString("security.04"));
        }
        if (string == null) {
            throw new NullPointerException(Messages.getString("security.01"));
        }
        Engine.ServiceResult serviceResult = engine.getInstance(string, provider, null);
        return new AlgorithmParameterGenerator((AlgorithmParameterGeneratorSpi)serviceResult.spi, provider, string);
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final void init(int n) {
        this.spiImpl.engineInit(n, randm);
    }

    public final void init(int n, SecureRandom secureRandom) {
        this.spiImpl.engineInit(n, secureRandom);
    }

    public final void init(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        this.spiImpl.engineInit(algorithmParameterSpec, randm);
    }

    public final void init(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        this.spiImpl.engineInit(algorithmParameterSpec, secureRandom);
    }

    public final AlgorithmParameters generateParameters() {
        return this.spiImpl.engineGenerateParameters();
    }
}

