/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.j9.dump.systemdump;

import com.ibm.jvm.j9.dump.systemdump.Dump;
import com.ibm.jvm.j9.dump.systemdump.GenericThread;
import com.ibm.jvm.j9.dump.systemdump.J9AddressSpace;
import com.ibm.jvm.j9.dump.systemdump.J9Process;
import com.ibm.jvm.j9.dump.systemdump.MemoryRange;
import com.ibm.jvm.j9.dump.systemdump.NativeThreadContext;
import com.ibm.jvm.j9.dump.systemdump.Register;
import com.ibm.jvm.j9.dump.systemdump.StackFrame;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Vector;

public class Windump
extends Dump {
    private static MinidumpHeader minidumpHeader;
    private static MinidumpDirectoryElement[] minidumpDirectoryElements;
    private static boolean verbose;
    private static int numberOfThreads;
    private static int numberOfModules;
    private static long numberOfMemoryRanges;
    private static MinidumpThread[] minidumpThreads;
    private static MinidumpModule[] minidumpModules;
    private static MemoryRange[] memoryRanges;
    private static long baseRva;
    private static boolean isMiniDump;
    private static boolean isWindowsDump;
    private static Vector debugFiles;
    private static final long PEBADDRESS = 2147348480L;
    private static final int INFOBLOCKADDRESSOFFSET = 16;
    private static final int COMMANDLINEADDRESSOFFSET = 68;
    private static final int COMMANDLINELENGTHADDRESSOFFSET = 64;
    private static final long PEB64ADDRESS = 0L;
    private static final String[] regNames;
    private static final String[] regNames64;
    int regNames64Count = regNames64.length;
    int regNamesCount = regNames.length;

    public static boolean isSupportedDump(RandomAccessFile raf) {
        byte[] signature1 = new byte[4];
        byte[] signature2 = new byte[4];
        boolean bRet = false;
        try {
            raf.seek(0L);
            raf.read(signature1);
            String s = new String(signature1);
            if (s.toUpperCase().equals("MDMP")) {
                bRet = true;
            }
        }
        catch (IOException ioe) {
            // empty catch block
        }
        return bRet;
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println("\nUsage: java WinDump filename\n");
            System.exit(1);
        }
        verbose = true;
        try {
            new Windump(args[0]);
        }
        catch (FileNotFoundException fnfe) {
            System.err.println("\n File \"" + args[0] + "\" not found.");
            System.exit(1);
        }
    }

    public Windump(String filename) throws FileNotFoundException {
        super(filename);
        bIsLittleEndian = true;
        this.setSystemType(1);
        minidumpHeader = new MinidumpHeader();
        this.addressSpaces = new J9AddressSpace[1];
        this.addressSpaces[0] = new J9AddressSpace("WinAS", this, 0);
        J9Process proc = new J9Process("WinProc", 0);
        this.addressSpaces[0].addProcess(proc);
        if (isMiniDump) {
            this.dumpTime = Windump.minidumpHeader.timeDateStamp;
            this.processMdStreams(minidumpHeader);
        } else {
            this.processUdStreams();
        }
        proc.setCmdLine(this.findCommandLine());
    }

    public static String getStringFromBytes(byte[] b) {
        StringBuffer str = new StringBuffer();
        if (null == b) {
            return "bad string";
        }
        for (int i = 0; i < b.length && b[i] != 0 && b[0] != 0; ++i) {
            str.append((char)b[i]);
        }
        return str.toString();
    }

    private String getModuleName(int position) {
        String retString = "????";
        long currentPos = 0L;
        try {
            currentPos = this.getFilePointer();
            this.seek(position);
            int length = Windump.convertEndian(this.readInt());
            if (length >= 512 || length <= 0) {
                length = 512;
            }
            byte[] nameWide = new byte[length];
            this.read(nameWide);
            byte[] nameThin = new byte[length / 2];
            for (int i = 0; i < length / 2; ++i) {
                nameThin[i] = nameWide[2 * i];
            }
            retString = new String(nameThin);
            this.seek(currentPos);
        }
        catch (IOException ioe) {
            System.err.println("IOError in getModuleName");
        }
        return retString;
    }

    protected static final short convertEndian(short in) {
        int in1 = in & 0xFFFF;
        int high = in1 << 8;
        int low = in1 >>> 8;
        short ret = (short)(high + low);
        return ret;
    }

    protected static final int convertEndian(int in) {
        return in >>> 24 | in << 24 | in << 8 & 0xFF0000 | in >> 8 & 0xFF00;
    }

    public static long longFromBytes(byte[] b, boolean flip) {
        long retLong = 0L;
        if (b.length != 8) {
            System.err.println("Invalid use of longFromBytes - 0 returned");
            return retLong;
        }
        byte[] flippedBytes = new byte[]{b[0], b[1], b[2], b[3], b[4], b[5], b[6], b[7]};
        if (flip) {
            flippedBytes[0] = b[7];
            flippedBytes[1] = b[6];
            flippedBytes[2] = b[5];
            flippedBytes[3] = b[4];
            flippedBytes[4] = b[3];
            flippedBytes[5] = b[2];
            flippedBytes[6] = b[1];
            flippedBytes[7] = b[0];
        }
        for (int i = 0; i < 8; ++i) {
            retLong <<= 8;
            if (flippedBytes[i] < 0) {
                retLong = retLong + (long)flippedBytes[i] + 256L;
                continue;
            }
            retLong += (long)flippedBytes[i];
        }
        return retLong;
    }

    private void processUdStreams() {
        UserdumpHeader udHeader = new UserdumpHeader();
        this.processUdMemory(udHeader);
    }

    private void processMdStreams(MinidumpHeader mdh) {
        int i;
        try {
            this.seek(mdh.streamDirectoryRva);
            minidumpDirectoryElements = new MinidumpDirectoryElement[mdh.numberOfStreams];
            for (i = 0; i < mdh.numberOfStreams; ++i) {
                Windump.minidumpDirectoryElements[i] = new MinidumpDirectoryElement();
                Windump.minidumpDirectoryElements[i].streamType = Windump.convertEndian(this.readInt());
                Windump.minidumpDirectoryElements[i].dataSize = Windump.convertEndian(this.readInt());
                Windump.minidumpDirectoryElements[i].location = Windump.convertEndian(this.readInt());
                if (!verbose) continue;
                System.err.println("Stream Type:" + Windump.minidumpDirectoryElements[i].streamType + "\tdataSize: " + Windump.minidumpDirectoryElements[i].dataSize + "\tlocation: " + Windump.minidumpDirectoryElements[i].location + "\tdescription: " + MinidumpStreamTypes.getDescription(Windump.minidumpDirectoryElements[i].streamType));
            }
        }
        catch (IOException e) {
            System.err.println(" IOException whilst locating minidump streams");
            System.exit(1);
        }
        block11: for (i = 0; i < mdh.numberOfStreams; ++i) {
            switch (Windump.minidumpDirectoryElements[i].streamType) {
                case 9: {
                    this.processMemory64(i);
                    continue block11;
                }
                case 7: {
                    this.processSystemInfo(i);
                }
            }
        }
        block12: for (i = 0; i < mdh.numberOfStreams; ++i) {
            switch (Windump.minidumpDirectoryElements[i].streamType) {
                case 3: {
                    this.processThreads(i);
                    continue block12;
                }
                case 4: {
                    this.processModules(i);
                    continue block12;
                }
            }
        }
    }

    private void processThreads(int dirElement) {
        try {
            this.seek(Windump.minidumpDirectoryElements[dirElement].location);
            numberOfThreads = Windump.convertEndian(this.readInt());
            minidumpThreads = new MinidumpThread[numberOfThreads];
            if (verbose) {
                System.err.println("Number of threads = " + numberOfThreads);
            }
            for (int i = 0; i < numberOfThreads; ++i) {
                Windump.minidumpThreads[i] = new MinidumpThread();
                Windump.minidumpThreads[i].threadId = Windump.convertEndian(this.readInt());
                Windump.minidumpThreads[i].suspendCount = Windump.convertEndian(this.readInt());
                Windump.minidumpThreads[i].priorityClass = Windump.convertEndian(this.readInt());
                Windump.minidumpThreads[i].priority = Windump.convertEndian(this.readInt());
                byte[] temp = new byte[8];
                this.read(temp);
                Windump.minidumpThreads[i].teb = Windump.longFromBytes(temp, true);
                this.read(temp);
                Windump.minidumpThreads[i].stackStartOfMemoryRange = Windump.longFromBytes(temp, true);
                Windump.minidumpThreads[i].stackDataSize = Windump.convertEndian(this.readInt());
                Windump.minidumpThreads[i].stackRva = Windump.convertEndian(this.readInt());
                Windump.minidumpThreads[i].contextDataSize = Windump.convertEndian(this.readInt());
                Windump.minidumpThreads[i].contextRva = Windump.convertEndian(this.readInt());
                if (verbose) {
                    System.err.println("Thread id: 0x" + Integer.toHexString(Windump.minidumpThreads[i].threadId));
                }
                GenericThread gt = new GenericThread("0x" + Integer.toHexString(Windump.minidumpThreads[i].threadId), Windump.minidumpThreads[i].stackStartOfMemoryRange, Windump.minidumpThreads[i].stackDataSize, Windump.minidumpThreads[i].stackRva);
                this.addressSpaces[0].getProcess(0).addThread(gt);
                if (this.bIs32Bit) {
                    this.createRegisters(gt, Windump.minidumpThreads[i].contextRva);
                } else {
                    this.createRegisters64(gt, Windump.minidumpThreads[i].contextRva);
                }
                Register ebpReg = gt.getNamedRegister("ebp");
                Register espReg = gt.getNamedRegister("esp");
                this.analyseStack(gt, ebpReg, espReg);
            }
        }
        catch (IOException ioe) {
            System.err.println(" IOERROR in processThreads");
            System.exit(1);
        }
    }

    private void analyseStack(GenericThread gt, Register ebpReg, Register esp) {
        if (null == gt || null == ebpReg || null == esp) {
            return;
        }
        int stacksize = gt.getStacksize();
        long stackAddress = gt.getStackstart();
        if (ebpReg.value < stackAddress) {
            return;
        }
        long currentPos = 0L;
        try {
            currentPos = this.getFilePointer();
            byte[] memBytes = this.getMemoryBytes(stackAddress, stacksize);
            boolean bFinished = false;
            int offset = 0;
            long retAddr = -1L;
            long previous = esp.value - (long)(ebpReg.size / 8);
            offset = (int)(esp.value - stackAddress);
            if (offset >= 0) {
                retAddr = this.readPtr(memBytes, offset);
            }
            gt.addNativeFrame(new StackFrame(previous, retAddr));
            previous = ebpReg.value;
            while (!bFinished) {
                offset = (int)(previous - stackAddress);
                if (offset < 0 || offset > stacksize) {
                    bFinished = true;
                    continue;
                }
                long newPrevious = this.readPtr(memBytes, offset);
                retAddr = this.readPtr(memBytes, offset += ebpReg.size / 8);
                gt.addNativeFrame(new StackFrame(previous, retAddr));
                if (previous == 0L || newPrevious < stackAddress && newPrevious == 0L || newPrevious > stackAddress + (long)stacksize) {
                    bFinished = true;
                }
                previous = newPrevious;
            }
            this.seek(currentPos);
        }
        catch (Exception e) {
            try {
                this.seek(currentPos);
            }
            catch (IOException ioe1) {
                // empty catch block
            }
        }
    }

    private void createRegisters(GenericThread gt, long contextRva) {
        try {
            long savedPosition = this.getFilePointer();
            this.seek(contextRva);
            for (int i = 0; i < this.regNamesCount; ++i) {
                Register r = new Register(regNames[i], 32, Windump.convertEndian(this.readInt()));
                gt.addRegister(r);
            }
            this.seek(savedPosition);
        }
        catch (IOException ioe) {
            // empty catch block
        }
        gt.context = new NativeThreadContext(32, 0L, gt.getNamedRegister("eip").getValue(), 0L, gt.getNamedRegister("esp").getValue(), gt.getNamedRegister("ebp").getValue());
    }

    private void createRegisters64(GenericThread gt, long contextRva) {
        try {
            long savedPosition = this.getFilePointer();
            this.seek(contextRva + 56L);
            for (int i = 0; i < 6; ++i) {
                Register r1 = new Register(regNames64[i], 16, Windump.convertEndian(this.readShort()));
                gt.addRegister(r1);
            }
            Register r = new Register(regNames64[6], 32, Windump.convertEndian(this.readInt()));
            gt.addRegister(r);
            this.seek(this.getFilePointer() + 48L);
            for (int i = 0; i < 16; ++i) {
                Register r1 = new Register(regNames64[i + 7], 64, this.readLongEx());
                gt.addRegister(r1);
            }
            this.seek(savedPosition);
        }
        catch (IOException ioe) {
            // empty catch block
        }
        gt.context = null;
    }

    private void processSystemInfo(int dirElement) {
        try {
            byte bProductType;
            this.seek(Windump.minidumpDirectoryElements[dirElement].location);
            short processorArchitecture = Windump.convertEndian(this.readShort());
            short ProcessorLevel = Windump.convertEndian(this.readShort());
            short ProcessorRevision = Windump.convertEndian(this.readShort());
            byte bNumberOfProcessors = this.readByte();
            this.processorCount = bNumberOfProcessors;
            byte productType = bProductType = this.readByte();
            this.processorType = processorArchitecture < 0 || processorArchitecture > MinidumpConstants.PROCESSOR_ARCH_STRING.length - 1 ? MinidumpConstants.PROCESSOR_ARCH_STRING[0] : MinidumpConstants.PROCESSOR_ARCH_STRING[processorArchitecture + 1];
            this.bIs32Bit = true;
            if (9 == processorArchitecture || 6 == processorArchitecture || 7 == processorArchitecture || 10 == processorArchitecture) {
                this.bIs32Bit = false;
            }
        }
        catch (IOException ioe) {
            System.err.println(" IOERROR in processSystemInfo");
            System.exit(1);
        }
    }

    private void processModules(int dirElement) {
        try {
            this.seek(Windump.minidumpDirectoryElements[dirElement].location);
            numberOfModules = Windump.convertEndian(this.readInt());
            minidumpModules = new MinidumpModule[numberOfModules];
            for (int i = 0; i < numberOfModules; ++i) {
                Windump.minidumpModules[i] = new MinidumpModule();
                byte[] temp = new byte[8];
                this.read(temp);
                Windump.minidumpModules[i].baseOfImage = Windump.longFromBytes(temp, true);
                Windump.minidumpModules[i].sizeOfImage = Windump.convertEndian(this.readInt());
                Windump.minidumpModules[i].checkSum = Windump.convertEndian(this.readInt());
                Windump.minidumpModules[i].timeDateStamp = Windump.convertEndian(this.readInt());
                Windump.minidumpModules[i].moduleNameRva = Windump.convertEndian(this.readInt());
                Windump.minidumpModules[i].moduleName = this.getModuleName(Windump.minidumpModules[i].moduleNameRva);
                Windump.minidumpModules[i].versionInfoDwSignature = Windump.convertEndian(this.readInt());
                Windump.minidumpModules[i].versionInfoDwStrucVersion = Windump.convertEndian(this.readInt());
                Windump.minidumpModules[i].versionInfoDwFileVersionMS = Windump.convertEndian(this.readInt());
                Windump.minidumpModules[i].versionInfoDwFileVersionLS = Windump.convertEndian(this.readInt());
                Windump.minidumpModules[i].versionInfoDwProductVersionMS = Windump.convertEndian(this.readInt());
                Windump.minidumpModules[i].versionInfoDwProductVersionLS = Windump.convertEndian(this.readInt());
                Windump.minidumpModules[i].versionInfoDwFileFlagsMask = Windump.convertEndian(this.readInt());
                Windump.minidumpModules[i].versionInfoDwFileFlags = Windump.convertEndian(this.readInt());
                Windump.minidumpModules[i].versionInfoDwFileOS = Windump.convertEndian(this.readInt());
                Windump.minidumpModules[i].versionInfoDwFileType = Windump.convertEndian(this.readInt());
                Windump.minidumpModules[i].versionInfoDwFileSubtype = Windump.convertEndian(this.readInt());
                Windump.minidumpModules[i].versionInfoDwFileDateMS = Windump.convertEndian(this.readInt());
                Windump.minidumpModules[i].versionInfoDwFileDateLS = Windump.convertEndian(this.readInt());
                Windump.minidumpModules[i].cvRecordDataSize = Windump.convertEndian(this.readInt());
                Windump.minidumpModules[i].cvRecordDataRva = Windump.convertEndian(this.readInt());
                Windump.minidumpModules[i].miscRecordDataSize = Windump.convertEndian(this.readInt());
                Windump.minidumpModules[i].miscRecordDataRva = Windump.convertEndian(this.readInt());
                this.read(temp);
                this.read(temp);
            }
        }
        catch (IOException e) {
            System.err.println(" IOERROR in processModules");
            System.exit(1);
        }
        J9AddressSpace as = this.getAddressSpace(this.getCurrentAS());
        J9Process proc = as.getProcess(as.getCurrentProcess());
        for (int i = 0; i < numberOfModules; ++i) {
            proc.addModule(numberOfModules, i, Windump.minidumpModules[i].moduleName, Windump.minidumpModules[i].baseOfImage, Windump.minidumpModules[i].sizeOfImage);
        }
    }

    private void processUdMemory(UserdumpHeader udh) {
        long baseAddress = 0L;
        long allocationBase = 0L;
        int allocationProtect = 0;
        int regionSize = 0;
        int state = 0;
        int protect = 0;
        int type = 0;
        try {
            int i;
            this.seek(udh.regionOffset);
            memoryRanges = new MemoryRange[udh.regionCount];
            boolean newRangeRqd = true;
            int j = 0;
            for (i = 0; i < udh.regionCount; ++i) {
                baseAddress = Windump.convertEndian(this.readInt());
                allocationBase = Windump.convertEndian(this.readInt());
                allocationProtect = Windump.convertEndian(this.readInt());
                regionSize = Windump.convertEndian(this.readInt());
                state = Windump.convertEndian(this.readInt());
                protect = Windump.convertEndian(this.readInt());
                type = Windump.convertEndian(this.readInt());
                if (newRangeRqd) {
                    Windump.memoryRanges[j] = new MemoryRange();
                }
                newRangeRqd = false;
                if (0 == j) {
                    memoryRanges[j].setVaddr(baseAddress);
                    memoryRanges[j].setFileoffset(udh.dataOffset);
                    memoryRanges[j].setSize(regionSize);
                    ++j;
                    newRangeRqd = true;
                    continue;
                }
                if (memoryRanges[j - 1].getVaddr() + memoryRanges[j - 1].getSize() == baseAddress) {
                    memoryRanges[j - 1].setSize(memoryRanges[j - 1].getSize() + (long)regionSize);
                    continue;
                }
                memoryRanges[j].setFileoffset(memoryRanges[j - 1].getFileoffset() + memoryRanges[j - 1].getSize());
                memoryRanges[j].setVaddr(baseAddress);
                memoryRanges[j].setSize(regionSize);
                ++j;
                newRangeRqd = true;
            }
            numberOfMemoryRanges = j;
            memoryRanges = this.reformMemoryRanges(memoryRanges, (int)numberOfMemoryRanges);
            if (verbose) {
                System.err.println("True number of memory sections = " + numberOfMemoryRanges);
                i = 0;
                while ((long)i < numberOfMemoryRanges) {
                    System.err.println("Memory: 0x" + Long.toHexString(memoryRanges[i].getVaddr()) + "  \tlength: " + memoryRanges[i].getSize() + " bytes    \toffsetInFile: 0x" + Long.toHexString(memoryRanges[i].getFileoffset()));
                    ++i;
                }
            }
        }
        catch (IOException ioe) {
            System.err.println(" IOERROR in processUdMemory");
            System.exit(1);
        }
    }

    private void processMemory64(int dirElement) {
        try {
            this.seek(Windump.minidumpDirectoryElements[dirElement].location);
            byte[] temp = new byte[8];
            this.read(temp);
            numberOfMemoryRanges = Windump.longFromBytes(temp, true);
            this.read(temp);
            baseRva = Windump.longFromBytes(temp, true);
            memoryRanges = new MemoryRange[(int)numberOfMemoryRanges];
            long size = 0L;
            long start = 0L;
            int j = 0;
            boolean newRangeRqd = true;
            int i = 0;
            while ((long)i < numberOfMemoryRanges) {
                if (newRangeRqd) {
                    Windump.memoryRanges[j] = new MemoryRange();
                }
                newRangeRqd = false;
                this.read(temp);
                start = Windump.longFromBytes(temp, true);
                this.read(temp);
                size = Windump.longFromBytes(temp, true);
                if (0 == j) {
                    memoryRanges[j].setVaddr(start);
                    memoryRanges[j].setFileoffset(baseRva);
                    memoryRanges[j].setSize(size);
                    ++j;
                    newRangeRqd = true;
                } else if (memoryRanges[j - 1].getVaddr() + memoryRanges[j - 1].getSize() == start) {
                    memoryRanges[j - 1].setSize(memoryRanges[j - 1].getSize() + size);
                } else {
                    memoryRanges[j].setFileoffset(memoryRanges[j - 1].getFileoffset() + memoryRanges[j - 1].getSize());
                    memoryRanges[j].setVaddr(start);
                    memoryRanges[j].setSize(size);
                    ++j;
                    newRangeRqd = true;
                }
                ++i;
            }
            numberOfMemoryRanges = j;
            memoryRanges = this.reformMemoryRanges(memoryRanges, (int)numberOfMemoryRanges);
            if (verbose) {
                System.err.println("True number of memory sections = " + numberOfMemoryRanges);
                i = 0;
                while ((long)i < numberOfMemoryRanges) {
                    System.err.println("Memory: 0x" + Long.toHexString(memoryRanges[i].getVaddr()) + "  \tlength: " + memoryRanges[i].getSize() + " bytes    \toffsetInFile: 0x" + Long.toHexString(memoryRanges[i].getFileoffset()));
                    ++i;
                }
            }
        }
        catch (IOException e) {
            System.err.println(" IOERROR in processMemory64");
            System.exit(1);
        }
    }

    private MemoryRange[] reformMemoryRanges(MemoryRange[] inArray, int count) {
        MemoryRange[] retArray = new MemoryRange[count];
        for (int i = 0; i < count; ++i) {
            retArray[i] = inArray[i];
        }
        return retArray;
    }

    protected MemoryRange[] getRawMemoryRanges() {
        return memoryRanges;
    }

    private String findCommandLine() {
        String retString = "!!! Cannot establish Command Line !!!";
        try {
            long infoBlockAddr = this.readPtr(2147348496L);
            if (-1L != infoBlockAddr && 0L != this.seekToMemoryAddress(infoBlockAddr + 64L)) {
                long commandLineAddr;
                int length = this.readShortEx();
                short maxLength = this.readShortEx();
                if (length > 1024) {
                    length = 1024;
                }
                if (length > 0 && -1L != (commandLineAddr = this.readPtr(infoBlockAddr + 68L)) && 0L != this.seekToMemoryAddress(commandLineAddr)) {
                    char[] cmdLine = new char[length / 2];
                    for (int i = 0; i < length / 2; ++i) {
                        cmdLine[i] = (char)Windump.convertEndian(this.readShort());
                    }
                    retString = new String(cmdLine);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return retString;
    }

    public static Vector findDebugFiles(String execNameOverRide, Dump core, boolean createModules) {
        if (debugFiles != null) {
            return debugFiles;
        }
        debugFiles = new Vector();
        for (int i = 0; i < numberOfModules; ++i) {
            String x = Windump.minidumpModules[i].moduleName;
            debugFiles.add(x);
        }
        return debugFiles;
    }

    static {
        verbose = false;
        debugFiles = null;
        regNames = new String[]{"contextFlags", "dr0", "dr1", "dr2", "dr3", "dr6", "dr7", "80387ControlWord", "80387StatusWord", "80387TagWord", "80387ErrorOffset", "80387ErrorSelector", "80387DataOffset", "80387DataSelector", "80387R0", "80387R1", "80387R2", "80387R3", "80387R4", "80387R5", "80387R6", "80387R7", "80387R8", "80387R9", "80387R10", "80387R11", "80387R12", "80387R13", "80387R14", "80387R15", "80387R16", "80387R17", "80387R18", "80387R19", "Cr0NpxState", "SegGs", "SegFs", "SegEs", "SegDs", "edi", "esi", "ebx", "edx", "ecx", "eax", "ebp", "eip", "SegCs", "eFlags", "esp", "SegSs"};
        regNames64 = new String[]{"SegCs", "SegDs", "SegEs", "SegFS", "SegGs", "SegSS", "EFlags", "Rax", "Rcx", "Rdx", "Rbx", "Rsp", "Rbp", "Rsi", "Rdi", "R8", "R9", "R10", "R11", "R12", "R13", "R14", "R15"};
        Dump.registerDumpSupport(Windump.class);
    }

    static final class MinidumpStreamTypes {
        static final int UNUSED = 0;
        static final int RESERVED0 = 1;
        static final int RESERVED1 = 2;
        static final int THREADLIST = 3;
        static final int MODULELIST = 4;
        static final int MEMORYLIST = 5;
        static final int EXCEPTIONLIST = 6;
        static final int SYSTEMINFO = 7;
        static final int THREADEXLIST = 8;
        static final int MEMORY64LIST = 9;
        static final int COMMENTSTREAMA = 10;
        static final int COMMENTSTREAMW = 11;
        static final int HANDLEDATA = 12;
        static final int FUNCTIONTABLE = 13;
        static final String[] descriptions = new String[]{"UNUSED", "RESERVED0", "RESERVED1", "THREADLIST", "MODULELIST", "MEMORYLIST", "EXCEPTIONLIST", "SYSTEMINFO", "THREADEXLIST", "MEMORY64LIST", "COMMENTSTREAMA", "COMMENTSTREAMW", "HANDLEDATA", "FUNCTIONTABLE"};

        MinidumpStreamTypes() {
        }

        static final String getDescription(int i) {
            if (i < 0 | i >= descriptions.length) {
                return " !!! Unrecognised Stream !!!";
            }
            return descriptions[i];
        }
    }

    static final class MinidumpConstants {
        static final int PROCESSOR_ARCHITECTURE_INTEL = 0;
        static final int PROCESSOR_ARCHITECTURE_MIPS = 1;
        static final int PROCESSOR_ARCHITECTURE_ALPHA = 2;
        static final int PROCESSOR_ARCHITECTURE_PPC = 3;
        static final int PROCESSOR_ARCHITECTURE_SHX = 4;
        static final int PROCESSOR_ARCHITECTURE_ARM = 5;
        static final int PROCESSOR_ARCHITECTURE_IA64 = 6;
        static final int PROCESSOR_ARCHITECTURE_ALPHA64 = 7;
        static final int PROCESSOR_ARCHITECTURE_MSIL = 8;
        static final int PROCESSOR_ARCHITECTURE_AMD64 = 9;
        static final int PROCESSOR_ARCHITECTURE_IA32_ON_WIN64 = 10;
        static final String[] PROCESSOR_ARCH_STRING = new String[]{"unknown", "Intel", "MIPS", "ALPHA", "PPC", "SHX", "ARM", "IA64", "ALPHA64", "MSIL", "AMD64", "IA32_ON_WIN64"};

        MinidumpConstants() {
        }
    }

    class UserdumpHeader {
        byte[] signature = new byte[8];
        int unknown1;
        int unknown2;
        int unknown3;
        int threadCount;
        int moduleCount;
        int regionCount;
        long contextOffset;
        long moduleOffset;
        long dataOffset;
        long regionOffset;
        long debugOffset;
        long threadOffset;
        long versionInfoOffset;

        UserdumpHeader() {
            try {
                Windump.this.seek(0L);
                Windump.this.read(this.signature);
                this.unknown1 = Windump.convertEndian(Windump.this.readInt());
                this.unknown2 = Windump.convertEndian(Windump.this.readInt());
                this.unknown3 = Windump.convertEndian(Windump.this.readInt());
                this.threadCount = Windump.convertEndian(Windump.this.readInt());
                this.moduleCount = Windump.convertEndian(Windump.this.readInt());
                this.regionCount = Windump.convertEndian(Windump.this.readInt());
                this.contextOffset = Windump.convertEndian(Windump.this.readInt());
                this.moduleOffset = Windump.convertEndian(Windump.this.readInt());
                this.dataOffset = Windump.convertEndian(Windump.this.readInt());
                this.regionOffset = Windump.convertEndian(Windump.this.readInt());
                this.debugOffset = Windump.convertEndian(Windump.this.readInt());
                this.threadOffset = Windump.convertEndian(Windump.this.readInt());
                this.versionInfoOffset = Windump.convertEndian(Windump.this.readInt());
                if (verbose) {
                    String s = new String(this.signature);
                    System.err.println("Sig: " + s + "  threads: " + this.threadCount + " threadOffset: 0x" + Long.toHexString(this.threadOffset) + "\nregions: " + this.regionCount + " regionOffset: 0x" + Long.toHexString(this.regionOffset) + " dataOffset: 0x" + Long.toHexString(this.dataOffset));
                }
            }
            catch (IOException ioe) {
                System.err.println("IOException");
            }
        }
    }

    class MinidumpHeader {
        byte[] signature = new byte[4];
        int version;
        int numberOfStreams;
        long streamDirectoryRva;
        int checkSum;
        int timeDateStamp;

        MinidumpHeader() {
            try {
                Windump.this.read(this.signature);
                String s = new String(this.signature);
                if (s.toUpperCase().equals("MDMP")) {
                    isMiniDump = true;
                    isWindowsDump = true;
                    this.version = Windump.convertEndian(Windump.this.readInt());
                    this.numberOfStreams = Windump.convertEndian(Windump.this.readInt());
                    this.streamDirectoryRva = Windump.convertEndian(Windump.this.readInt());
                    this.checkSum = Windump.convertEndian(Windump.this.readInt());
                    this.timeDateStamp = Windump.convertEndian(Windump.this.readInt());
                } else {
                    Windump.this.seek(0L);
                    this.signature = new byte[8];
                    Windump.this.read(this.signature);
                    s = new String(this.signature);
                    if (s.toUpperCase().equals("USERDUMP")) {
                        isMiniDump = false;
                        isWindowsDump = true;
                    } else {
                        isWindowsDump = false;
                    }
                }
            }
            catch (IOException ioe) {
                System.err.println("IOException");
            }
        }
    }

    class MinidumpDirectoryElement {
        int streamType;
        int dataSize;
        int location;

        MinidumpDirectoryElement() {
        }
    }

    class MinidumpThread {
        int threadId;
        int suspendCount;
        int priorityClass;
        int priority;
        long teb;
        long stackStartOfMemoryRange;
        int stackDataSize;
        int stackRva;
        int contextDataSize;
        int contextRva;

        MinidumpThread() {
        }
    }

    class MinidumpModule {
        long baseOfImage;
        int sizeOfImage;
        int checkSum;
        int timeDateStamp;
        int moduleNameRva;
        String moduleName;
        int versionInfoDwSignature;
        int versionInfoDwStrucVersion;
        int versionInfoDwFileVersionMS;
        int versionInfoDwFileVersionLS;
        int versionInfoDwProductVersionMS;
        int versionInfoDwProductVersionLS;
        int versionInfoDwFileFlagsMask;
        int versionInfoDwFileFlags;
        int versionInfoDwFileOS;
        int versionInfoDwFileType;
        int versionInfoDwFileSubtype;
        int versionInfoDwFileDateMS;
        int versionInfoDwFileDateLS;
        int cvRecordDataSize;
        int cvRecordDataRva;
        int miscRecordDataSize;
        int miscRecordDataRva;
        long reserved0;
        long reserved1;

        MinidumpModule() {
        }
    }
}

