/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.j9.dump.systemdump;

import com.ibm.jvm.j9.dump.commandconsole.Console;
import com.ibm.jvm.j9.dump.commandconsole.DumpConsole;
import com.ibm.jvm.j9.dump.commandconsole.DumpUtils;
import com.ibm.jvm.j9.dump.commandconsole.J9JVMConsole;
import com.ibm.jvm.j9.dump.commandconsole.J9JVMUtils;
import com.ibm.jvm.j9.dump.systemdump.ClassField;
import com.ibm.jvm.j9.dump.systemdump.Dump;
import com.ibm.jvm.j9.dump.systemdump.J9ConstantPool;
import com.ibm.jvm.j9.dump.systemdump.J9FieldIterator;
import com.ibm.jvm.j9.dump.systemdump.J9Method;
import com.ibm.jvm.j9.dump.systemdump.J9Static;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;

public class J9Class {
    private static int ptrSize = 0;
    private Vector fields;
    private Vector methods;
    private Vector statics;
    private int modifiers;
    private String name;
    private String id;
    private long address;
    private String superId;
    private int instanceSize;
    private String loader;
    private boolean isLittleEndian;
    private Vector inheritanceChain;
    private boolean bInheritanceChainProcessed;
    private boolean isArrayClass;
    private J9ArrayClass arrayClass = null;
    private static ArrayList arrayClassReworkList = new ArrayList();
    private J9ConstantPool constantPool;
    private Vector interfaces;
    private boolean isPrimitiveClass;
    private byte primitiveClassType;
    private int arrayElementSize = 0;
    public static final String[] primativeClasses = new String[]{"boolean", "char", "float", "double", "byte", "short", "int", "long"};
    private static final int[] primativeSizes = new int[]{1, 2, 4, 8, 1, 2, 4, 8};
    private static final byte[] primativeTypes = new byte[]{0, 1, 2, 3, 4, 5, 6, 7};
    private int[] referenceOffsets;
    private boolean bRefOffsetsProcessed = false;

    public J9Class(String nameIn, String idIn, String superIn, String instanceSizeIn, String loaderIn, String modifiersIn) {
        this.name = nameIn;
        if (-1 == this.name.indexOf(47)) {
            this.arrayElementSize = this.testPrimitive();
            if (0 != this.arrayElementSize) {
                this.isPrimitiveClass = true;
                this.primitiveClassType = this.setPrimitiveClassType();
            } else {
                this.arrayElementSize = -1;
            }
        } else {
            this.arrayElementSize = -1;
        }
        this.id = idIn;
        this.address = DumpUtils.parseLongHex(DumpUtils.stripOff0x(this.id));
        this.superId = superIn;
        this.instanceSize = Integer.parseInt(instanceSizeIn);
        this.loader = loaderIn;
        this.fields = new Vector();
        this.methods = new Vector();
        this.statics = new Vector();
        this.interfaces = new Vector();
        this.isLittleEndian = DumpConsole.getTheDump().isLittleEndian();
        if (modifiersIn != null) {
            if ((modifiersIn = DumpUtils.stripOff0x(modifiersIn)).length() == 8) {
                modifiersIn = modifiersIn.substring(1);
            }
            this.modifiers = Integer.parseInt(modifiersIn, 16);
        }
    }

    protected J9Class(String nameIn, String idIn, String superIn, String instanceSizeIn, String loaderIn, boolean isLittleEndianIn) {
        this.name = nameIn;
        this.id = idIn;
        this.address = DumpUtils.parseLongHex(DumpUtils.stripOff0x(this.id));
        this.superId = superIn;
        this.instanceSize = Integer.parseInt(instanceSizeIn);
        this.loader = loaderIn;
        this.fields = new Vector();
        this.methods = new Vector();
        this.statics = new Vector();
        this.isLittleEndian = isLittleEndianIn;
    }

    public J9Class(String nameIn, String idIn, String leaf, String arity, String firstElementOffset, String sizeOffset, String sizeBytes, boolean bSizedAsElements, String modifiersIn) {
        this.name = nameIn;
        this.id = idIn;
        if (modifiersIn != null) {
            if ((modifiersIn = DumpUtils.stripOff0x(modifiersIn)).length() == 8) {
                modifiersIn = modifiersIn.substring(1);
            }
            this.modifiers = Integer.parseInt(modifiersIn, 16);
        }
        this.address = DumpUtils.parseLongHex(DumpUtils.stripOff0x(this.id));
        this.isLittleEndian = DumpConsole.getTheDump().isLittleEndian();
        this.arrayClass = new J9ArrayClass(leaf, arity, firstElementOffset, sizeOffset, sizeBytes, bSizedAsElements, this);
        this.isArrayClass = true;
    }

    public void addField(String classIdIn, String nameIn, String sigIn, String offsetIn, String modifiersIn) {
        String classForField = null;
        if (!classIdIn.equals(this.id)) {
            classForField = classIdIn;
        }
        this.fields.add(new ClassField(classForField, nameIn, sigIn, offsetIn, modifiersIn));
    }

    public void addMethod(J9Method method) {
        this.methods.add(method);
    }

    public void addConstantPool(J9ConstantPool pool) {
        this.constantPool = pool;
    }

    public void addStatic(J9Static stat) {
        this.statics.add(stat);
    }

    public J9FieldIterator getFieldIterator(J9Class myClass) {
        J9FieldIterator fIt = new J9FieldIterator(myClass);
        return fIt;
    }

    public String getId() {
        return this.id;
    }

    public long getClassAddress() {
        return this.address;
    }

    public int getInstanceSize() {
        return this.instanceSize;
    }

    public String getLoader() {
        return this.loader;
    }

    public String getName() {
        if (null == this.name || this.isArrayClass) {
            if (this.isArrayClass) {
                String origName = this.name;
                this.name = "[";
                for (int i = 1; i < this.arrayClass.arity; ++i) {
                    this.name = this.name + "[";
                }
                long leaf = this.getLeaf();
                if (leaf != 0L) {
                    J9Class leafClass = J9JVMUtils.findClass(leaf);
                    this.name = leafClass != null ? this.name + leafClass.getName() : origName;
                    return this.name;
                }
                this.name = null;
            }
            return "!Unknown!";
        }
        return this.name;
    }

    public String getSuperId() {
        return this.superId;
    }

    public String toString() {
        int chainSize;
        this.findInheritanceChain();
        StringBuffer sb = new StringBuffer("\nname = " + this.name + "  id = " + this.id + " superId = " + this.superId + "  instanceSize = " + this.instanceSize + "  loader = " + this.loader + "\n");
        if (this.modifiers != 0) {
            sb.append("\tmodifiers: " + ClassField.convertModifier(this.modifiers) + "\n");
        }
        if ((chainSize = this.inheritanceChain.size()) > 0) {
            sb.append("\tInheritance chain....\n");
            for (int i = chainSize; i > -1; --i) {
                for (int j = chainSize - i + 2; j > 0; --j) {
                    sb.append("\t");
                }
                if (i != 0) {
                    sb.append(this.inheritanceChain.get(i - 1));
                } else {
                    sb.append(this.name);
                }
                sb.append("\n");
            }
        }
        Iterator iter = null;
        if (null != this.fields) {
            iter = this.fields.iterator();
            sb.append("\n\tFields......\n");
            while (iter.hasNext()) {
                ClassField field = (ClassField)iter.next();
                sb.append("\t" + field.toString() + "\n");
            }
        }
        if (null != this.statics) {
            iter = this.statics.iterator();
            sb.append("\n\tStatics......\n");
            while (iter.hasNext()) {
                J9Static stat = (J9Static)iter.next();
                sb.append("\t" + stat.toString() + "\n");
            }
        }
        if (null != this.statics) {
            iter = this.methods.iterator();
            sb.append("\n\tMethods......\n");
            while (iter.hasNext()) {
                J9Method method = (J9Method)iter.next();
                sb.append("\t" + method.toString() + "\n");
            }
        }
        return sb.toString();
    }

    private int testPrimitive() {
        for (int i = 0; i < primativeClasses.length; ++i) {
            if (!this.name.equals(primativeClasses[i])) continue;
            return primativeSizes[i];
        }
        return 0;
    }

    private byte setPrimitiveClassType() {
        byte byteRet = -1;
        for (int i = 0; i < primativeClasses.length; ++i) {
            if (!this.name.equals(primativeClasses[i])) continue;
            byteRet = (byte)i;
            return byteRet;
        }
        return byteRet;
    }

    public Vector getFields() {
        return this.fields;
    }

    public int getFieldOffset(String fieldName) {
        int retInt = -1;
        int fieldCount = this.fields.size();
        if (fieldCount > 0) {
            for (int i = 0; i < fieldCount; ++i) {
                ClassField f = (ClassField)this.fields.get(i);
                if (!f.getFieldName().equals(fieldName)) continue;
                return f.getOffset();
            }
        }
        return retInt;
    }

    public int[] getReferenceOffsets() {
        if (!this.bRefOffsetsProcessed) {
            int i;
            int fieldCount = this.getFieldCount();
            int[] temp = new int[fieldCount];
            int refCount = 0;
            for (i = 0; i < fieldCount; ++i) {
                String fieldSignature = ((ClassField)this.fields.get(i)).getSignature();
                if (!fieldSignature.startsWith("L")) continue;
                temp[refCount] = ((ClassField)this.fields.get(i)).getOffset();
                ++refCount;
            }
            this.bRefOffsetsProcessed = true;
            if (refCount > 0) {
                this.referenceOffsets = new int[refCount];
                for (i = 0; i < refCount; ++i) {
                    this.referenceOffsets[i] = temp[i];
                }
            }
        }
        return this.referenceOffsets;
    }

    public int getFieldCount() {
        return this.fields.size();
    }

    public String formatObject(long addr) {
        StringBuffer sb;
        block7: {
            sb = new StringBuffer();
            byte[] objectBytes = new byte[this.instanceSize];
            Dump theDump = DumpConsole.getTheDump();
            if (theDump.seekToMemoryAddress(addr) > 0L) {
                try {
                    int lengthRead = theDump.readEx(objectBytes);
                    if (this.instanceSize == lengthRead) {
                        for (ClassField field : this.fields) {
                            if (0 == ptrSize) {
                                ptrSize = theDump.is32bit() ? 4 : 8;
                            }
                            sb = sb.append("\n\t" + field.formatField(objectBytes, this.isLittleEndian, ptrSize));
                        }
                        break block7;
                    }
                    sb.append("Could not read enough memory at address 0x" + Long.toHexString(addr));
                }
                catch (IOException ioe) {
                    sb.append("IOException reading memory for address 0x" + Long.toHexString(addr));
                }
            } else {
                sb.append("Unable to read memory for address 0x" + Long.toHexString(addr));
            }
        }
        return sb.toString();
    }

    private void findInheritanceChain() {
        if (!this.bInheritanceChainProcessed) {
            this.bInheritanceChainProcessed = true;
            this.inheritanceChain = new Vector();
            J9Class currentClass = this;
            String superId = currentClass.getSuperId();
            while (superId != null) {
                long id = DumpUtils.parseLongHex(DumpUtils.stripOff0x(superId));
                currentClass = J9JVMConsole.getClass(id);
                if (null != currentClass) {
                    superId = currentClass.getSuperId();
                    this.inheritanceChain.add(currentClass.name);
                    continue;
                }
                superId = null;
            }
        }
    }

    public Vector getStatics() {
        return this.statics;
    }

    public boolean isArrayClass() {
        return this.isArrayClass;
    }

    public byte getArrayType() {
        return this.primitiveClassType;
    }

    public int getArity() {
        if (null == this.arrayClass) {
            return -1;
        }
        return this.arrayClass.arity;
    }

    public int getFirstElementOffset() {
        if (null == this.arrayClass) {
            return -1;
        }
        return this.arrayClass.firstElementOffset;
    }

    public int getSizeOffset() {
        if (null != this.arrayClass) {
            return this.arrayClass.sizeOffset;
        }
        if (this.name.equals("java/lang/Class")) {
            return this.instanceSize;
        }
        return -1;
    }

    public int getSizeBytes() {
        if (null == this.arrayClass) {
            return -1;
        }
        return this.arrayClass.sizeOffset;
    }

    public boolean isSizedAsElements() {
        if (null == this.arrayClass) {
            return false;
        }
        return this.arrayClass.bSizedAsElements;
    }

    public long getLeaf() {
        if (null == this.arrayClass) {
            return -1L;
        }
        return this.arrayClass.leaf;
    }

    public int getArrayElementSize() {
        return this.arrayElementSize;
    }

    public boolean isPrimitiveClass() {
        return this.isPrimitiveClass;
    }

    public boolean isPrimitiveArray() {
        if (null == this.arrayClass) {
            return false;
        }
        return this.arrayClass.isPrimitiveArray;
    }

    public Vector getMethods() {
        return this.methods;
    }

    public static void reworkArrayClassReworkList() {
        for (J9ArrayClass j9ac : arrayClassReworkList) {
            J9Class leafClass = J9JVMConsole.getClass(j9ac.leaf);
            if (null == leafClass) {
                Console.reportError("Array object has leafClass (leafIn) that was not found in the dump (xml error)", null);
                continue;
            }
            if (leafClass.isPrimitiveClass()) {
                j9ac.isPrimitiveArray = true;
                continue;
            }
            j9ac.myClass.arrayElementSize = -1;
        }
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public J9ConstantPool getConstantPool() {
        return this.constantPool;
    }

    public Vector getInterfaces() {
        return this.interfaces;
    }

    public void addInterface(String name) {
        this.interfaces.add(name);
    }

    class J9ArrayClass {
        long leaf = 0L;
        int arity;
        int firstElementOffset;
        int sizeOffset;
        int sizeBytes;
        boolean bSizedAsElements;
        boolean isPrimitiveArray;
        J9Class myClass;

        J9ArrayClass(String leafIn, String arityIn, String firstElementOffsetIn, String sizeOffsetIn, String sizeBytesIn, boolean bSizedAsElementsIn, J9Class classIn) {
            this.myClass = classIn;
            if (leafIn != null) {
                this.leaf = DumpUtils.parseLongHex(DumpUtils.stripOff0x(leafIn));
                J9Class leafClass = J9JVMConsole.getClass(this.leaf);
                if (null == leafClass) {
                    arrayClassReworkList.add(this);
                } else if (leafClass.isPrimitiveClass()) {
                    this.isPrimitiveArray = true;
                } else {
                    J9Class.this.arrayElementSize = -1;
                }
            } else {
                Console.reportError("Arrayclass element in xml has no leafClass in xml metadata", null);
            }
            this.arity = Integer.parseInt(DumpUtils.stripOff0x(arityIn), 16);
            this.firstElementOffset = Integer.parseInt(firstElementOffsetIn);
            this.sizeOffset = Integer.parseInt(sizeOffsetIn);
            this.sizeBytes = Integer.parseInt(sizeBytesIn);
            this.bSizedAsElements = bSizedAsElementsIn;
        }
    }
}

