/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.j9.dump.commandconsole;

import com.ibm.jvm.j9.dump.commandconsole.Console;
import com.ibm.jvm.j9.dump.commandconsole.DumpConsole;
import com.ibm.jvm.j9.dump.commandconsole.J9JVMConsole;
import com.ibm.jvm.j9.dump.systemdump.ClassField;
import com.ibm.jvm.j9.dump.systemdump.Dump;
import com.ibm.jvm.j9.dump.systemdump.J9Class;
import com.ibm.jvm.j9.dump.systemdump.J9Heap;
import com.ibm.jvm.j9.dump.systemdump.J9Object;
import java.io.IOException;
import java.util.Vector;

public class J9JVMUtils {
    public static final String badString = "!unable to establish! (dis os run?)";
    private static Dump theDump;
    private static int stringValueOffset;
    private static int stringOffsetOffset;
    private static int stringLengthOffset;

    public static J9Class findClass(String name) {
        return J9JVMConsole.getClass(name);
    }

    public static J9Class findClass(long address) {
        return J9JVMConsole.getClass(address);
    }

    private static J9Object getCharArrayFromString(J9Object o) {
        J9Object retObj = null;
        if (0 == stringValueOffset) {
            J9Class stringClass = J9JVMConsole.getClass("java/lang/String");
            if (null == stringClass) {
                Console.reportError("Error in establishing the java/lang/String class structure (bad xml?)\nA lot of commands are going to be affected by this.\nThis needs investigation!", null);
                return null;
            }
            Vector v = stringClass.getFields();
            for (int i = 0; i < v.size(); ++i) {
                ClassField field = (ClassField)v.get(i);
                if (!field.getFieldName().equals("value")) continue;
                stringValueOffset = field.getOffset();
            }
        }
        if (0 != stringValueOffset) {
            try {
                long charArrayAddress = theDump.readPtr(o.getObjectAddress() + (long)stringValueOffset);
                retObj = J9Heap.checkForObject(charArrayAddress);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return retObj;
    }

    private static int getOffsetFromString(J9Object o) {
        if (0 == stringOffsetOffset) {
            J9Class stringClass = J9JVMConsole.getClass("java/lang/String");
            if (null == stringClass) {
                Console.reportError("Error in establishing the java/lang/String class structue (bad xml?)\nA lot of commands are going to be affected bt this.\nThis needs investigation!!!!!!!!", null);
                return 0;
            }
            Vector v = stringClass.getFields();
            for (int i = 0; i < v.size(); ++i) {
                ClassField field = (ClassField)v.get(i);
                if (!field.getFieldName().equals("offset")) continue;
                stringOffsetOffset = field.getOffset();
            }
        }
        if (0 != stringOffsetOffset) {
            try {
                if (theDump.seekToMemoryAddress(o.getObjectAddress() + (long)stringOffsetOffset) > 0L) {
                    return theDump.readIntEx();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return 0;
    }

    private static int getLengthFromString(J9Object o) {
        if (0 == stringLengthOffset) {
            J9Class stringClass = J9JVMConsole.getClass("java/lang/String");
            if (null == stringClass) {
                Console.reportError("Error in establishing the java/lang/String class structure (bad xml?)\nA lot of commands are going to be affected by this.\nThis needs investigation!!!", null);
                return 0;
            }
            Vector v = stringClass.getFields();
            for (int i = 0; i < v.size(); ++i) {
                ClassField field = (ClassField)v.get(i);
                if (!field.getFieldName().equals("count")) continue;
                stringLengthOffset = field.getOffset();
            }
        }
        if (0 != stringLengthOffset) {
            try {
                if (theDump.seekToMemoryAddress(o.getObjectAddress() + (long)stringLengthOffset) > 0L) {
                    return theDump.readIntEx();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return 0;
    }

    private static String convertCharArrayObject(J9Object o, int offset, int len) {
        String retString = " !!! Unable to resolve string value !!!";
        int numberOfChars = o.getElementCount();
        if (0 == len && 0 == (len = numberOfChars)) {
            return null;
        }
        J9Class theClass = o.getClassForObject();
        if (0L != theDump.seekToMemoryAddress(o.getObjectAddress() + (long)theClass.getFirstElementOffset() + (long)(offset * 2))) {
            int amountToRead = Math.max(0, numberOfChars - offset) * 2;
            amountToRead = Math.min(amountToRead, 2 * len);
            byte[] ba = new byte[amountToRead];
            try {
                theDump.readEx(ba);
            }
            catch (IOException ioe) {
                // empty catch block
            }
            char[] normalisedBa = new char[amountToRead / 2];
            if (theDump.isLittleEndian()) {
                for (int i = 0; i < amountToRead; i += 2) {
                    normalisedBa[i / 2] = (char)(ba[i] | (char)ba[i + 1] << 8);
                }
            } else {
                for (int i = 0; i < amountToRead; i += 2) {
                    normalisedBa[i / 2] = (char)(ba[i + 1] | (char)ba[i] << 8);
                }
            }
            retString = new String(normalisedBa);
        }
        return retString;
    }

    public static String getStringValue(long StringObjectAddress) {
        return J9JVMUtils.getStringValue(StringObjectAddress, 0);
    }

    public static String getStringValue(long StringObjectAddress, int len) {
        String retString = badString;
        J9Object string = new J9Object(StringObjectAddress, -1);
        J9Object ca = J9JVMUtils.getCharArrayFromString(string);
        if (null != ca) {
            int offset = J9JVMUtils.getOffsetFromString(string);
            int length = J9JVMUtils.getLengthFromString(string);
            length = Math.min(len == 0 ? length : len, length);
            retString = J9JVMUtils.convertCharArrayObject(ca, offset, length);
        }
        return retString;
    }

    public static String analyseModifiers(int mods) {
        StringBuffer sb = new StringBuffer();
        return sb.toString();
    }

    static {
        stringValueOffset = 0;
        stringOffsetOffset = 0;
        stringLengthOffset = 0;
        theDump = DumpConsole.getTheDump();
    }
}

