/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.j9.dump.commandconsole;

import com.ibm.jvm.j9.dump.command.Command;
import com.ibm.jvm.j9.dump.command.J9JVMBaseCmds;
import com.ibm.jvm.j9.dump.commandconsole.DumpConsole;
import com.ibm.jvm.j9.dump.commandconsole.DumpUtils;
import com.ibm.jvm.j9.dump.commandconsole.DvNamesIndexFile;
import com.ibm.jvm.j9.dump.systemdump.GenericThread;
import com.ibm.jvm.j9.dump.systemdump.J9Class;
import com.ibm.jvm.j9.dump.systemdump.J9ClassLoader;
import com.ibm.jvm.j9.dump.systemdump.J9Gpf;
import com.ibm.jvm.j9.dump.systemdump.J9Heap;
import com.ibm.jvm.j9.dump.systemdump.J9Method;
import com.ibm.jvm.j9.dump.systemdump.J9Monitor;
import com.ibm.jvm.j9.dump.systemdump.J9Object;
import com.ibm.jvm.j9.dump.systemdump.J9TraceBuffer;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Vector;

public class J9JVMConsole
extends DumpConsole {
    private static J9JVMConsole mySelf;
    protected static J9Gpf gpfData;
    protected static HashMap knownClassesByName;
    protected static HashMap knownClassesById;
    protected static HashMap knownClassLoadersByID;
    protected static HashMap codeIds;
    protected static Vector knownHeaps;
    protected static DvNamesIndexFile namesFile;
    protected static Vector knownMonitors;
    protected static HashMap knownMonitorsByName;
    protected static HashMap knownMonitorsById;
    protected static HashMap LockedObjectsByAddress;
    protected static HashMap knownThreadsById;
    private static Vector traceBuffers;
    private static long traceFileHeaderAddress;
    private static int traceFileHeaderLength;
    private static String wParm;
    private static String iParm;
    private static String oParm;
    private static String dParm;
    private static String mParm;
    private static String jitVersion;
    private static PropertyResourceBundle helpData;

    public J9JVMConsole(String aTitle, boolean bStartMainLoop) {
        super(aTitle, false);
        mySelf = this;
        J9JVMBaseCmds baseCmds = new J9JVMBaseCmds();
        Command[] baseCommandSet = baseCmds.getCommandSet();
        J9JVMConsole.registerCommandSet(baseCommandSet);
        baseCmds.addObserver(mySelf);
        try {
            helpData = (PropertyResourceBundle)ResourceBundle.getBundle("com.ibm.jvm.j9.dump.command.J9JVMBaseCmdsHelp");
        }
        catch (MissingResourceException mre) {
            // empty catch block
        }
        if (null != helpData) {
            J9JVMConsole.addHelp(helpData);
        }
        baseCmds.addObserver(mySelf);
        Method argsProcessingMethod = null;
        try {
            argsProcessingMethod = this.getClass().getMethod("processArgs", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        this.setArgsProcessorMethod(argsProcessingMethod);
        if (bStartMainLoop) {
            J9JVMConsole.mainLoop();
        }
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            String retString;
            File possFile;
            if (args.length == 1 && !args[0].startsWith("-") && !(possFile = new File(args[0])).exists()) {
                J9JVMConsole.doOutput("\n\"" + possFile + "\" is not an existent file - invalid invocation\n");
                J9JVMConsole.doOutput(J9JVMConsole.usageInfo());
                System.exit(0);
            }
            if (null != (retString = J9JVMConsole.analyseArgs(args))) {
                J9JVMConsole.doOutput("\n" + retString + "\n");
                J9JVMConsole.doOutput(J9JVMConsole.usageInfo());
                System.exit(0);
            }
        }
        J9JVMConsole x = new J9JVMConsole("J9 Dump Analysis", true);
    }

    public static void processArgs() {
        int pos;
        Object output;
        String in;
        J9JVMConsole.doOutput("\nPlease wait while I process inbound arguments\n");
        String out = null;
        if (null != wParm) {
            in = "SET WORKDIR " + wParm;
            output = null;
            J9JVMConsole.doOutput("\n\t" + in);
            pos = J9JVMConsole.findVerbNounCombo(in.toUpperCase());
            if (pos != -1 && null != (out = J9JVMConsole.doCommand(pos, in, null))) {
                J9JVMConsole.doOutput("\n\t\t" + out);
            }
        }
        if (null != oParm) {
            in = "SET OUTPUT " + oParm;
            output = null;
            J9JVMConsole.doOutput("\n\t" + in);
            pos = J9JVMConsole.findVerbNounCombo(in.toUpperCase());
            if (pos != -1 && null != (out = J9JVMConsole.doCommand(pos, in, null))) {
                J9JVMConsole.doOutput("\n\t\t" + out);
            }
        }
        if (null != dParm) {
            in = "SET DUMP " + dParm;
            output = null;
            J9JVMConsole.doOutput("\n\t" + in);
            pos = J9JVMConsole.findVerbNounCombo(in.toUpperCase());
            if (pos != -1 && null != (out = J9JVMConsole.doCommand(pos, in, null))) {
                J9JVMConsole.doOutput("\n\t\t" + out);
            }
        }
        if (null != mParm) {
            in = "SET METADATA " + mParm;
            output = null;
            J9JVMConsole.doOutput("\n\t" + in);
            pos = J9JVMConsole.findVerbNounCombo(in.toUpperCase());
            if (pos != -1 && null != (out = J9JVMConsole.doCommand(pos, in, null))) {
                J9JVMConsole.doOutput("\n\t\t" + out);
            }
        }
        if (null != iParm) {
            in = "EX " + iParm;
            output = null;
            J9JVMConsole.doOutput("\n\t" + in);
            pos = J9JVMConsole.findVerbNounCombo(in.toUpperCase());
            if (pos != -1 && null != (out = J9JVMConsole.doCommand(pos, in, null))) {
                J9JVMConsole.doOutput("\n\t\t" + out);
            }
        }
    }

    private static String analyseArgs(String[] args) {
        String retString = null;
        String validParms = "dwioDWIO";
        if (args.length != 0) {
            if (args.length == 1 && !args[0].startsWith("-")) {
                if (args[0].equals("?")) {
                    retString = J9JVMConsole.usageInfo();
                } else {
                    dParm = args[0];
                }
            } else {
                for (int i = 0; i < args.length; ++i) {
                    if (args[i].startsWith("-")) {
                        String temp = args[i].substring(1);
                        String firstChar = temp.substring(0, 1);
                        if (-1 == validParms.indexOf(firstChar)) {
                            return "Invalid invocation -" + firstChar + " parameter invalid ";
                        }
                        if (firstChar != null) {
                            if ((firstChar = firstChar.toUpperCase()).equals("D")) {
                                dParm = temp.substring(1);
                                continue;
                            }
                            if (firstChar.equals("I")) {
                                iParm = temp.substring(1);
                                continue;
                            }
                            if (firstChar.equals("O")) {
                                oParm = temp.substring(1);
                                continue;
                            }
                            if (!firstChar.equals("W")) continue;
                            wParm = temp.substring(1);
                            continue;
                        }
                        return "Invalid invocation -" + firstChar + "invalid ";
                    }
                    if (i == args.length - 1) {
                        dParm = args[i];
                        continue;
                    }
                    return "Invalid invocation (embedded argument not starting with -)";
                }
            }
        }
        return retString;
    }

    private static String usageInfo() {
        StringBuffer sb = new StringBuffer();
        sb.append("Usage info:");
        sb.append("\n\n   jdmpview [-ddumpfilename] [-wworkdir] [-ooutput][-iinput]");
        sb.append("\n\n   where...");
        sb.append("\n     dumpfilename identifies a dumpfile");
        sb.append("\n     workdir identifies a writeable directory");
        sb.append("\n     output identifies an output file (format x:\\myfile)");
        sb.append("\n     input identifies an input command file (format x:\\myfile)");
        sb.append("\n\n   Notes: \"jdmpview dumpfilename\" is also valid");
        sb.append("\n          No spaces between the parameter identifier and their value.");
        sb.append("\n\n          jdmpview can also open zip files output by jextract");
        sb.append("\n          if <zipfilename> is the same as <dumpfilename>.zip");
        sb.append("\n          In this case use \"jdmpview zipfilename\"");
        return sb.toString();
    }

    public static int addCodeId(J9Method m) {
        Long id = new Long(m.getId());
        codeIds.put(id, m);
        return 0;
    }

    public static String findMethod(String id) {
        String retString = null;
        long longId = DumpUtils.parseLongHex(id);
        Long search = new Long(longId);
        J9Method m = (J9Method)codeIds.get(search);
        if (m != null) {
            J9Class methodClass = m.getMyClass();
            retString = methodClass != null ? methodClass.getName() + "::" + m.getMethodName() + m.getSignature() : "?????????::" + m.getMethodName() + m.getSignature();
        }
        return retString;
    }

    public static int addJitCodeId(J9Method m) {
        Long id = new Long(m.getJitId());
        codeIds.put(id, m);
        return 0;
    }

    public static void addClass(J9Class c) {
        knownClassesByName.put(c.getName(), c);
        knownClassesById.put(c.getId(), c);
    }

    public static void addClassLoader(J9ClassLoader cl) {
        knownClassLoadersByID.put(cl.getId(), cl);
    }

    public static void addHeap(J9Heap h) {
        knownHeaps.add(h);
    }

    public static J9ClassLoader getClassLoader(String id) {
        return (J9ClassLoader)knownClassLoadersByID.get(id);
    }

    public static J9Class getClass(String name) {
        return (J9Class)knownClassesByName.get(name);
    }

    public static J9Class getClass(long address) {
        String temp = Long.toHexString(address);
        return (J9Class)knownClassesById.get("0x" + temp);
    }

    public static Vector getKnownHeaps() {
        return knownHeaps;
    }

    public static DvNamesIndexFile getNamesFile() {
        return namesFile;
    }

    public static void setNamesFile(DvNamesIndexFile file) {
        namesFile = file;
    }

    public static J9Monitor getMonitor(String name) {
        return (J9Monitor)knownMonitorsByName.get(name);
    }

    public static J9Monitor getMonitor(long id) {
        String temp = Long.toHexString(id);
        return (J9Monitor)knownMonitorsById.get("0x" + temp);
    }

    public static Vector getKnownMonitors() {
        return knownMonitors;
    }

    public static void addMonitor(J9Monitor m) {
        knownMonitors.add(m);
        knownMonitorsByName.put(m.getName(), m);
        knownMonitorsById.put(m.getIdAsString(), m);
    }

    public static Object isThisAMonitor(long id) {
        Object retString = null;
        J9Monitor retMon = (J9Monitor)knownMonitorsById.get("0x" + Long.toHexString(id));
        if (null == retMon) {
            for (J9Monitor mon : knownMonitorsById.values()) {
                long idOfThisOne = mon.getId();
                if (id - idOfThisOne > 32L || id - idOfThisOne <= 0L) continue;
                return "This is close to a monitor (" + mon.getName() + " @" + mon.getIdAsString();
            }
        }
        return retMon;
    }

    public static HashMap getKnownClassesByName() {
        return knownClassesByName;
    }

    public static void addLockedObject(J9Object o) {
        LockedObjectsByAddress.put(new Long(o.getObjectAddress()), o);
    }

    public static HashMap getLockedObjectsByAddress() {
        return LockedObjectsByAddress;
    }

    public static Vector getLockedObjectsByThread(GenericThread t) {
        Vector<J9Object> vRet = new Vector<J9Object>();
        for (J9Object o : LockedObjectsByAddress.values()) {
            if (o.getLockInfo() >>> 4 << 4 != DumpUtils.parseLongHex(t.getThreadId())) continue;
            vRet.add(o);
        }
        return vRet;
    }

    public static GenericThread getKnownThread(long tid) {
        String threadId = "0x" + Long.toHexString(tid);
        return J9JVMConsole.getKnownThread(threadId);
    }

    public static GenericThread getKnownThread(String tid) {
        return (GenericThread)knownThreadsById.get(tid);
    }

    public static Vector getTraceBuffers() {
        return traceBuffers;
    }

    public static void addTraceBuffer(String buffAddress, String buffSize, String buffLinkOffset, String buffDataOffset, String buffTerminator) {
        long terminator = DumpUtils.parseLongHex(DumpUtils.stripOff0x(buffTerminator));
        long startAddress = DumpUtils.parseLongHex(DumpUtils.stripOff0x(buffAddress));
        int bufferSize = Integer.parseInt(buffSize);
        int linkOffset = Integer.parseInt(buffLinkOffset);
        int dataOffset = Integer.parseInt(buffDataOffset);
        long buffStart = 0L;
        boolean bDone = false;
        if (0L == startAddress) {
            bDone = true;
        }
        while (!bDone) {
            buffStart = startAddress + (long)dataOffset;
            J9TraceBuffer j9tb = new J9TraceBuffer(buffStart, bufferSize);
            traceBuffers.add(j9tb);
            try {
                if ((startAddress = theDump.readPtr(startAddress + (long)linkOffset)) != 0L) continue;
                bDone = true;
            }
            catch (IOException ioe) {
                J9JVMConsole.reportError("Error encountered analysing trace buffers chain", ioe);
                bDone = true;
            }
        }
    }

    public static long getTraceFileHeaderAddress() {
        return traceFileHeaderAddress;
    }

    public static void setTraceFileHeaderAddress(long traceFileHeaderAddressIn) {
        traceFileHeaderAddress = traceFileHeaderAddressIn;
    }

    public static int getTraceFileHeaderLength() {
        return traceFileHeaderLength;
    }

    public static void setTraceFileHeaderLength(int traceFileHeaderLengthIn) {
        traceFileHeaderLength = traceFileHeaderLengthIn;
    }

    public static String getJitVersion() {
        return jitVersion;
    }

    public static void setJitVersion(String jitVersion) {
        J9JVMConsole.jitVersion = jitVersion;
    }

    public static void addThread(GenericThread thread) {
        knownThreadsById.put(thread.getThreadId(), thread);
    }

    public static void setFailingThread(String threadId, String nativeId) {
        gpfData.setFailingThread(threadId);
        gpfData.setFailingNativeThread(nativeId);
    }

    public static String getFailingThreadId() {
        return gpfData.getFailingThread();
    }

    public static String getFailingNativeThreadId() {
        return gpfData.getFailingNativeThread();
    }

    static {
        gpfData = new J9Gpf();
        knownClassesByName = new HashMap();
        knownClassesById = new HashMap();
        knownClassLoadersByID = new HashMap();
        codeIds = new HashMap();
        knownHeaps = new Vector();
        knownMonitors = new Vector();
        knownMonitorsByName = new HashMap();
        knownMonitorsById = new HashMap();
        LockedObjectsByAddress = new HashMap();
        knownThreadsById = new HashMap();
        traceBuffers = new Vector();
    }
}

