/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.j9.dump.command.heapdump.PortableHeapDumpModel;

import com.ibm.jvm.j9.dump.command.heapdump.PortableHeapDumpModel.PortableHeapDumpClassCache;
import com.ibm.jvm.j9.dump.command.heapdump.PortableHeapDumpModel.PortableHeapDumpHandler;
import com.ibm.jvm.j9.dump.command.heapdump.PortableHeapDumpModel.PortableHeapDumpHeader;
import com.ibm.jvm.j9.dump.command.heapdump.PortableHeapDumpModel.PortableHeapDumpIO;
import com.ibm.jvm.j9.dump.command.heapdump.PortableHeapDumpModel.PortableHeapDumpRecord;
import com.ibm.jvm.j9.dump.systemdump.Dump;
import com.ibm.jvm.j9.dump.systemdump.J9Class;
import com.ibm.jvm.j9.dump.systemdump.J9Object;
import com.ibm.jvm.j9.dump.systemdump.J9ObjectIterator;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;

public class PortableHeapDump
implements PortableHeapDumpIO {
    public static boolean DEBUG = false;
    public static PrintStream DEBUG_STREAM = System.err;
    public static String DEBUG_FILENAME = "heapdump.debug";
    public static final boolean DEBUG_SUMMARY = false;
    public static final String DEBUG_SUMMARY_OUTPUT = "d:\\debugouthd.txt";
    public static final byte START_OF_HEADER = 1;
    public static final byte END_OF_HEADER = 2;
    public static final byte START_OF_DUMP = 2;
    public static final byte END_OF_DUMP = 3;
    public static final String MAGIC_STRING = "portable heap dump";
    public static final int VERSION_NUMBER = 4;
    public static int classRecords;
    private int flags;
    private PortableHeapDumpHeader header;
    private ArrayList dumpRecords;
    private boolean is32bit = true;
    boolean isLittleEndian;
    private boolean isJ9 = true;
    private static PortableHeapDump currentPortableHeapDumpinstance;
    private Dump j9Dump;

    public PortableHeapDump(Dump dump, boolean is32bit, boolean isLittleEndian) {
        this.j9Dump = dump;
        this.is32bit = is32bit;
        this.isLittleEndian = isLittleEndian;
        currentPortableHeapDumpinstance = this;
    }

    public PortableHeapDump(Dump dump, boolean is32bit, boolean isLittleEndian, boolean isJ9) {
        this(dump, is32bit, isLittleEndian);
        this.isJ9 = isJ9;
    }

    public static void main(String[] args) {
    }

    private static int writeDumpRecords(J9ObjectIterator iter, DataOutput dos) throws IOException {
        Object fos = null;
        Object ps = null;
        PortableHeapDumpClassCache classCache = new PortableHeapDumpClassCache();
        J9Object current = null;
        J9Object previous = null;
        int numObj = 0;
        classRecords = 0;
        while (iter.hasNext()) {
            current = (J9Object)iter.next();
            if (DEBUG) {
                DEBUG_STREAM.print("Object number = " + numObj + " ");
            }
            J9Class currentObjectClass = current.getClassForObject();
            boolean isArray = current.isArray();
            boolean isClass = current.isInstanceOfClass();
            byte cacheIndex = -1;
            if (!isArray && !isClass) {
                cacheIndex = classCache.getClassCacheIndex(current.getClassForObject());
            }
            if (isArray) {
                PortableHeapDumpRecord.writeArrayRecord(dos, current, previous);
            } else if (isClass) {
                ++classRecords;
                PortableHeapDumpRecord.writeClassRecord(dos, current, previous);
            } else {
                if (cacheIndex == -1) {
                    classCache.setClassCacheIndex(current.getClassForObject());
                }
                PortableHeapDumpRecord.writeObjectRecord(dos, current, previous, cacheIndex);
            }
            previous = current;
            ++numObj;
        }
        return numObj;
    }

    public int writeHeapDump(DataOutput dos) throws IOException {
        J9ObjectIterator objectIterator = J9ObjectIterator.getObjectIterator(null);
        return this.writeHeapDump(objectIterator, dos);
    }

    private int writeHeapDump(J9ObjectIterator objectIterator, DataOutput dos) throws IOException {
        dos.writeUTF(MAGIC_STRING);
        dos.writeInt(4);
        int magicHeaderFlag = 0;
        if (!PortableHeapDump.is32bit()) {
            magicHeaderFlag = 1;
        }
        if (PortableHeapDump.isJ9()) {
            magicHeaderFlag += 6;
        }
        dos.writeInt(magicHeaderFlag);
        PortableHeapDumpHeader header = new PortableHeapDumpHeader(this.j9Dump);
        dos.writeByte(1);
        header.writeHeapDump(dos);
        dos.writeByte(2);
        dos.writeByte(2);
        int objectCount = PortableHeapDump.writeDumpRecords(objectIterator, dos);
        dos.writeByte(3);
        if (DEBUG) {
            DEBUG_STREAM.println("Number of ClassRecords processed = " + classRecords);
        }
        return objectCount;
    }

    public void readHeapDump(DataInput dis, PortableHeapDumpHandler phdh) {
        try {
            String magic = dis.readUTF();
            if (!magic.equals(MAGIC_STRING)) {
                phdh.exceptionDetected(new IOException("Magic String not found"));
            }
            int version = dis.readInt();
            int flag = dis.readInt();
            phdh.magicInfo(version, flag);
            if (dis.readByte() == 1) {
                phdh.startOfHeader();
            } else {
                phdh.exceptionDetected(new IOException("start of header not found"));
            }
            PortableHeapDumpHeader.readHeapDump(dis, phdh);
            if (dis.readByte() == 2) {
                phdh.endOfHeader();
            } else {
                phdh.exceptionDetected(new IOException("end of header not found"));
            }
            if (dis.readByte() == 2) {
                phdh.startOfDump();
            } else {
                phdh.exceptionDetected(new IOException("start of dump not found"));
            }
            PortableHeapDumpRecord.readObjectRecords(dis, phdh);
        }
        catch (Exception e) {
            phdh.exceptionDetected(e);
        }
    }

    public static boolean isJ9() {
        return PortableHeapDump.currentPortableHeapDumpinstance.isJ9;
    }

    public static boolean is32bit() {
        return PortableHeapDump.currentPortableHeapDumpinstance.is32bit;
    }

    public static boolean isDEBUG() {
        return DEBUG;
    }

    public static void setDEBUG(boolean debug) {
        DEBUG = debug;
    }

    static {
        currentPortableHeapDumpinstance = null;
    }
}

