/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.j9.dump.command.heapdump.PortableHeapDumpModel;

import com.ibm.jvm.j9.dump.command.heapdump.PortableHeapDumpModel.PortableHeapDump;
import com.ibm.jvm.j9.dump.command.heapdump.PortableHeapDumpModel.PortableHeapDumpClassCache;
import com.ibm.jvm.j9.dump.command.heapdump.PortableHeapDumpModel.PortableHeapDumpHandler;
import com.ibm.jvm.j9.dump.command.heapdump.PortableHeapDumpModel.PortableHeapDumpRecord;
import com.ibm.jvm.j9.dump.systemdump.J9Object;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class MediumObjectRecord
extends PortableHeapDumpRecord {
    public static final byte MAGIC_NUMBER = 64;
    private byte gapSize;
    private short gapPreceding;
    private long addressofClass;
    private short hashcode;

    public MediumObjectRecord(J9Object current, J9Object previous) {
        this.tag = (byte)64;
        this.setReferences(current);
        this.addressofClass = current.getClassForObject().getClassAddress();
        this.gapPreceding = (short)MediumObjectRecord.getAddressDifference(current, previous);
        if (this.gapPreceding > Short.MAX_VALUE) {
            throw new IllegalArgumentException("address differences is too big - need long record");
        }
        this.gapSize = MediumObjectRecord.sizeofReference(this.gapPreceding);
    }

    public void writeHeapDump(DataOutput dos) throws IOException {
        byte tagAndFlag = this.tag;
        tagAndFlag = (byte)(tagAndFlag | this.References.length << 3);
        tagAndFlag = (byte)(tagAndFlag | this.gapSize << 2);
        tagAndFlag = (byte)(tagAndFlag | this.referenceSize);
        dos.writeByte(tagAndFlag);
        if (PortableHeapDump.DEBUG) {
            PortableHeapDump.DEBUG_STREAM.println(" tag = " + tagAndFlag + " gapsize = " + this.gapSize + " references size =" + this.referenceSize);
        }
        this.writeReference(dos, this.gapSize, this.gapPreceding);
        if (PortableHeapDump.is32bit()) {
            dos.writeInt((int)this.addressofClass);
        } else {
            dos.writeLong(this.addressofClass);
        }
        if (PortableHeapDump.isJ9()) {
            dos.writeShort(this.hashcode);
        }
        this.writeReferences(dos);
    }

    public short getHashcode() {
        return this.hashcode;
    }

    public void setHashcode(short hashcode) {
        this.hashcode = hashcode;
    }

    public static void readHeapDump(DataInput dis, byte flag, PortableHeapDumpHandler phdh, PortableHeapDumpClassCache phdcc) {
    }
}

